/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.util;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ViewUtility {
    private static Font font;

    private static Font getFont() {
        if (font == null) {
            font = new Font((Device)Display.getCurrent(), "ms sans serif", 8, 0);
        }
        return font;
    }

    public static void setComposite(Composite comp) {
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(ViewUtility.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Composite createComposite(Composite parent, int numColumns, boolean horizontalFill) {
        if (!horizontalFill) {
            ViewUtility.createComposite(parent, numColumns);
        }
        Composite composite = new Composite(parent, 0);
        composite.setFont(ViewUtility.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Label createHorizontalFiller(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public Label createLabel(Composite parent, int style, String text) {
        Label label = new Label(parent, style);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int alignment) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = alignment;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createCheckBox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Combo createComboBox(Composite parent) {
        return ViewUtility.createComboBox(parent, true);
    }

    public static Combo createComboBox(Composite parent, boolean isReadOnly) {
        int style = isReadOnly ? 8 : 4;
        Combo combo = new Combo(parent, style);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public static Text createTextField(Composite parent, int width) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = width;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createWrappedMultiTextField(Composite parent, int width, int numLines, boolean verticalFill) {
        Text text = new Text(parent, 2626);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (verticalFill) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        data.widthHint = width;
        FontData[] fontData = ViewUtility.getFont().getFontData();
        data.heightHint = numLines * fontData[0].getHeight();
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createMultiTextField(Composite parent, int width, int height, boolean verticalFill) {
        Text text = new Text(parent, 2818);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (verticalFill) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        data.widthHint = width;
        data.heightHint = height;
        text.setLayoutData((Object)data);
        return text;
    }
}

