/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.filters;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.ui.util.SearchPattern;
import org.eclipse.php.profile.core.data.ProfilerClassData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.ui.views.TreeElement;

public class ExecutionStatisticsFilterCondition
extends ViewerFilter
implements IXMLPreferencesStorable {
    public static final String ATTR_FILE_NAME = "File Name";
    public static final String ATTR_FILE_TOTAL_TIME = "File Total Time";
    public static final String ATTR_CLASS_NAME = "Class Name";
    public static final String ATTR_CLASS_TOTAL_TIME = "Class Total Time";
    public static final String ATTR_FUNCTION_NAME = "Function Name";
    public static final String ATTR_FUNCTION_TOTAL_TIME = "Function Total Time";
    public static final String ATTR_FUNCTION_AVERAGE_OWN_TIME = "Function Average Own Time";
    public static final String ATTR_FUNCTION_OWN_TIME = "Function Own Time";
    public static final String ATTR_FUNCTION_OTHERS_TIME = "Function Others Time";
    public static final String ATTR_FUNCTION_CALLS_COUNT = "Function Calls Count";
    public static final String OP_EQUALS = "equals";
    public static final String OP_NOT_EQUALS = "not equals";
    public static final String OP_MATCHES = "matches";
    public static final String OP_DOESNT_MATCH = "doesn't match";
    public static final String OP_LESS_THAN = "less than";
    public static final String OP_MORE_THAN = "more than";
    private String fAttribute;
    private String fOperator;
    private String fValue;

    public ExecutionStatisticsFilterCondition() {
    }

    public ExecutionStatisticsFilterCondition(String attribute, String operator, String value) {
        this.fAttribute = attribute;
        this.fOperator = operator;
        this.fValue = value;
    }

    public String getAttribute() {
        return this.fAttribute;
    }

    public void setAttribute(String attribute) {
        this.fAttribute = attribute;
    }

    public String getOperator() {
        return this.fOperator;
    }

    public void setOperator(String operator) {
        this.fOperator = operator;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public Map<String, Object> storeToMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("attribute", this.fAttribute);
        map.put("operator", this.fOperator);
        map.put("value", this.fValue);
        return map;
    }

    public void restoreFromMap(Map<String, Object> map) {
        this.fAttribute = (String)map.get("attribute");
        this.fOperator = (String)map.get("operator");
        this.fValue = (String)map.get("value");
    }

    private boolean evalOperator(String operator, String str1, String str2) {
        if (OP_DOESNT_MATCH.equals(this.fOperator)) {
            return !SearchPattern.match((String)str2, (String)str1, (boolean)false, (boolean)false);
        }
        if (OP_MATCHES.equals(this.fOperator)) {
            return SearchPattern.match((String)str2, (String)str1, (boolean)false, (boolean)false);
        }
        if (OP_NOT_EQUALS.equals(this.fOperator)) {
            return !str2.equals(str1);
        }
        if (OP_EQUALS.equals(this.fOperator)) {
            return str2.equals(str1);
        }
        return false;
    }

    private boolean evalOperator(String operator, double d1, double d2) {
        if (OP_LESS_THAN.equals(this.fOperator)) {
            return d1 < d2;
        }
        if (OP_MORE_THAN.equals(this.fOperator)) {
            return d1 > d2;
        }
        if (OP_NOT_EQUALS.equals(this.fOperator)) {
            return d1 != d2;
        }
        if (OP_EQUALS.equals(this.fOperator)) {
            return d1 == d2;
        }
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        TreeElement treeElement = (TreeElement)element;
        Object data = treeElement.getData();
        if (ATTR_FILE_NAME.equals(this.fAttribute)) {
            if (data instanceof ProfilerFileData) {
                ProfilerFileData fileData = (ProfilerFileData)data;
                return this.evalOperator(this.fOperator, fileData.getName(), this.fValue);
            }
        } else if (ATTR_FILE_TOTAL_TIME.equals(this.fAttribute)) {
            if (data instanceof ProfilerFileData) {
                ProfilerFileData fileData = (ProfilerFileData)data;
                return this.evalOperator(this.fOperator, fileData.getTotalOwnTime(), Double.parseDouble(this.fValue));
            }
        } else if (ATTR_CLASS_NAME.equals(this.fAttribute)) {
            if (data instanceof ProfilerClassData) {
                ProfilerClassData classData = (ProfilerClassData)data;
                return this.evalOperator(this.fOperator, classData.getName(), this.fValue);
            }
        } else if (ATTR_CLASS_TOTAL_TIME.equals(this.fAttribute)) {
            if (data instanceof ProfilerClassData) {
                ProfilerClassData classData = (ProfilerClassData)data;
                return this.evalOperator(this.fOperator, classData.getTotalOwnTime(), Double.parseDouble(this.fValue));
            }
        } else if (ATTR_FUNCTION_NAME.equals(this.fAttribute)) {
            if (data instanceof ProfilerFunctionData) {
                ProfilerFunctionData functionData = (ProfilerFunctionData)data;
                return this.evalOperator(this.fOperator, functionData.getFunctionName(), this.fValue);
            }
        } else if (ATTR_FUNCTION_AVERAGE_OWN_TIME.equals(this.fAttribute)) {
            if (data instanceof ProfilerFunctionData) {
                ProfilerFunctionData functionData = (ProfilerFunctionData)data;
                return this.evalOperator(this.fOperator, functionData.getOwnTime() / (double)functionData.getCallsCount(), Double.parseDouble(this.fValue));
            }
        } else if (ATTR_FUNCTION_OWN_TIME.equals(this.fAttribute)) {
            if (data instanceof ProfilerFunctionData) {
                ProfilerFunctionData functionData = (ProfilerFunctionData)data;
                return this.evalOperator(this.fOperator, functionData.getOwnTime(), Double.parseDouble(this.fValue));
            }
        } else if (ATTR_FUNCTION_OTHERS_TIME.equals(this.fAttribute)) {
            if (data instanceof ProfilerFunctionData) {
                ProfilerFunctionData functionData = (ProfilerFunctionData)data;
                return this.evalOperator(this.fOperator, functionData.getTotalTime() - functionData.getOwnTime(), Double.parseDouble(this.fValue));
            }
        } else if (ATTR_FUNCTION_TOTAL_TIME.equals(this.fAttribute)) {
            if (data instanceof ProfilerFunctionData) {
                ProfilerFunctionData functionData = (ProfilerFunctionData)data;
                return this.evalOperator(this.fOperator, functionData.getTotalTime(), Double.parseDouble(this.fValue));
            }
        } else if (ATTR_FUNCTION_CALLS_COUNT.equals(this.fAttribute) && data instanceof ProfilerFunctionData) {
            ProfilerFunctionData functionData = (ProfilerFunctionData)data;
            return this.evalOperator(this.fOperator, functionData.getCallsCount(), Double.parseDouble(this.fValue));
        }
        return true;
    }
}

