/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.core.runtime.JSRuntimeWorkingCopy;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;

public abstract class AbstractRuntimeInstallPage
extends WizardPage {
    private String fOriginalName = null;
    private IStatus fNameStatus = Status.OK_STATUS;
    private String[] fExistingNames;

    protected AbstractRuntimeInstallPage(String pageName) {
        super(pageName);
    }

    protected AbstractRuntimeInstallPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public abstract boolean finish();

    public abstract JSRuntimeWorkingCopy getSelection();

    public void setSelection(JSRuntimeWorkingCopy runtime) {
        this.fOriginalName = runtime.getName();
    }

    protected void nameChanged(String newName) {
        this.fNameStatus = Status.OK_STATUS;
        if (newName == null || newName.trim().length() == 0) {
            int sev = 4;
            if (this.fOriginalName == null || this.fOriginalName.length() == 0) {
                sev = 2;
            }
            this.fNameStatus = new Status(sev, JavaScriptPlugin.getPluginId(), PreferencesMessages.AbstractRuntimeInstallPage_MissingRuntimeName_Message);
        } else if (this.isDuplicateName(newName)) {
            this.fNameStatus = new Status(4, JavaScriptPlugin.getPluginId(), NLS.bind((String)PreferencesMessages.AbstractRuntimeInstallPage_DuplicateName_Error, (Object)newName));
        } else {
            IStatus s = ResourcesPlugin.getWorkspace().validateName(newName, 1);
            if (!s.isOK()) {
                this.fNameStatus = new Status(4, JavaScriptPlugin.getPluginId(), NLS.bind((String)PreferencesMessages.AbstractRuntimeInstallPage_InvalidFileName_Error, (Object)s.getMessage()));
            }
        }
        this.updatePageStatus();
    }

    private boolean isDuplicateName(String name) {
        if (this.fExistingNames != null) {
            int i = 0;
            while (i < this.fExistingNames.length) {
                if (name.equals(this.fExistingNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setExistingNames(String[] names) {
        this.fExistingNames = names;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    protected void setStatusMessage(IStatus status) {
        if (status.isOK()) {
            this.setMessage(status.getMessage());
        } else {
            switch (status.getSeverity()) {
                case 4: {
                    this.setMessage(status.getMessage(), 3);
                    break;
                }
                case 1: {
                    this.setMessage(status.getMessage(), 1);
                    break;
                }
                case 2: {
                    this.setMessage(status.getMessage(), 2);
                    break;
                }
            }
        }
    }

    protected IStatus getNameStatus() {
        return this.fNameStatus;
    }

    protected void updatePageStatus() {
        IStatus max = Status.OK_STATUS;
        IStatus[] vmStatus = this.getRuntimeStatus();
        int i = 0;
        while (i < vmStatus.length) {
            IStatus status = vmStatus[i];
            if (status.getSeverity() > max.getSeverity()) {
                max = status;
            }
            ++i;
        }
        if (this.fNameStatus.getSeverity() > max.getSeverity()) {
            max = this.fNameStatus;
        }
        if (max.isOK()) {
            this.setMessage(null, 0);
        } else {
            this.setStatusMessage(max);
        }
        this.setPageComplete(max.isOK() || max.getSeverity() == 1);
    }

    protected abstract IStatus[] getRuntimeStatus();
}

