/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.factory;

import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.factory.InterruptibleFactory;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class SafeInterruptibleFactoryWrapper<T>
implements InterruptibleFactory<T> {
    private final InterruptibleFactory<? extends T> factory;
    private final ExceptionHandler exceptionHandler;
    private final T exceptionValue;

    public SafeInterruptibleFactoryWrapper(InterruptibleFactory<? extends T> factory, ExceptionHandler exceptionHandler, T exceptionOutput) {
        if (factory == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
        this.exceptionHandler = exceptionHandler;
        this.exceptionValue = exceptionOutput;
    }

    @Override
    public T create() throws InterruptedException {
        try {
            return this.factory.create();
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
            return this.exceptionValue;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.factory);
    }
}

