/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.hyperlink;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.jsdt.web.ui.internal.hyperlink.ExternalFileHyperlink;
import org.eclipse.wst.jsdt.web.ui.internal.hyperlink.JSDTHyperlink;
import org.eclipse.wst.jsdt.web.ui.internal.hyperlink.WorkspaceFileHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSDTHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String[] PARTITION_TYPES = new String[]{"org.eclipse.wst.html.SCRIPT", "org.eclipse.wst.html.SCRIPT.EVENTHANDLER"};

    private IHyperlink createHyperlink(IJsTranslation jsTranslation, IJavaScriptElement element, IRegion region, IDocument document) {
        Object link = null;
        if (region != null) {
            if (element instanceof ISourceReference) {
                IFile file = null;
                IPath outsidePath = null;
                int jspOffset = 0;
                IStructuredModel sModel = null;
                try {
                    sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                    if (sModel != null) {
                        String uriString = sModel.getBaseLocation();
                        file = this.getFile(uriString);
                    }
                }
                finally {
                    if (sModel != null) {
                        sModel.releaseFromRead();
                    }
                }
                try {
                    ISourceRange range = null;
                    if (jsTranslation != null) {
                        IJavaScriptUnit cu;
                        if (element instanceof ILocalVariable) {
                            IClassFile cu2;
                            range = ((ILocalVariable)element).getNameRange();
                            IJavaScriptElement unit = ((ILocalVariable)element).getParent();
                            IJavaScriptUnit myUnit = jsTranslation.getCompilationUnit();
                            while (!(unit instanceof IJavaScriptUnit) && !(unit instanceof IClassFile) && unit != null) {
                                unit = ((JavaElement)unit).getParent();
                            }
                            if (unit instanceof IJavaScriptUnit) {
                                IJavaScriptUnit cu3 = (IJavaScriptUnit)unit;
                                if (cu3 != myUnit && (file = this.getFile(cu3.getPath().toString())) == null) {
                                    outsidePath = cu3.getPath();
                                }
                            } else if (unit instanceof IClassFile && (cu2 = (IClassFile)unit) != myUnit && (file = this.getFile(cu2.getPath().toString())) == null) {
                                outsidePath = cu2.getPath();
                            }
                        } else if (element.getElementType() == 8) {
                            IJavaScriptUnit cu4 = ((IField)element).getJavaScriptUnit();
                            if (cu4 != null && cu4.equals(jsTranslation.getCompilationUnit())) {
                                range = ((ISourceReference)element).getSourceRange();
                            }
                        } else if (element.getElementType() == 9 && (cu = ((IFunction)element).getJavaScriptUnit()) != null && cu.equals(jsTranslation.getCompilationUnit())) {
                            range = ((ISourceReference)element).getSourceRange();
                        }
                    }
                    if (range != null && file != null) {
                        jspOffset = range.getOffset();
                        if (jspOffset >= 0) {
                            link = new WorkspaceFileHyperlink(region, file, (IRegion)new Region(jspOffset, range.getLength()));
                        }
                    } else if (range != null && outsidePath != null && (jspOffset = range.getOffset()) >= 0) {
                        link = new ExternalFileHyperlink(region, outsidePath.toFile());
                    }
                }
                catch (JavaScriptModelException jme) {
                    Logger.log(202, jme.getMessage(), jme);
                }
            }
            if (link == null) {
                link = new JSDTHyperlink(region, element);
            }
        }
        return link;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>(0);
        if (region != null && textViewer != null) {
            IDocument document = textViewer.getDocument();
            try {
                IJsTranslation jsTranslation;
                boolean proceed = false;
                ITypedRegion[] partitions = document.computePartitioning(region.getOffset(), region.getLength());
                int i = 0;
                while (i < partitions.length) {
                    int j = 0;
                    while (j < PARTITION_TYPES.length) {
                        if (PARTITION_TYPES[j].equals(partitions[i].getType())) {
                            proceed = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (proceed && (jsTranslation = this.getJsTranslation(document)) != null) {
                    IRegion hyperlinkRegion = this.selectWord(document, region.getOffset());
                    IJavaScriptElement[] elements = jsTranslation.getElementsFromJsRange(jsTranslation.getJavaScriptOffset(region.getOffset()), jsTranslation.getJavaScriptOffset(region.getOffset() + region.getLength()));
                    if (elements != null && elements.length > 0) {
                        int i2 = 0;
                        while (i2 < elements.length) {
                            IJavaScriptElement element = elements[i2];
                            IHyperlink link = this.createHyperlink(jsTranslation, element, hyperlinkRegion, document);
                            if (link != null) {
                                hyperlinks.add(link);
                            }
                            ++i2;
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (hyperlinks.size() == 0) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[0]);
    }

    private IFile getFile(String fileString) {
        IResource resource;
        IFile file = null;
        if (fileString != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fileString)) != null && resource instanceof IFile) {
            file = (IFile)resource;
        }
        return file;
    }

    private IJsTranslation getJsTranslation(IDocument document) {
        IJsTranslation translation = null;
        IDOMModel xmlModel = null;
        try {
            IDOMDocument xmlDoc;
            JsTranslationAdapter adapter;
            xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (xmlModel != null && (adapter = (JsTranslationAdapter)(xmlDoc = xmlModel.getDocument()).getAdapterFor(IJsTranslation.class)) != null) {
                translation = adapter.getJsTranslation(true);
            }
        }
        finally {
            if (xmlModel != null) {
                xmlModel.releaseFromRead();
            }
        }
        return translation;
    }

    private IRegion selectWord(IDocument document, int anchor) {
        try {
            char c;
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                --offset;
            }
            int start = offset;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++offset;
            }
            int end = offset;
            if (start == end) {
                return new Region(start, 0);
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

