/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.List;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CreateElementAction
extends Action {
    protected String description;
    protected Element parentNode;
    protected ISelectionProvider selectionProvider;
    protected XSDSchema xsdSchema;
    protected Object sourceContext;
    boolean isGlobal = false;
    protected Node relativeNode;
    protected String elementTag;
    protected List attributes;

    public CreateElementAction() {
    }

    public CreateElementAction(String text) {
        super(text);
    }

    public CreateElementAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public void setXSDSchema(XSDSchema xsdSchema) {
        this.xsdSchema = xsdSchema;
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public void setSourceContext(Object sourceContext) {
        this.sourceContext = sourceContext;
    }

    public Element getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Element parentNode) {
        this.parentNode = parentNode;
    }

    public void setIsGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public boolean getIsGlobal() {
        return this.isGlobal;
    }

    public void setElementTag(String elementTag) {
        this.elementTag = elementTag;
    }

    public DocumentImpl getDocument() {
        return (DocumentImpl)this.getParentNode().getOwnerDocument();
    }

    public void beginRecording(String description) {
        this.getDocument().getModel().beginRecording((Object)this, description);
    }

    public void endRecording() {
        DocumentImpl doc = this.getDocument();
        doc.getModel().endRecording((Object)this);
    }

    public Element createAndAddNewChildElement() {
        Text textNode;
        String prefix = this.parentNode.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element childNode = this.getDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + this.elementTag);
        if (this.getAttributes() != null) {
            List attributes = this.getAttributes();
            int i = 0;
            while (i < attributes.size()) {
                DOMAttribute attr = (DOMAttribute)attributes.get(i);
                childNode.setAttribute(attr.getName(), attr.getValue());
                ++i;
            }
        }
        if (this.getRelativeNode() == null) {
            this.parentNode.appendChild(childNode);
        } else {
            this.parentNode.insertBefore(childNode, this.getRelativeNode());
        }
        if (this.isGlobal && this.getRelativeNode() == null) {
            textNode = this.getDocument().createTextNode("\n\n");
            this.parentNode.appendChild(textNode);
        } else if (this.isGlobal && this.getRelativeNode() != null) {
            textNode = this.getDocument().createTextNode("\n\n");
            this.parentNode.insertBefore(textNode, this.getRelativeNode());
        }
        this.formatChild(childNode);
        return childNode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void formatChild(Element child) {
        if (!(child instanceof IDOMNode)) return;
        IDOMModel model = ((IDOMNode)child).getModel();
        try {
            model.aboutToChangeModel();
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode((Node)child);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            model.changedModel();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        model.changedModel();
    }

    public void run() {
        this.beginRecording(this.getDescription());
        final Element child = this.createAndAddNewChildElement();
        this.endRecording();
        if (this.selectionProvider != null) {
            final XSDConcreteComponent comp = this.xsdSchema.getCorrespondingComponent((Node)child);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (comp instanceof XSDAttributeDeclaration) {
                        if (((XSDAttributeDeclaration)comp).getContainer() instanceof XSDAttributeUse) {
                            if (comp.getContainer().getContainer() instanceof XSDAttributeGroupDefinition) {
                                CreateElementAction.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)comp.getContainer()));
                            } else if (comp.getContainer().getContainer() instanceof XSDComplexTypeDefinition) {
                                if (XSDDOMHelper.inputEquals(child, "attribute", true)) {
                                    CreateElementAction.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)comp.getContainer()));
                                } else {
                                    CreateElementAction.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)comp));
                                }
                            } else {
                                CreateElementAction.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)comp));
                            }
                        } else {
                            CreateElementAction.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)comp));
                        }
                    } else {
                        CreateElementAction.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)comp));
                    }
                    if (comp instanceof XSDNamedComponent) {
                        boolean cfr_ignored_0 = CreateElementAction.this.sourceContext instanceof AbstractEditPartViewer;
                    }
                }
            };
            Display.getDefault().timerExec(50, runnable);
        }
    }

    public Node getRelativeNode() {
        return this.relativeNode;
    }

    public void setRelativeNode(Node relativeNode) {
        this.relativeNode = relativeNode;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.getText();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }
}

