/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.editor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.model.Parameter;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.core.model.XSLNode;
import org.eclipse.wst.xsl.ui.internal.editor.SourceFileHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String ELEM_WITH_PARAM = "with-param";
    private static final String ATTR_NAME = "name";
    private static final String ELM_CALL_TEMPLATE = "call-template";

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Object hyperlink = null;
        if (region != null && textViewer != null) {
            return this.detectHyperlinks(textViewer.getDocument(), region, canShowMultipleHyperlinks);
        }
        return new IHyperlink[]{hyperlink};
    }

    public IHyperlink[] detectHyperlinks(IDocument document, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] iHyperlinkArray;
        IHyperlink hyperlink = null;
        if (region != null && document != null) {
            Node currentNode = XSLCore.getCurrentNode((IDocument)document, (int)region.getOffset());
            Element xslEl = null;
            Attr xslAttr = null;
            if ("http://www.w3.org/1999/XSL/Transform".equals(currentNode.getNamespaceURI())) {
                if (currentNode.getNodeType() == 2) {
                    Attr att = (Attr)currentNode;
                    xslEl = att.getOwnerElement();
                    xslAttr = att;
                }
                if (currentNode.getNodeType() == 1) {
                    Element el;
                    xslEl = el = (Element)currentNode;
                    xslAttr = XSLCore.getCurrentAttrNode((Node)el, (int)region.getOffset());
                }
            }
            hyperlink = this.createHyperLink(document, hyperlink, xslEl, xslAttr);
        }
        if (hyperlink == null) {
            iHyperlinkArray = null;
        } else {
            IHyperlink[] iHyperlinkArray2 = new IHyperlink[1];
            iHyperlinkArray = iHyperlinkArray2;
            iHyperlinkArray2[0] = hyperlink;
        }
        return iHyperlinkArray;
    }

    private IHyperlink createHyperLink(IDocument document, IHyperlink hyperlink, Element xslEl, Attr xslAttr) {
        if (xslEl != null && xslAttr != null) {
            IRegion hyperlinkRegion = this.getHyperlinkRegion(xslAttr);
            IFile file = this.getFileForDocument(document);
            if (file != null) {
                if (ELM_CALL_TEMPLATE.equals(xslEl.getLocalName()) && ATTR_NAME.equals(xslAttr.getLocalName())) {
                    hyperlink = this.createCallTemplateHyperLink(file, xslAttr.getValue(), hyperlinkRegion);
                }
                if (ELEM_WITH_PARAM.equals(xslEl.getLocalName()) && ATTR_NAME.equals(xslAttr.getLocalName())) {
                    hyperlink = this.createWithParamHyperLink(file, xslEl, xslAttr, hyperlinkRegion);
                }
            }
        }
        return hyperlink;
    }

    private IHyperlink createCallTemplateHyperLink(IFile currentFile, String templateName, IRegion hyperlinkRegion) {
        List templates;
        SourceFileHyperlink hyperlink = null;
        StylesheetModel sf = XSLCore.getInstance().getStylesheet(currentFile);
        if (sf != null && (templates = sf.getTemplatesByName(templateName)) != null && templates.size() == 1) {
            Template template = (Template)templates.get(0);
            hyperlink = new SourceFileHyperlink(hyperlinkRegion, template.getStylesheet().getFile(), (XSLNode)template);
        }
        return hyperlink;
    }

    private IHyperlink createWithParamHyperLink(IFile currentFile, Element elem, Attr attr, IRegion hyperlinkRegion) {
        Node parentNode;
        Attr parentAttribute;
        String templateName;
        List templates;
        SourceFileHyperlink hyperlink = null;
        StylesheetModel sf = XSLCore.getInstance().getStylesheet(currentFile);
        if (sf != null && (templates = sf.getTemplatesByName(templateName = (parentAttribute = (Attr)(parentNode = elem.getParentNode()).getAttributes().getNamedItem(ATTR_NAME)).getValue())) != null && templates.size() == 1) {
            Template template = (Template)templates.get(0);
            List parameters = template.getParameters();
            for (Parameter param : parameters) {
                String paramName = attr.getValue();
                XSLAttribute parameterNameAttr = param.getAttribute(ATTR_NAME);
                if (parameterNameAttr == null || !parameterNameAttr.getValue().equals(paramName)) continue;
                hyperlink = new SourceFileHyperlink(hyperlinkRegion, template.getStylesheet().getFile(), (XSLNode)param);
            }
        }
        return hyperlink;
    }

    private IRegion getHyperlinkRegion(Node node) {
        Region hyperRegion = null;
        if (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 10) {
                IDOMNode docNode = (IDOMNode)node;
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
            } else if (nodeType == 2) {
                IDOMAttr att = (IDOMAttr)node;
                int regOffset = att.getValueRegionStartOffset();
                ITextRegion valueRegion = att.getValueRegion();
                if (valueRegion != null) {
                    int regLength = valueRegion.getTextLength();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    hyperRegion = new Region(regOffset, regLength);
                }
            }
        }
        return hyperRegion;
    }

    private IFile getFileForDocument(IDocument document) {
        IFile file = null;
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel != null) {
                Path path = new Path(sModel.getBaseLocation());
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return file != null && file.exists() ? file : null;
    }
}

