/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.views.stylesheet;

import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xsl.core.model.Function;
import org.eclipse.wst.xsl.core.model.Import;
import org.eclipse.wst.xsl.core.model.Include;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.Variable;
import org.eclipse.wst.xsl.core.model.XSLModelObject;
import org.eclipse.wst.xsl.ui.internal.views.stylesheet.ListWorkbenchAdapter;

class XSLWorkbenchAdapter
implements IWorkbenchAdapter {
    private final Object[] EMPTY = new Object[0];

    XSLWorkbenchAdapter() {
    }

    public Object[] getChildren(Object o) {
        if (o instanceof XSLModelObject) {
            XSLModelObject obj = (XSLModelObject)o;
            switch (obj.getModelType()) {
                case STYLESHEET: {
                    Stylesheet stylesheet = (Stylesheet)obj;
                    ArrayList<ListWorkbenchAdapter> modelItems = new ArrayList<ListWorkbenchAdapter>();
                    modelItems.add(new ListWorkbenchAdapter(stylesheet, null, stylesheet.getVersion(), "icons/full/xslt_launch.gif"));
                    modelItems.add(new ListWorkbenchAdapter(stylesheet, stylesheet.getImports(), "Imports", "icons/full/import.gif"));
                    modelItems.add(new ListWorkbenchAdapter(stylesheet, stylesheet.getIncludes(), "Includes", "icons/full/import.gif"));
                    modelItems.add(new ListWorkbenchAdapter(stylesheet, stylesheet.getGlobalVariables(), "Variables", "icons/full/field_default_obj.gif"));
                    modelItems.add(new ListWorkbenchAdapter(stylesheet, stylesheet.getTemplates(), "Templates", "icons/full/package_obj.gif"));
                    if (stylesheet.getFunctions().size() > 0) {
                        modelItems.add(new ListWorkbenchAdapter(stylesheet, stylesheet.getTemplates(), "Functions", "icons/full/function.gif"));
                    }
                    return modelItems.toArray();
                }
            }
        }
        return this.EMPTY;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        XSLModelObject obj = (XSLModelObject)object;
        String path = null;
        switch (obj.getModelType()) {
            case STYLESHEET: {
                path = "icons/full/xslt_launch.gif";
                break;
            }
            case IMPORT: 
            case INCLUDE: {
                path = "icons/full/import.gif";
                break;
            }
            case TEMPLATE: {
                Template template = (Template)obj;
                if (template.getName() != null) {
                    path = "icons/full/templatenamed_obj.gif";
                    break;
                }
                path = "icons/full/package_obj.gif";
                break;
            }
            case VARIABLE: {
                path = "icons/full/field_default_obj.gif";
                break;
            }
            case FUNCTION: {
                path = "icons/full/function.gif";
            }
        }
        return path == null ? null : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xsl.ui", (String)path);
    }

    public String getLabel(Object o) {
        String label = null;
        XSLModelObject obj = (XSLModelObject)o;
        switch (obj.getModelType()) {
            case STYLESHEET: {
                Stylesheet stylesheet = (Stylesheet)obj;
                label = stylesheet.getVersion() == null ? "?" : stylesheet.getVersion();
                break;
            }
            case IMPORT: {
                Import imp = (Import)obj;
                label = imp.getHref();
                break;
            }
            case INCLUDE: {
                Include inc = (Include)obj;
                label = inc.getHref();
                break;
            }
            case TEMPLATE: {
                Template t = (Template)obj;
                StringBuffer sb = new StringBuffer();
                if (t.getName() != null) {
                    sb.append(t.getName()).append(" ");
                }
                if (t.getMatch() != null) {
                    sb.append(t.getMatch()).append(" ");
                }
                if (t.getMode() != null) {
                    sb.append("(").append(t.getMode()).append(")");
                }
                label = sb.toString();
                break;
            }
            case VARIABLE: {
                Variable v = (Variable)obj;
                label = v.getName();
                break;
            }
            case FUNCTION: {
                Function f = (Function)obj;
                label = f.getName();
            }
        }
        return label;
    }

    public Object getParent(Object o) {
        return null;
    }
}

