/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.core.resources.IProject;

public class SCProfileInstance {
    private IProject project;
    private ScannerConfigProfile profile;
    private IScannerInfoCollector collector;
    private InfoContext context;

    public SCProfileInstance(IProject project, ScannerConfigProfile profile) {
        this(project, new InfoContext(project), profile);
    }

    public SCProfileInstance(IProject project, InfoContext context, ScannerConfigProfile profile) {
        this.project = project;
        this.profile = profile;
        this.context = context;
    }

    private void instantiateCollector() {
        this.collector = this.createScannerInfoCollector();
        if (this.collector != null) {
            Class<?> clazz = this.collector.getClass();
            try {
                Object[] args = null;
                Method setMethod = null;
                if (this.context != null) {
                    try {
                        setMethod = clazz.getMethod("setInfoContext", InfoContext.class);
                        args = new Object[]{this.context};
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (setMethod == null) {
                    try {
                        setMethod = clazz.getMethod("setProject", IProject.class);
                        args = new Object[]{this.project};
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (setMethod != null) {
                    setMethod.invoke((Object)this.collector, args);
                }
            }
            catch (SecurityException e) {
                MakeCorePlugin.log(e);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                MakeCorePlugin.log(e.getCause());
            }
        }
    }

    public ScannerConfigProfile getProfile() {
        return this.profile;
    }

    public IScannerInfoCollector getScannerInfoCollector() {
        if (this.collector == null) {
            this.instantiateCollector();
        }
        return this.collector;
    }

    public IScannerInfoCollector createScannerInfoCollector() {
        ScannerConfigProfile.ScannerInfoCollector collector = this.profile.getScannerInfoCollectorElement();
        if (collector != null) {
            return collector.createScannerInfoCollector();
        }
        return null;
    }

    public IExternalScannerInfoProvider createBuildOutputProvider() {
        ScannerConfigProfile.Action action;
        ScannerConfigProfile.BuildOutputProvider bop = this.profile.getBuildOutputProviderElement();
        if (bop != null && (action = bop.getAction()) != null) {
            return (IExternalScannerInfoProvider)action.createExternalScannerInfoProvider();
        }
        return null;
    }

    public IScannerInfoConsoleParser createBuildOutputParser() {
        ScannerConfigProfile.ScannerInfoConsoleParser parserElement;
        ScannerConfigProfile.BuildOutputProvider bop = this.profile.getBuildOutputProviderElement();
        if (bop != null && (parserElement = bop.getScannerInfoConsoleParser()) != null) {
            return (IScannerInfoConsoleParser)parserElement.createScannerInfoConsoleParser();
        }
        return null;
    }

    public IExternalScannerInfoProvider createExternalScannerInfoProvider(String providerId) {
        ScannerConfigProfile.ScannerInfoProvider provider = this.profile.getScannerInfoProviderElement(providerId);
        if (provider != null) {
            return (IExternalScannerInfoProvider)provider.getAction().createExternalScannerInfoProvider();
        }
        return null;
    }

    public IScannerInfoConsoleParser createExternalScannerInfoParser(String providerId) {
        ScannerConfigProfile.ScannerInfoProvider provider = this.profile.getScannerInfoProviderElement(providerId);
        if (provider != null) {
            return (IScannerInfoConsoleParser)provider.getScannerInfoConsoleParser().createScannerInfoConsoleParser();
        }
        return null;
    }
}

