/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.build.crossgcc;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.macros.AbstractGnuToolPrefixMacro;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.core.runtime.Status;

public class CrossBuildMacroSupplier
implements IConfigurationBuildMacroSupplier {
    public IBuildMacro getMacro(String macroName, IConfiguration configuration, IBuildMacroProvider provider) {
        if ("gnu_tool_prefix".equals(macroName)) {
            return new GnuToolPrefixMacro(configuration);
        }
        return null;
    }

    public IBuildMacro[] getMacros(IConfiguration configuration, IBuildMacroProvider provider) {
        IBuildMacro[] iBuildMacroArray;
        IBuildMacro macro = this.getMacro("gnu_tool_prefix", configuration, provider);
        if (macro == null) {
            iBuildMacroArray = new IBuildMacro[]{};
        } else {
            IBuildMacro[] iBuildMacroArray2 = new IBuildMacro[1];
            iBuildMacroArray = iBuildMacroArray2;
            iBuildMacroArray2[0] = macro;
        }
        return iBuildMacroArray;
    }

    private static class GnuToolPrefixMacro
    extends AbstractGnuToolPrefixMacro {
        private static final String GNU_TOOL_PREFIX_OPTION = "cdt.managedbuild.option.gnu.cross.prefix";
        private final IConfiguration configuration;

        public GnuToolPrefixMacro(IConfiguration configuration) {
            this.configuration = configuration;
        }

        public String getStringValue() throws BuildMacroException {
            IOption option = this.configuration.getToolChain().getOptionBySuperClassId(GNU_TOOL_PREFIX_OPTION);
            if (option == null) {
                throw new BuildMacroException(Status.error((String)"Toolchain option not found: cdt.managedbuild.option.gnu.cross.prefix"));
            }
            return this.getStringValue(option);
        }
    }
}

