/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFileMidx;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.IO;

public final class DfsPackFileMidxSingle
extends DfsPackFileMidx {
    private final SingleVOffsetCalculator offsetCalculator;
    private final DfsPackFile pack;
    private final DfsPackFileMidx base;
    private byte[] checksum;
    private final LocalPackOffset poBuffer = new LocalPackOffset();

    DfsPackFileMidxSingle(DfsBlockCache cache, DfsPackDescription midxDesc, DfsPackFile pack, @Nullable DfsPackFileMidx base) {
        super(cache, midxDesc);
        this.pack = pack;
        this.offsetCalculator = new SingleVOffsetCalculator(this.pack, base != null ? base.getOffsetCalculator() : null);
        this.length = this.offsetCalculator.getMaxOffset();
        this.base = base;
    }

    @Override
    protected DfsPackFileMidx.VOffsetCalculator getOffsetCalculator() {
        return this.offsetCalculator;
    }

    @Override
    public ObjectIdSet asObjectIdSet(DfsReader ctx) throws IOException {
        return this.pack.asObjectIdSet(ctx);
    }

    @Override
    public PackReverseIndex getReverseIdx(DfsReader ctx) throws IOException {
        return new MidxReverseIndex(this.pack.getReverseIdx(ctx), this.offsetCalculator.baseMaxOffset, this.base == null ? null : this.base.getReverseIdx(ctx), this.base == null ? 0 : this.base.getObjectCount(ctx));
    }

    @Override
    public PackBitmapIndex getBitmapIndex(DfsReader ctx) throws IOException {
        if (this.base != null) {
            return this.base.getBitmapIndex(ctx);
        }
        return this.pack.getBitmapIndex(ctx);
    }

    @Override
    List<DfsPackFile> fullyIncludedIn(DfsReader ctx, BitmapIndex.BitmapBuilder need) throws IOException {
        ArrayList<DfsPackFile> fullyIncluded = new ArrayList<DfsPackFile>();
        List<DfsPackFile> includedPacks = this.pack.fullyIncludedIn(ctx, need);
        if (!includedPacks.isEmpty()) {
            fullyIncluded.addAll(includedPacks);
        }
        if (this.base != null) {
            fullyIncluded.addAll(this.base.fullyIncludedIn(ctx, need));
        }
        return fullyIncluded;
    }

    @Override
    public CommitGraph getCommitGraph(DfsReader ctx) throws IOException {
        return this.pack.getCommitGraph(ctx);
    }

    @Override
    protected int getObjectCount(DfsReader ctx) throws IOException {
        int baseObjectCount = this.base == null ? 0 : this.base.getObjectCount(ctx);
        return (int)this.pack.getPackDescription().getObjectCount() + baseObjectCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte[] getChecksum(DfsReader ctx) throws IOException {
        if (this.checksum != null) return this.checksum;
        long checksumPos = this.desc.getFileSize(PackExt.MULTI_PACK_INDEX) - 20L;
        if (checksumPos <= 0L) {
            throw new IllegalStateException("Midx stream too short");
        }
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            ReadableChannel rc = ctx.db.openFile(this.desc, PackExt.MULTI_PACK_INDEX);
            try {
                try (InputStream in = Channels.newInputStream(rc);){
                    this.checksum = new byte[20];
                    in.skip(checksumPos);
                    IO.readFully(in, this.checksum, 0, 20);
                }
                if (rc == null) return this.checksum;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (rc == null) throw throwable;
                rc.close();
                throw throwable;
            }
            rc.close();
            return this.checksum;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public List<DfsPackFile> getCoveredPacks() {
        return List.of(this.pack);
    }

    @Override
    public DfsPackFileMidx getMultipackIndexBase() {
        return this.base;
    }

    @Override
    public int findIdxPosition(DfsReader ctx, AnyObjectId id) throws IOException {
        int p = this.pack.findIdxPosition(ctx, id);
        if (p >= 0) {
            int baseObjects = this.base == null ? 0 : this.base.getObjectCount(ctx);
            return p + baseObjects;
        }
        if (this.base == null) {
            return -1;
        }
        return this.base.findIdxPosition(ctx, id);
    }

    @Override
    ObjectId getObjectAt(DfsReader ctx, long nthPosition) throws IOException {
        int baseObjects;
        int n = baseObjects = this.base == null ? 0 : this.base.getObjectCount(ctx);
        if (nthPosition >= (long)baseObjects) {
            long localPosition = nthPosition - (long)baseObjects;
            return this.pack.getPackIndex(ctx).getObjectId(localPosition);
        }
        return this.base.getObjectAt(ctx, nthPosition);
    }

    @Override
    public boolean hasObject(DfsReader ctx, AnyObjectId id) throws IOException {
        if (this.pack.hasObject(ctx, id)) {
            return true;
        }
        if (this.base == null) {
            return false;
        }
        return this.base.hasObject(ctx, id);
    }

    @Override
    ObjectLoader get(DfsReader ctx, AnyObjectId id) throws IOException {
        ObjectLoader objectLoader = this.pack.get(ctx, id);
        if (objectLoader != null) {
            return objectLoader;
        }
        if (this.base == null) {
            return null;
        }
        return this.base.get(ctx, id);
    }

    private MultiPackIndex.PackOffset find(DfsReader ctx, AnyObjectId id) throws IOException {
        long offset = this.pack.findOffset(ctx, id);
        if (offset >= 0L) {
            this.poBuffer.setOffset(offset);
            return this.poBuffer;
        }
        return null;
    }

    @Override
    long findOffset(DfsReader ctx, AnyObjectId id) throws IOException {
        MultiPackIndex.PackOffset po = this.find(ctx, id);
        if (po != null) {
            return this.offsetCalculator.encode(po);
        }
        if (this.base == null) {
            return -1L;
        }
        return this.base.findOffset(ctx, id);
    }

    @Override
    void resolve(DfsReader ctx, Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        this.pack.resolve(ctx, matches, id, matchLimit);
        if (matches.size() < matchLimit && this.base != null) {
            this.base.resolve(ctx, matches, id, matchLimit);
        }
    }

    @Override
    void copyPackAsIs(PackOutputStream out, DfsReader ctx) throws IOException {
        this.pack.copyPackAsIs(out, ctx);
        if (this.base != null) {
            this.base.copyPackAsIs(out, ctx);
        }
    }

    @Override
    long getObjectSize(DfsReader ctx, AnyObjectId id) throws IOException {
        long objectSize = this.pack.getObjectSize(ctx, id);
        if (objectSize >= 0L) {
            return objectSize;
        }
        if (this.base == null) {
            return -1L;
        }
        return this.base.getObjectSize(ctx, id);
    }

    @Override
    boolean hasObjectSizeIndex(DfsReader ctx) {
        return false;
    }

    @Override
    int getObjectSizeIndexThreshold(DfsReader ctx) {
        return Integer.MAX_VALUE;
    }

    @Override
    long getIndexedObjectSize(DfsReader ctx, int idxPosition) {
        return -1L;
    }

    @Override
    public List<ObjectToPack> getLocalObjects(DfsReader ctx) throws IOException {
        PackIndex idx = this.getPackIndex(ctx);
        int localObjCount = (int)idx.getObjectCount();
        ArrayList<ObjectToPack> otps = new ArrayList<ObjectToPack>(localObjCount);
        int idxPosition = 0;
        while (idxPosition < localObjCount) {
            ObjectId oid = idx.getObjectId(idxPosition);
            long offset = idx.getOffset(idxPosition);
            int objectType = this.getObjectType(ctx, offset);
            ObjectToPack otp = new ObjectToPack(oid, objectType);
            otp.setOffset(offset);
            otps.add(otp);
            ++idxPosition;
        }
        return otps;
    }

    @Override
    List<DfsObjectToPack> findAllFromPack(DfsReader ctx, Iterable<ObjectToPack> objects, boolean skipFound) throws IOException {
        BlockList<DfsObjectToPack> tmp = new BlockList<DfsObjectToPack>();
        BlockList<ObjectToPack> notFoundHere = new BlockList<ObjectToPack>();
        for (ObjectToPack obj : objects) {
            DfsObjectToPack otp = (DfsObjectToPack)obj;
            if (skipFound && otp.isFound()) continue;
            long p = this.offsetCalculator.encode(this.find(ctx, otp));
            if (p < 0L) {
                notFoundHere.add(otp);
                continue;
            }
            otp.setOffset(p);
            tmp.add(otp);
        }
        if (this.base != null && !notFoundHere.isEmpty()) {
            List<DfsObjectToPack> inChain = this.base.findAllFromPack(ctx, notFoundHere, skipFound);
            tmp.addAll(inChain);
        }
        tmp.sort(OFFSET_SORT);
        return tmp;
    }

    private static class LocalPackOffset
    extends MultiPackIndex.PackOffset {
        private LocalPackOffset() {
        }

        void setOffset(long offset) {
            super.setValues(0, offset);
        }
    }

    private static class MidxReverseIndex
    implements PackReverseIndex {
        private final long baseMaxOffset;
        private final long baseObjectCount;
        private final PackReverseIndex baseRidx;
        private final PackReverseIndex ridx;

        MidxReverseIndex(PackReverseIndex ridx, long baseMaxOffset, PackReverseIndex baseRidx, long baseObjectCount) {
            this.ridx = ridx;
            this.baseMaxOffset = baseMaxOffset;
            this.baseRidx = baseRidx;
            this.baseObjectCount = baseObjectCount;
        }

        @Override
        public void verifyPackChecksum(String packFilePath) throws PackMismatchException {
        }

        @Override
        public ObjectId findObject(long offset) {
            if (offset < this.baseMaxOffset) {
                return this.baseRidx.findObject(offset);
            }
            long localOffset = offset - this.baseMaxOffset;
            return this.ridx.findObject(localOffset);
        }

        @Override
        public long findNextOffset(long offset, long maxOffset) throws CorruptObjectException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int findPosition(long offset) {
            if (offset < this.baseMaxOffset) {
                return this.baseRidx.findPosition(offset);
            }
            long localOffset = offset - this.baseMaxOffset;
            return this.ridx.findPosition(localOffset) + (int)this.baseObjectCount;
        }

        @Override
        public ObjectId findObjectByPosition(int nthPosition) {
            if ((long)nthPosition < this.baseObjectCount) {
                return this.baseRidx.findObjectByPosition(nthPosition);
            }
            long localPosition = (long)nthPosition - this.baseObjectCount;
            return this.ridx.findObjectByPosition((int)localPosition);
        }
    }

    static class SingleVOffsetCalculator
    implements DfsPackFileMidx.VOffsetCalculator {
        private final long packSize;
        private final DfsPackFileMidx.DfsPackOffset poBuffer = new DfsPackFileMidx.DfsPackOffset();
        private final DfsPackFileMidx.VOffsetCalculator baseOffsetCalculator;
        private final long baseMaxOffset;

        SingleVOffsetCalculator(DfsPackFile realPack, @Nullable DfsPackFileMidx.VOffsetCalculator base) {
            this.packSize = realPack.getPackDescription().getFileSize(PackExt.PACK);
            this.baseOffsetCalculator = base;
            this.baseMaxOffset = base != null ? base.getMaxOffset() : 0L;
            this.poBuffer.setValues(realPack, this.baseMaxOffset, 0L);
        }

        long encode(MultiPackIndex.PackOffset location) {
            if (location == null) {
                return -1L;
            }
            if (location.getOffset() > this.packSize || location.getPackId() != 0) {
                throw new IllegalArgumentException(String.format("Invalid midx location (packId: %d, offset: %d)", location.getPackId(), location.getOffset()));
            }
            return location.getOffset() + this.baseMaxOffset;
        }

        @Override
        public DfsPackFileMidx.DfsPackOffset decode(long voffset) {
            if (voffset == -1L) {
                return null;
            }
            if (voffset < this.baseMaxOffset) {
                return this.baseOffsetCalculator.decode(voffset);
            }
            long localOffset = voffset - this.baseMaxOffset;
            if (localOffset > this.packSize) {
                throw new IllegalArgumentException("Asking offset beyond limits");
            }
            return this.poBuffer.setMidxOffset(voffset);
        }

        @Override
        public long getMaxOffset() {
            return this.packSize + this.baseMaxOffset;
        }
    }
}

