/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.ui.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.ui.launching.CoverageTab;

public class CoverageTabGroup
implements ILaunchConfigurationTabGroup,
IExecutableExtension {
    private static final String DELEGATE_LAUNCHMODE = "run";
    private static final String EXPOINT_TABGROUP = "org.eclipse.debug.ui.launchConfigurationTabGroups";
    private static final String CONFIGATTR_TYPE = "type";
    private ILaunchConfigurationTabGroup tabGroupDelegate;
    private ILaunchConfigurationTab coverageTab;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.tabGroupDelegate = this.createDelegate(config.getAttribute(CONFIGATTR_TYPE));
    }

    protected ILaunchConfigurationTabGroup createDelegate(String type) throws CoreException {
        IExtensionPoint extensionpoint = Platform.getExtensionRegistry().getExtensionPoint(EXPOINT_TABGROUP);
        IConfigurationElement[] tabGroupConfigs = extensionpoint.getConfigurationElements();
        IConfigurationElement element = null;
        IConfigurationElement[] iConfigurationElementArray = tabGroupConfigs;
        int n = tabGroupConfigs.length;
        int n2 = 0;
        block0: while (n2 < n) {
            IConfigurationElement tabGroupConfig = iConfigurationElementArray[n2];
            if (type.equals(tabGroupConfig.getAttribute(CONFIGATTR_TYPE))) {
                IConfigurationElement[] modeConfigs = tabGroupConfig.getChildren("launchMode");
                if (modeConfigs.length == 0) {
                    element = tabGroupConfig;
                }
                IConfigurationElement[] iConfigurationElementArray2 = modeConfigs;
                int n3 = modeConfigs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray2[n4];
                    if (DELEGATE_LAUNCHMODE.equals(config.getAttribute("mode"))) {
                        element = tabGroupConfig;
                        break block0;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (element == null) {
            String msg = "No tab group registered to run " + type;
            throw new CoreException(EclEmmaUIPlugin.errorStatus(msg, null));
        }
        return (ILaunchConfigurationTabGroup)element.createExecutableExtension("class");
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.tabGroupDelegate.createTabs(dialog, mode);
        this.coverageTab = this.createCoverageTab(dialog, mode);
    }

    protected ILaunchConfigurationTab createCoverageTab(ILaunchConfigurationDialog dialog, String mode) {
        return new CoverageTab();
    }

    public ILaunchConfigurationTab[] getTabs() {
        return this.insertCoverageTab(this.tabGroupDelegate.getTabs(), this.coverageTab);
    }

    protected ILaunchConfigurationTab[] insertCoverageTab(ILaunchConfigurationTab[] delegateTabs, ILaunchConfigurationTab coverageTab) {
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[delegateTabs.length + 1];
        tabs[0] = delegateTabs[0];
        tabs[1] = coverageTab;
        System.arraycopy(delegateTabs, 1, tabs, 2, delegateTabs.length - 1);
        return tabs;
    }

    public void dispose() {
        this.tabGroupDelegate.dispose();
        this.coverageTab.dispose();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.tabGroupDelegate.setDefaults(configuration);
        this.coverageTab.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.tabGroupDelegate.initializeFrom(configuration);
        this.coverageTab.initializeFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.tabGroupDelegate.performApply(configuration);
        this.coverageTab.performApply(configuration);
    }

    public void launched(ILaunch launch) {
    }
}

