/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ShowBundlesDialog
extends Dialog {
    private Text fModuleArgumentsText;
    private final Map<IPluginModelBase, String> fModelsWithStartLevels;

    protected ShowBundlesDialog(Shell parentShell, Map<IPluginModelBase, String> modelsWithLevels) {
        super(parentShell);
        this.fModelsWithStartLevels = modelsWithLevels;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PDEUIMessages.ShowBundlesDialog_LaunchBundles);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, PDEUIMessages.ShowBundlesDialog_Copy, true);
        this.createButton(parent, 1, PDEUIMessages.ShowBundlesDialog_Close, false);
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        Rectangle result = super.getConstrainedShellBounds(preferredSize);
        int heightLimit = this.convertHeightInCharsToPixels(40);
        int widthLimit = this.convertWidthInCharsToPixels(150);
        if (result.height > heightLimit) {
            result.y += (result.height - heightLimit) / 2;
            result.height = heightLimit;
        }
        if (result.width > widthLimit) {
            result.x += (result.width - widthLimit) / 2;
            result.width = widthLimit;
        }
        return result;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Label explanation = new Label(comp, 0);
        explanation.setText("List of all bundles contained in this launch using the schema:\n<Symbolic Name>, <Version>, <Start level>, <File Path>");
        explanation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fModuleArgumentsText = new Text(comp, 2818);
        this.fModuleArgumentsText.setLayoutData((Object)new GridData(4, 4, true, true));
        StringJoiner lines = new StringJoiner("\n");
        this.fModelsWithStartLevels.forEach((model, value) -> {
            BundleDescription bundle = model.getBundleDescription();
            String startLevel = value.substring(0, value.indexOf(58));
            lines.add(bundle.getSymbolicName() + ", " + String.valueOf(bundle.getVersion()) + ", " + startLevel + ", " + model.getInstallLocation());
        });
        this.fModuleArgumentsText.setText(lines.toString());
        this.fModuleArgumentsText.setEditable(false);
        return comp;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Clipboard clipboard = new Clipboard(null);
            try {
                Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
                Object[] data = new Object[]{this.fModuleArgumentsText.getText()};
                clipboard.setContents(data, transfers);
            }
            finally {
                clipboard.dispose();
            }
        }
        super.buttonPressed(buttonId);
    }
}

