/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.xhtml.DynamicXHTMLProcessor;
import org.eclipse.help.webapp.IFilter;

public class DynamicXHTMLFilter
implements IFilter {
    private static final String ERROR_PAGE_PREFIX = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n</head>\n<body>";
    private static final String ERROR_PAGE_SUFFIX = "</body>\n</html>";

    @Override
    public OutputStream filter(final HttpServletRequest req, final OutputStream out) {
        final String uri = req.getRequestURI();
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm")) {
            return out;
        }
        if ("/rtopic".equals(req.getServletPath())) {
            return out;
        }
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                byte[] buf = this.toByteArray();
                ByteArrayInputStream in = new ByteArrayInputStream(buf);
                String locale = UrlUtil.getLocale(req, null);
                String contextPath = req.getContextPath();
                String servletPath = req.getServletPath();
                String href = uri;
                if (href.startsWith(contextPath)) {
                    href = href.substring(contextPath.length());
                }
                if (href.startsWith(servletPath)) {
                    href = href.substring(servletPath.length());
                }
                try {
                    boolean filter = ProductPreferences.useEnablementFilters();
                    Throwable throwable = null;
                    Object var9_13 = null;
                    try (InputStream in2 = DynamicXHTMLProcessor.process((String)href, (InputStream)in, (String)locale, (boolean)filter);){
                        DynamicXHTMLFilter.this.transferContent(in2, out);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    out.close();
                }
                catch (Throwable t) {
                    Throwable throwable = null;
                    Object var9_15 = null;
                    try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
                        writer.println(DynamicXHTMLFilter.ERROR_PAGE_PREFIX);
                        writer.println("<p>");
                        writer.println(WebappResources.getString("ProcessingError", req.getLocale()));
                        writer.println("</p>");
                        writer.println("<pre>");
                        StringWriter w1 = new StringWriter();
                        PrintWriter w2 = new PrintWriter(w1);
                        t.printStackTrace(w2);
                        writer.println(UrlUtil.htmlEncode(w1.getBuffer().toString()));
                        writer.println("</pre>");
                        writer.println(DynamicXHTMLFilter.ERROR_PAGE_SUFFIX);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
            }
        };
        return out2;
    }

    private void transferContent(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }
}

