/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

public class RedefinableElementOperations
extends NamedElementOperations {
    protected RedefinableElementOperations() {
    }

    public static boolean validateRedefinitionContextValid(RedefinableElement redefinableElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (RedefinableElement redefinedElement : redefinableElement.getRedefinedElements()) {
            if (redefinableElement.isRedefinitionContextValid(redefinedElement)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 79, UMLPlugin.INSTANCE.getString("_UI_RedefinableElement_RedefinitionContextValid_diagnostic", RedefinableElementOperations.getMessageSubstitutions(context, (Object)redefinableElement, (Object)redefinedElement)), new Object[]{redefinableElement, redefinedElement}));
        }
        return result;
    }

    public static boolean validateRedefinitionConsistent(RedefinableElement redefinableElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        for (RedefinableElement redefinedElement : redefinableElement.getRedefinedElements()) {
            if (redefinedElement.isConsistentWith(redefinableElement)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 77, UMLPlugin.INSTANCE.getString("_UI_RedefinableElement_RedefinitionConsistent_diagnostic", RedefinableElementOperations.getMessageSubstitutions(context, (Object)redefinableElement, (Object)redefinedElement)), new Object[]{redefinableElement, redefinedElement}));
        }
        return result;
    }

    public static boolean validateNonLeafRedefinition(RedefinableElement redefinableElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean isRedefinitionContextValid(RedefinableElement redefinableElement, RedefinableElement redefinedElement) {
        EList<Classifier> redefinedRedefinitionContexts = redefinedElement.getRedefinitionContexts();
        for (Classifier redefinitionContext : redefinableElement.getRedefinitionContexts()) {
            if (!redefinitionContext.allParents().containsAll(redefinedRedefinitionContexts)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConsistentWith(RedefinableElement redefinableElement, RedefinableElement redefiningElement) {
        return false;
    }

    protected static EList<RedefinableElement> getAllRedefinedElements(RedefinableElement redefinableElement, EList<RedefinableElement> allRedefinedElements) {
        for (RedefinableElement redefinedElement : redefinableElement.getRedefinedElements()) {
            if (!allRedefinedElements.add((Object)redefinedElement)) continue;
            RedefinableElementOperations.getAllRedefinedElements(redefinedElement, allRedefinedElements);
        }
        return allRedefinedElements;
    }

    protected static EList<RedefinableElement> getAllRedefinedElements(RedefinableElement redefinableElement) {
        return RedefinableElementOperations.getAllRedefinedElements(redefinableElement, (EList<RedefinableElement>)new UniqueEList.FastCompare());
    }

    protected static <E extends Element> EList<E> excludeRedefinedElements(EList<E> redefineableElements) {
        UniqueEList.FastCompare allRedefinedElements = new UniqueEList.FastCompare();
        for (Element redefinableElement : redefineableElements) {
            if (!(redefinableElement instanceof RedefinableElement)) continue;
            RedefinableElementOperations.getAllRedefinedElements((RedefinableElement)redefinableElement, (EList<RedefinableElement>)allRedefinedElements);
        }
        Iterator re = redefineableElements.iterator();
        while (re.hasNext()) {
            if (!allRedefinedElements.contains(re.next())) continue;
            re.remove();
        }
        return redefineableElements;
    }
}

