/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeApplicationStorageSelectionDialog
extends ListDialog {
    private final StorageInfo initialInfo;

    public StereotypeApplicationStorageSelectionDialog(Shell shell, String title, String message, List<StorageInfo> infos, StorageInfo initialInfo) {
        super(shell);
        this.initialInfo = initialInfo;
        this.setTitle(title);
        this.setMessage(message);
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setLabelProvider((ILabelProvider)new LabelProvider());
        this.setInput(infos);
        this.setInitialSelections(new Object[]{initialInfo});
        this.setAddCancelButton(true);
        this.setHelpAvailable(false);
    }

    public StereotypeApplicationStorageSelectionDialog(Shell shell, List<StorageInfo> infos, StorageInfo initialInfo) {
        this(shell, UMLEditorPlugin.INSTANCE.getString("_UI_ChangeStereotypeApplicationStorageAction_dialogTitle"), UMLEditorPlugin.INSTANCE.getString("_UI_ChangeStereotypeApplicationStorageAction_dialogMessage"), infos, initialInfo);
    }

    public StorageInfo getInitialInfo() {
        return this.initialInfo;
    }

    public StorageInfo getResultInfo() {
        Object[] result = this.getResult();
        if (result != null && result.length == 1) {
            return (StorageInfo)result[0];
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getOkButton().setEnabled(false);
        TableViewer tableViewer = this.getTableViewer();
        Composite area = tableViewer.getTable().getParent();
        GridData gd = new GridData(784);
        gd.heightHint = this.convertHeightInCharsToPixels(2);
        final Label descriptionLabel = new Label(area, 64);
        descriptionLabel.setLayoutData((Object)gd);
        descriptionLabel.setFont(area.getFont());
        if (this.initialInfo != null) {
            descriptionLabel.setText(this.initialInfo.getDescription());
        }
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StorageInfo info = (StorageInfo)event.getStructuredSelection().getFirstElement();
                StereotypeApplicationStorageSelectionDialog.this.getOkButton().setEnabled(info != StereotypeApplicationStorageSelectionDialog.this.initialInfo);
                descriptionLabel.setText(info.getDescription());
            }
        });
        return contents;
    }

    protected void okPressed() {
        if (this.getOkButton().isEnabled()) {
            super.okPressed();
        }
    }

    public static final class StorageInfo
    implements Comparable<StorageInfo> {
        public static final StorageInfo DEFAULT = new StorageInfo(UMLEditorPlugin.INSTANCE.getString("_UI_ChangeStereotypeApplicationStorageAction_defaultStorage_name"), UMLEditorPlugin.INSTANCE.getString("_UI_ChangeStereotypeApplicationStorageAction_defaultStorage_description"));
        private final String id;
        private final String name;
        private final String description;

        private StorageInfo(String name, String description) {
            this.id = null;
            this.name = name;
            this.description = description;
        }

        public StorageInfo(String id, String name, String description) {
            if (id == null) {
                throw new IllegalArgumentException("id");
            }
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name == null ? this.id : this.name;
        }

        public String getDescription() {
            return this.description == null ? "" : this.description;
        }

        public UMLUtil.StereotypeApplicationStorage getStorage() {
            if (this.id == null) {
                return null;
            }
            return UMLUtil.StereotypeApplicationStorage.Registry.INSTANCE.getStereotypeApplicationStorage(this.id);
        }

        public int hashCode() {
            return 31 + (this.id == null ? 0 : this.id.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StorageInfo other = (StorageInfo)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        @Override
        public int compareTo(StorageInfo o) {
            return this.getName().compareTo(o.getName());
        }

        public String toString() {
            return this.getName();
        }

        public static StorageInfo collectFromRegistry(Element element, List<StorageInfo> result) {
            UMLUtil.StereotypeApplicationStorage oldStorage = UMLUtil.getStereotypeApplicationStorage((Element)element);
            StorageInfo oldInfo = DEFAULT;
            for (Object value : UMLUtil.StereotypeApplicationStorage.Registry.INSTANCE.values()) {
                StorageInfo info = null;
                if (value instanceof UMLUtil.StereotypeApplicationStorage) {
                    UMLUtil.StereotypeApplicationStorage storage = (UMLUtil.StereotypeApplicationStorage)value;
                    info = new StorageInfo(storage.getID(), storage.getName(), storage.getDescription());
                    if (storage == oldStorage) {
                        oldInfo = info;
                    }
                } else if (value instanceof UMLUtil.StereotypeApplicationStorage.Descriptor) {
                    UMLUtil.StereotypeApplicationStorage.Descriptor descriptor = (UMLUtil.StereotypeApplicationStorage.Descriptor)value;
                    info = new StorageInfo(descriptor.getID(), descriptor.getName(), descriptor.getDescription());
                }
                if (info == null) continue;
                result.add(info);
            }
            Collections.sort(result);
            result.add(0, DEFAULT);
            return oldInfo;
        }
    }
}

