/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.etypes.provider.ModelElementItemProvider;
import org.eclipse.emf.cdo.lm.reviews.ReviewsFactory;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.TopicContainer;
import org.eclipse.emf.cdo.lm.reviews.impl.TopicContainerImpl;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewsEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class TopicContainerItemProvider
extends ModelElementItemProvider {
    public TopicContainerItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addReviewPropertyDescriptor(object);
            this.addTopicCountPropertyDescriptor(object);
            this.addUnresolvedCountPropertyDescriptor(object);
            this.addResolvedCountPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTopicCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TopicContainer_topicCount_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TopicContainer_topicCount_feature", "_UI_TopicContainer_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC_CONTAINER__TOPIC_COUNT, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addUnresolvedCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TopicContainer_unresolvedCount_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TopicContainer_unresolvedCount_feature", "_UI_TopicContainer_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC_CONTAINER__UNRESOLVED_COUNT, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addResolvedCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TopicContainer_resolvedCount_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TopicContainer_resolvedCount_feature", "_UI_TopicContainer_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC_CONTAINER__RESOLVED_COUNT, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addReviewPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TopicContainer_review_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TopicContainer_review_feature", "_UI_TopicContainer_type"), (EStructuralFeature)ReviewsPackage.Literals.TOPIC_CONTAINER__REVIEW, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ReviewsPackage.Literals.TOPIC_CONTAINER__TOPICS);
            this.childrenFeatures.add(ReviewsPackage.Literals.TOPIC_CONTAINER__COMMENTS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        return ((StyledString)this.getStyledText(object)).getString();
    }

    public Object getStyledText(Object object) {
        TopicContainer topicContainer = (TopicContainer)object;
        return new StyledString(this.getString("_UI_TopicContainer_type"), StyledString.Style.QUALIFIER_STYLER).append(" ").append(Integer.toString(topicContainer.getTopicCount()));
    }

    @Deprecated
    public void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TopicContainer.class)) {
            case 4: 
            case 5: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TopicContainer.class)) {
            case 4: 
            case 5: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                TopicContainerItemProvider.propagateNotification((ItemProviderAdapter)this, notification, notification.getNotifier());
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ReviewsPackage.Literals.TOPIC_CONTAINER__TOPICS, ReviewsFactory.eINSTANCE.createTopic()));
        newChildDescriptors.add(this.createChildParameter(ReviewsPackage.Literals.TOPIC_CONTAINER__COMMENTS, ReviewsFactory.eINSTANCE.createComment()));
    }

    static Object overlayTopicContainerImage(TopicContainer container, Object image) {
        TopicContainerImpl.TopicStatistics statistics = TopicContainerImpl.getTopicStatistics((TopicContainer)container);
        String overlayKey = null;
        if (statistics.getUnresolvedCount() != 0) {
            overlayKey = "Unresolved";
        } else if (statistics.getResolvedCount() != 0) {
            overlayKey = "Resolved";
        }
        if (overlayKey != null) {
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(ReviewsEditPlugin.INSTANCE.getImage("full/ovr16/" + overlayKey + ".gif"));
            image = new ComposedImage(images);
        }
        return image;
    }

    static void propagateNotification(ItemProviderAdapter itemProvider, Notification notification, Object notifier) {
        if (notifier instanceof EObject) {
            EObject eContainer = ((EObject)notifier).eContainer();
            while (eContainer instanceof TopicContainer) {
                itemProvider.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)eContainer, false, true));
                eContainer = eContainer.eContainer();
            }
        }
    }
}

