/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session.danalysis;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelectorProvider;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.api.session.danalysis.DefaultAnalysisSelectorProvider;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public final class DAnalysisSelectorService {
    public static final String ID = "org.eclipse.sirius.analysisSelectorProvider";
    public static final String CLASS_ATTRIBUTE = "providerClass";
    private static final String DEFAULT_PROVIDER_ID = "org.eclipse.sirius.analysisSelectorProvider.default";
    private static DAnalysisSelectorProvider defaultSiriusProvider;
    private static List<DAnalysisSelectorProvider> customerProviders;

    private DAnalysisSelectorService() {
    }

    public static DAnalysisSelector getSelector(DAnalysisSession session) {
        List customProviders = DAnalysisSelectorService.getCustomerProviders().stream().sorted(Comparator.comparingInt(DAnalysisSelectorProvider::getPriority).reversed()).collect(Collectors.toList());
        for (DAnalysisSelectorProvider provider : customProviders) {
            if (!provider.provides(session)) continue;
            return provider.getSelector(session);
        }
        return DAnalysisSelectorService.getDefaultProvider().getSelector(session);
    }

    private static DAnalysisSelectorProvider getDefaultProvider() {
        if (defaultSiriusProvider == null) {
            DAnalysisSelectorService.initializeProviders();
        }
        return defaultSiriusProvider;
    }

    private static List<DAnalysisSelectorProvider> getCustomerProviders() {
        if (customerProviders == null) {
            DAnalysisSelectorService.initializeProviders();
        }
        return customerProviders;
    }

    private static void initializeProviders() {
        Map providers = EclipseUtil.getExtensionPluginsByKey(DAnalysisSelectorProvider.class, (String)ID, (String)CLASS_ATTRIBUTE, (String)"id");
        Collection defaults = (Collection)providers.get(DEFAULT_PROVIDER_ID);
        if (defaults == null || defaults.isEmpty()) {
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DAnalysisSelectorService_noDefaultWarningMsg, ID), null);
            defaultSiriusProvider = new DefaultAnalysisSelectorProvider();
        } else if (defaultSiriusProvider == null) {
            defaultSiriusProvider = (DAnalysisSelectorProvider)defaults.iterator().next();
        }
        if (defaults != null && defaults.size() > 1) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.DAnalysisSelectorService_multipleDefaultErrorMsg, ID), null);
        }
        customerProviders = new ArrayList<DAnalysisSelectorProvider>();
        for (Map.Entry entry : providers.entrySet()) {
            if (DEFAULT_PROVIDER_ID.equals(entry.getKey())) continue;
            customerProviders.addAll((Collection)entry.getValue());
        }
    }
}

