/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Project;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntModelProject;
import org.eclipse.ant.internal.ui.model.AntPropertyNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;

public class AntProjectNode
extends AntElementNode {
    protected AntModelProject fProject;
    protected IAntModel fModel;
    protected String fLabel;

    public AntProjectNode(AntModelProject project, IAntModel antModel) {
        super("project");
        this.fProject = project;
        this.fModel = antModel;
    }

    @Override
    public String getLabel() {
        if (this.fLabel == null) {
            this.fLabel = this.fProject != null ? this.fProject.getName() : AntModelMessages.AntProjectNode_0;
            if (this.fLabel == null || this.fLabel.length() == 0) {
                this.fLabel = "project";
            }
        }
        return this.fLabel;
    }

    @Override
    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antProject");
    }

    public Project getProject() {
        return this.fProject;
    }

    @Override
    protected IAntModel getAntModel() {
        return this.fModel;
    }

    @Override
    public void reset() {
        super.reset();
        this.fProject.reset();
        this.setProblemSeverity(-1);
        this.setProblemMessage(null);
        this.fOffset = -1;
        this.fLength = -1;
    }

    public String getDescription() {
        if (this.fProject == null) {
            return AntModelMessages.AntProjectNode_0;
        }
        return this.fProject.getDescription();
    }

    public String getBuildFileName() {
        IFile file;
        LocationProvider locationProvider = this.getAntModel().getLocationProvider();
        if (locationProvider != null && (file = locationProvider.getFile()) != null) {
            return file.getFullPath().toOSString();
        }
        return null;
    }

    public String getDefaultTargetName() {
        return this.fProject.getDefaultTarget();
    }

    public void setCurrentConfiguringProperty(AntPropertyNode node) {
        AntModelProject project = (AntModelProject)this.getProject();
        project.setCurrentConfiguringProperty(node);
    }

    @Override
    public AntProjectNode getProjectNode() {
        return this;
    }

    @Override
    public boolean containsOccurrence(String identifier) {
        return identifier.equals(this.getDefaultTargetName());
    }

    @Override
    public List<Integer> computeIdentifierOffsets(String identifier) {
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null || textToSearch.length() == 0 || identifier.length() == 0) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>(1);
        String newidentifier = new StringBuffer("\"").append(identifier).append('\"').toString();
        int defaultTargetNameOffset = textToSearch.indexOf("default");
        defaultTargetNameOffset = textToSearch.indexOf(newidentifier, defaultTargetNameOffset);
        results.add(this.getOffset() + defaultTargetNameOffset + 1);
        return results;
    }

    @Override
    public boolean isRegionPotentialReference(IRegion region) {
        if (!super.isRegionPotentialReference(region)) {
            return false;
        }
        String textToSearch = this.getAntModel().getText(this.getOffset(), this.getLength());
        if (textToSearch == null) {
            return false;
        }
        return this.checkReferenceRegion(region, textToSearch, "default");
    }
}

