/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManagerForSemanticElementsFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.AbstractCopyPasteFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.SelectPasteModeDialog;
import org.eclipse.sirius.diagram.ui.tools.internal.format.data.extension.FormatDataManagerRegistry;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class PasteLayoutAction
extends AbstractCopyPasteFormatAction {
    public PasteLayoutAction(IWorkbenchPage workbenchPage, IWorkbenchPart actionWorkbenchPart) {
        super(workbenchPage, actionWorkbenchPart);
        this.setText(Messages.PasteLayoutAction_text);
        this.setId("pasteLayoutAction");
        this.setToolTipText(Messages.PasteLayoutAction_toolTipText_diagram);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteLayout.gif"));
        this.setDisabledImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteLayoutDisabled.gif"));
        this.setHoverImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteLayout.gif"));
    }

    public PasteLayoutAction(IWorkbenchPage workbenchPage) {
        this(workbenchPage, null);
    }

    protected String getCommandLabel() {
        return Messages.PasteLayoutAction_commandLabel;
    }

    protected Command getCommand() {
        UnexecutableCommand pasteLayoutCommand = UnexecutableCommand.INSTANCE;
        if (SiriusFormatDataManagerForSemanticElementsFactory.getInstance().getSiriusFormatDataManager().containsData()) {
            Map<IGraphicalEditPart, List<IGraphicalEditPart>> selectionSortedByCommonParent;
            Option<DDiagram> diagram;
            CompoundCommand doPasteLayoutsCmd = new CompoundCommand(Messages.PasteLayoutAction_restoreLayoutCommandLabel);
            DiagramEditPart diagramEditPart = this.getDiagramEditPart();
            if (diagramEditPart instanceof IDDiagramEditPart && (diagram = ((IDDiagramEditPart)diagramEditPart).resolveDDiagram()).some() && PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)diagram.get()).canEditInstance((EObject)diagram.get()) && !(selectionSortedByCommonParent = this.sortSelection(this.getSelectedObjects())).isEmpty()) {
                Iterator<Map.Entry<IGraphicalEditPart, List<IGraphicalEditPart>>> iter = selectionSortedByCommonParent.entrySet().iterator();
                while (iter.hasNext()) {
                    doPasteLayoutsCmd.add(this.getCommand((DDiagram)diagram.get(), iter.next()));
                }
                doPasteLayoutsCmd.add(new Command(Messages.SelectPasteModeDialog_tearDownCommandName){

                    public void execute() {
                        SelectPasteModeDialog.tearDownPromptResult();
                    }
                });
            }
            pasteLayoutCommand = doPasteLayoutsCmd.unwrap();
        }
        return pasteLayoutCommand;
    }

    @Override
    protected String getToolTipForDiagramSelection() {
        return Messages.PasteLayoutAction_toolTipText_diagram;
    }

    @Override
    protected String getToolTipForDiagramElementsSelection() {
        return Messages.PasteLayoutAction_toolTipText_diagramElements;
    }

    private Command getCommand(DDiagram dDiagram, Map.Entry<IGraphicalEditPart, List<IGraphicalEditPart>> entry) {
        if (entry.getValue().size() == 1) {
            return new ICommandProxy((ICommand)new PasteLayoutDataCommand(entry.getValue().get(0).getEditingDomain(), dDiagram, entry.getValue().get(0), this.getWorkbenchPage().getActivePart().getSite().getShell()));
        }
        return new ICommandProxy((ICommand)new PasteLayoutDataCommand(entry.getValue().get(0).getEditingDomain(), dDiagram, entry.getKey(), entry.getValue(), this.getWorkbenchPage().getActivePart().getSite().getShell()));
    }

    private static final class PasteLayoutDataCommand
    extends AbstractTransactionalCommand {
        private IGraphicalEditPart containerOrMainEditPartToRestore;
        private List<IGraphicalEditPart> editPartsToRestore;
        private DDiagram dDiagram;
        private Shell shell;

        PasteLayoutDataCommand(TransactionalEditingDomain domain, DDiagram dDiagram, IGraphicalEditPart editPartToRestore, Shell shell) {
            super(domain, Messages.PasteLayoutDataCommand_label, null);
            this.dDiagram = dDiagram;
            this.containerOrMainEditPartToRestore = editPartToRestore;
            this.shell = shell;
        }

        PasteLayoutDataCommand(TransactionalEditingDomain domain, DDiagram dDiagram, IGraphicalEditPart editPartContainer, List<IGraphicalEditPart> editPartsToRestore, Shell shell) {
            super(domain, Messages.PasteLayoutDataCommand_label, null);
            this.dDiagram = dDiagram;
            this.containerOrMainEditPartToRestore = editPartContainer;
            this.editPartsToRestore = editPartsToRestore;
            this.shell = shell;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            List<SiriusFormatDataManager> formatDataManagers = FormatDataManagerRegistry.getSiriusFormatDataManagers(this.dDiagram);
            if (!formatDataManagers.isEmpty()) {
                try {
                    if (this.editPartsToRestore == null) {
                        formatDataManagers.get(0).applyLayout(this.containerOrMainEditPartToRestore, SelectPasteModeDialog.promptIsAbsolutePasteMode(this.shell));
                    } else {
                        formatDataManagers.get(0).applyLayout(this.containerOrMainEditPartToRestore, this.editPartsToRestore, SelectPasteModeDialog.promptIsAbsolutePasteMode(this.shell));
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    return CommandResult.newCancelledCommandResult();
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

