/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.zest.layouts.Filter;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutItem;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.Stoppable;
import org.eclipse.zest.layouts.constraints.BasicEntityConstraint;
import org.eclipse.zest.layouts.dataStructures.BendPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.progress.ProgressEvent;
import org.eclipse.zest.layouts.progress.ProgressListener;

public abstract class AbstractLayoutAlgorithm
implements LayoutAlgorithm {
    protected LayoutContext context;

    @Override
    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public static abstract class Zest1
    implements LayoutAlgorithm.Zest1,
    Stoppable {
        @Deprecated
        public static final int MIN_ENTITY_SIZE = 5;
        private static final int MIN_TIME_DELAY_BETWEEN_PROGRESS_EVENTS = 1;
        private Thread creationThread = null;
        @Deprecated
        protected Comparator comparator;
        @Deprecated
        protected Filter filter;
        private final List<ProgressListener> progressListeners = new CopyOnWriteArrayList<ProgressListener>();
        private Calendar lastProgressEventFired;
        private double widthToHeightRatio = 1.0;
        private InternalNode[] internalNodes;
        private InternalRelationship[] internalRelationships;
        private double internalX;
        private double internalY;
        private double internalWidth;
        private double internalHeight;
        @Deprecated
        protected boolean internalContinuous;
        @Deprecated
        protected boolean internalAsynchronous;
        private final List<LayoutEntity> entitiesToRemove = new ArrayList<LayoutEntity>();
        private final List<LayoutRelationship> relationshipsToRemove = new ArrayList<LayoutRelationship>();
        private final List<LayoutEntity> entitiesToAdd = new ArrayList<LayoutEntity>();
        private final List<LayoutRelationship> relationshipsToAdd = new ArrayList<LayoutRelationship>();
        @Deprecated
        protected boolean layoutStopped = true;
        @Deprecated
        protected int layout_styles = 0;
        @Deprecated
        protected boolean resizeEntitiesAfterLayout = true;

        @Deprecated
        public void removeRelationships(Collection<? extends LayoutRelationship> collection) {
        }

        @Deprecated
        public Zest1(int styles) {
            this.creationThread = Thread.currentThread();
            this.lastProgressEventFired = Calendar.getInstance();
            this.layout_styles = styles;
        }

        @Override
        @Deprecated
        public void addEntity(LayoutEntity entity) {
            if (entity != null && !this.entitiesToAdd.contains(entity)) {
                this.entitiesToAdd.add(entity);
            }
        }

        @Override
        @Deprecated
        public void addRelationship(LayoutRelationship relationship) {
            if (relationship != null && !this.relationshipsToAdd.contains(relationship)) {
                this.relationshipsToAdd.add(relationship);
            }
        }

        @Override
        @Deprecated
        public void removeEntity(LayoutEntity entity) {
            if (entity != null && !this.entitiesToRemove.contains(entity)) {
                this.entitiesToRemove.add(entity);
            }
        }

        @Override
        @Deprecated
        public void removeRelationship(LayoutRelationship relationship) {
            if (relationship != null && !this.relationshipsToRemove.contains(relationship)) {
                this.relationshipsToRemove.add(relationship);
            }
        }

        @Override
        @Deprecated
        public void removeRelationships(List<? extends LayoutRelationship> relationships) {
            this.relationshipsToRemove.addAll(relationships);
        }

        @Override
        @Deprecated
        public void setStyle(int style) {
            this.layout_styles = style;
        }

        @Override
        @Deprecated
        public int getStyle() {
            return this.layout_styles;
        }

        @Deprecated
        public abstract void setLayoutArea(double var1, double var3, double var5, double var7);

        @Deprecated
        protected abstract boolean isValidConfiguration(boolean var1, boolean var2);

        @Deprecated
        protected abstract void applyLayoutInternal(InternalNode[] var1, InternalRelationship[] var2, double var3, double var5, double var7, double var9);

        @Deprecated
        protected InternalNode[] updateEntities(InternalNode[] entities) {
            if (!this.entitiesToRemove.isEmpty() || !this.entitiesToAdd.isEmpty()) {
                InternalNode[] newNodes;
                ArrayList<InternalNode> internalNodesList = new ArrayList<InternalNode>(Arrays.asList(entities));
                this.entitiesToRemove.stream().filter(e -> e.getLayoutInformation() != null).forEach(e -> {
                    boolean bl = internalNodesList.remove(e.getLayoutInformation());
                });
                ArrayList<InternalNode> updatedEntities = new ArrayList<InternalNode>(this.internalNodes.length - this.entitiesToRemove.size() + this.entitiesToAdd.size());
                InternalNode[] internalNodeArray = this.internalNodes;
                int n = this.internalNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalNode node = internalNodeArray[n2];
                    if (this.entitiesToRemove.contains(node.getLayoutEntity())) {
                        this.entitiesToRemove.remove(node.getLayoutEntity());
                    } else {
                        updatedEntities.add(node);
                    }
                    ++n2;
                }
                this.entitiesToRemove.clear();
                LayoutEntity[] entitiesArray = new LayoutEntity[this.entitiesToAdd.size()];
                entitiesArray = this.entitiesToAdd.toArray(entitiesArray);
                InternalNode[] internalNodeArray2 = newNodes = Zest1.createInternalNodes(entitiesArray);
                int n3 = newNodes.length;
                int n4 = 0;
                while (n4 < n3) {
                    InternalNode newNode = internalNodeArray2[n4];
                    internalNodesList.add(newNode);
                    updatedEntities.add(newNode);
                    ++n4;
                }
                this.entitiesToAdd.clear();
                entities = new InternalNode[internalNodesList.size()];
                entities = internalNodesList.toArray(entities);
                this.internalNodes = new InternalNode[updatedEntities.size()];
                this.internalNodes = updatedEntities.toArray(this.internalNodes);
            }
            return entities;
        }

        @Deprecated
        protected InternalRelationship[] updateRelationships(InternalRelationship[] relationships) {
            if (!this.relationshipsToRemove.isEmpty() || !this.relationshipsToAdd.isEmpty()) {
                ArrayList<InternalRelationship> internalRelsList = new ArrayList<InternalRelationship>(Arrays.asList(relationships));
                this.relationshipsToRemove.stream().filter(r -> r.getLayoutInformation() != null).forEach(r -> {
                    boolean bl = internalRelsList.remove(r.getLayoutInformation());
                });
                ArrayList<InternalRelationship> updatedRelationships = new ArrayList<InternalRelationship>(this.internalRelationships.length - this.relationshipsToRemove.size() + this.relationshipsToAdd.size());
                InternalRelationship[] internalRelationshipArray = this.internalRelationships;
                int n = this.internalRelationships.length;
                int n2 = 0;
                while (n2 < n) {
                    InternalRelationship relation = internalRelationshipArray[n2];
                    if (this.relationshipsToRemove.contains(relation.getLayoutRelationship())) {
                        this.relationshipsToRemove.remove(relation.getLayoutRelationship());
                    } else {
                        updatedRelationships.add(relation);
                    }
                    ++n2;
                }
                this.relationshipsToRemove.clear();
                if (!this.relationshipsToAdd.isEmpty()) {
                    InternalRelationship[] newRelationships;
                    LayoutRelationship[] relsArray = new LayoutRelationship[this.relationshipsToAdd.size()];
                    relsArray = this.relationshipsToAdd.toArray(relsArray);
                    InternalRelationship[] internalRelationshipArray2 = newRelationships = Zest1.createInternalRelationships(relsArray);
                    int n3 = newRelationships.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InternalRelationship newRelationship = internalRelationshipArray2[n4];
                        internalRelsList.add(newRelationship);
                        updatedRelationships.add(newRelationship);
                        ++n4;
                    }
                }
                this.relationshipsToAdd.clear();
                relationships = new InternalRelationship[internalRelsList.size()];
                relationships = internalRelsList.toArray(relationships);
                this.internalRelationships = new InternalRelationship[updatedRelationships.size()];
                this.internalRelationships = updatedRelationships.toArray(this.internalRelationships);
            }
            return relationships;
        }

        @Override
        @Deprecated
        public synchronized boolean isRunning() {
            return !this.layoutStopped;
        }

        @Override
        @Deprecated
        public synchronized void stop() {
            this.layoutStopped = true;
            this.postLayoutAlgorithm(this.internalNodes, this.internalRelationships);
            this.fireProgressEnded(this.getTotalNumberOfLayoutSteps());
        }

        private void setupLayout(LayoutEntity[] entitiesToLayout, LayoutRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
            this.internalX = x;
            this.internalY = y;
            this.internalHeight = height;
            this.internalWidth = width;
            if (!Zest1.verifyInput(entitiesToLayout = (LayoutEntity[])this.filterUnwantedObjects(entitiesToLayout), relationshipsToConsider = (LayoutRelationship[])this.filterUnwantedObjects(relationshipsToConsider))) {
                this.layoutStopped = true;
                throw new RuntimeException("The relationships in relationshipsToConsider don't contain the entities in entitiesToLayout");
            }
            this.internalNodes = Zest1.createInternalNodes(entitiesToLayout);
            this.internalRelationships = Zest1.createInternalRelationships(relationshipsToConsider);
        }

        @Deprecated
        protected abstract void preLayoutAlgorithm(InternalNode[] var1, InternalRelationship[] var2, double var3, double var5, double var7, double var9);

        @Deprecated
        protected abstract void postLayoutAlgorithm(InternalNode[] var1, InternalRelationship[] var2);

        @Deprecated
        protected abstract int getTotalNumberOfLayoutSteps();

        @Deprecated
        protected abstract int getCurrentLayoutStep();

        @Override
        @Deprecated
        public synchronized void applyLayout(LayoutEntity[] entitiesToLayout, LayoutRelationship[] relationshipsToConsider, double x, double y, double width, double height, boolean asynchronous, boolean continuous) throws InvalidLayoutConfiguration {
            this.checkThread();
            this.internalAsynchronous = asynchronous;
            this.internalContinuous = continuous;
            if (!this.isValidConfiguration(asynchronous, continuous)) {
                throw new InvalidLayoutConfiguration();
            }
            Zest1.clearBendPoints(relationshipsToConsider);
            this.layoutStopped = false;
            this.lastProgressEventFired = Calendar.getInstance();
            if (asynchronous) {
                Thread thread = new Thread(() -> {
                    this.setupLayout(entitiesToLayout, relationshipsToConsider, x, y, width, height);
                    this.preLayoutAlgorithm(this.internalNodes, this.internalRelationships, this.internalX, this.internalY, this.internalWidth, this.internalHeight);
                    this.fireProgressStarted(this.getTotalNumberOfLayoutSteps());
                    this.applyLayoutInternal(this.internalNodes, this.internalRelationships, this.internalX, this.internalY, this.internalWidth, this.internalHeight);
                    this.stop();
                });
                thread.setPriority(1);
                thread.start();
            } else {
                this.setupLayout(entitiesToLayout, relationshipsToConsider, x, y, width, height);
                this.preLayoutAlgorithm(this.internalNodes, this.internalRelationships, this.internalX, this.internalY, this.internalWidth, this.internalHeight);
                this.fireProgressStarted(this.getTotalNumberOfLayoutSteps());
                this.applyLayoutInternal(this.internalNodes, this.internalRelationships, this.internalX, this.internalY, this.internalWidth, this.internalHeight);
                this.stop();
            }
        }

        private static void clearBendPoints(LayoutRelationship[] relationships) {
            LayoutRelationship[] layoutRelationshipArray = relationships;
            int n = relationships.length;
            int n2 = 0;
            while (n2 < n) {
                LayoutRelationship rel = layoutRelationshipArray[n2];
                rel.clearBendPoints();
                ++n2;
            }
        }

        @Deprecated
        protected void updateBendPoints(InternalRelationship[] relationshipsToConsider) {
            InternalRelationship[] internalRelationshipArray = relationshipsToConsider;
            int n = relationshipsToConsider.length;
            int n2 = 0;
            while (n2 < n) {
                InternalRelationship relationship = internalRelationshipArray[n2];
                List bendPoints = relationship.getBendPoints();
                if (!bendPoints.isEmpty()) {
                    LayoutBendPoint[] externalBendPoints = new BendPoint[bendPoints.size() + 2];
                    InternalNode sourceNode = relationship.getSource();
                    externalBendPoints[0] = new BendPoint(sourceNode.getInternalX(), sourceNode.getInternalY());
                    InternalNode destNode = relationship.getDestination();
                    externalBendPoints[externalBendPoints.length - 1] = new BendPoint(destNode.getInternalX(), destNode.getInternalY());
                    int j = 0;
                    while (j < bendPoints.size()) {
                        BendPoint bp = (BendPoint)bendPoints.get(j);
                        externalBendPoints[j + 1] = new BendPoint(bp.x, bp.y, bp.getIsControlPoint());
                        ++j;
                    }
                    relationship.getLayoutRelationship().setBendPoints(externalBendPoints);
                }
                ++n2;
            }
        }

        private static InternalNode[] createInternalNodes(LayoutEntity[] nodes) {
            InternalNode[] internalNodes = new InternalNode[nodes.length];
            BasicEntityConstraint basicEntityConstraint = new BasicEntityConstraint();
            int i = 0;
            while (i < nodes.length) {
                basicEntityConstraint.clear();
                LayoutEntity externalNode = nodes[i];
                InternalNode internalNode = new InternalNode(externalNode);
                externalNode.populateLayoutConstraint(basicEntityConstraint);
                internalNode.setInternalLocation(externalNode.getXInLayout(), externalNode.getYInLayout());
                internalNodes[i] = internalNode;
                ++i;
            }
            return internalNodes;
        }

        private static InternalRelationship[] createInternalRelationships(LayoutRelationship[] rels) {
            ArrayList<InternalRelationship> listOfInternalRelationships = new ArrayList<InternalRelationship>(rels.length);
            LayoutRelationship[] layoutRelationshipArray = rels;
            int n = rels.length;
            int n2 = 0;
            while (n2 < n) {
                LayoutRelationship relation = layoutRelationshipArray[n2];
                InternalNode src = (InternalNode)relation.getSourceInLayout().getLayoutInformation();
                InternalNode dest = (InternalNode)relation.getDestinationInLayout().getLayoutInformation();
                if (src == null || dest == null) {
                    throw new RuntimeException("Error creating internal relationship, one of the nodes is null: src=" + String.valueOf(src) + ", dest=" + String.valueOf(dest));
                }
                InternalRelationship internalRelationship = new InternalRelationship(relation, src, dest);
                listOfInternalRelationships.add(internalRelationship);
                ++n2;
            }
            return listOfInternalRelationships.toArray(new InternalRelationship[listOfInternalRelationships.size()]);
        }

        private Object[] filterUnwantedObjects(LayoutItem[] objects) {
            ArrayList<LayoutItem> unfilteredObjsList = new ArrayList<LayoutItem>();
            if (this.filter != null) {
                LayoutItem[] layoutItemArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    LayoutItem object = layoutItemArray[n2];
                    if (!this.filter.isObjectFiltered(object)) {
                        unfilteredObjsList.add(object);
                    }
                    ++n2;
                }
                Object[] unfilteredObjs = (Object[])Array.newInstance(objects.getClass().getComponentType(), unfilteredObjsList.size());
                unfilteredObjsList.toArray(unfilteredObjs);
                return unfilteredObjs;
            }
            return objects;
        }

        @Override
        @Deprecated
        public void setFilter(Filter filter) {
            this.filter = filter;
        }

        @Override
        @Deprecated
        public void setComparator(Comparator comparator) {
            this.comparator = new InternalComparator(comparator);
        }

        @Deprecated
        public static boolean verifyInput(LayoutEntity[] entitiesToLayout, LayoutRelationship[] relationshipsToConsider) {
            boolean stillValid = true;
            LayoutRelationship[] layoutRelationshipArray = relationshipsToConsider;
            int n = relationshipsToConsider.length;
            int n2 = 0;
            while (n2 < n) {
                LayoutRelationship relationship = layoutRelationshipArray[n2];
                LayoutEntity source = relationship.getSourceInLayout();
                LayoutEntity destination = relationship.getDestinationInLayout();
                boolean containsSrc = false;
                boolean containsDest = false;
                int j = 0;
                while (!(j >= entitiesToLayout.length || containsSrc && containsDest)) {
                    if (entitiesToLayout[j].equals(source)) {
                        containsSrc = true;
                    }
                    if (entitiesToLayout[j].equals(destination)) {
                        containsDest = true;
                    }
                    ++j;
                }
                stillValid = containsSrc && containsDest;
                ++n2;
            }
            return stillValid;
        }

        @Deprecated
        protected DisplayIndependentPoint getLocalLocation(InternalNode[] entitiesToLayout, double x, double y, DisplayIndependentRectangle realBounds) {
            double screenWidth = realBounds.width;
            double screenHeight = realBounds.height;
            DisplayIndependentRectangle layoutBounds = this.getLayoutBounds(entitiesToLayout, false);
            double localX = x / screenWidth * layoutBounds.width + layoutBounds.x;
            double localY = y / screenHeight * layoutBounds.height + layoutBounds.y;
            return new DisplayIndependentPoint(localX, localY);
        }

        @Deprecated
        protected void defaultFitWithinBounds(InternalNode[] entitiesToLayout, DisplayIndependentRectangle realBounds) {
            this.defaultFitWithinBounds(entitiesToLayout, new InternalRelationship[0], realBounds);
        }

        @Deprecated
        protected void defaultFitWithinBounds(InternalNode[] entitiesToLayout, InternalRelationship[] relationships, DisplayIndependentRectangle realBounds) {
            DisplayIndependentRectangle layoutBounds;
            if (this.resizeEntitiesAfterLayout) {
                layoutBounds = this.getLayoutBounds(entitiesToLayout, false);
                Zest1.convertPositionsToPercentage(entitiesToLayout, relationships, layoutBounds, false);
                Zest1.resizeAndShiftNodes(entitiesToLayout);
            }
            layoutBounds = this.getLayoutBounds(entitiesToLayout, true);
            Zest1.convertPositionsToPercentage(entitiesToLayout, relationships, layoutBounds, true);
            DisplayIndependentRectangle screenBounds = this.calcScreenBounds(realBounds, layoutBounds);
            this.convertPositionsToCoords(entitiesToLayout, relationships, screenBounds);
        }

        private DisplayIndependentRectangle calcScreenBounds(DisplayIndependentRectangle realBounds, DisplayIndependentRectangle layoutBounds) {
            if (this.resizeEntitiesAfterLayout) {
                double borderWidth = Math.min(realBounds.width, realBounds.height) / 10.0;
                return new DisplayIndependentRectangle(realBounds.x + borderWidth / 2.0, realBounds.y + borderWidth / 2.0, realBounds.width - borderWidth, realBounds.height - borderWidth);
            }
            double heightAdjustment = realBounds.height / layoutBounds.height;
            double widthAdjustment = realBounds.width / layoutBounds.width;
            double ratio = Math.min(heightAdjustment, widthAdjustment);
            double adjustedHeight = layoutBounds.height * ratio;
            double adjustedWidth = layoutBounds.width * ratio;
            double adjustedX = realBounds.x + (realBounds.width - adjustedWidth) / 2.0;
            double adjustedY = realBounds.y + (realBounds.height - adjustedHeight) / 2.0;
            double borderWidth = Math.min(adjustedWidth, adjustedHeight) / 10.0;
            return new DisplayIndependentRectangle(adjustedX + borderWidth / 2.0, adjustedY + borderWidth / 2.0, adjustedWidth - borderWidth, adjustedHeight - borderWidth);
        }

        private static void resizeAndShiftNodes(InternalNode[] entitiesToLayout) {
            double nodeSize = Zest1.getNodeSize(entitiesToLayout);
            double halfNodeSize = nodeSize / 2.0;
            InternalNode[] internalNodeArray = entitiesToLayout;
            int n = entitiesToLayout.length;
            int n2 = 0;
            while (n2 < n) {
                InternalNode node = internalNodeArray[n2];
                node.setInternalSize(nodeSize, nodeSize);
                node.setInternalLocation(node.getInternalX() + halfNodeSize, node.getInternalY() + halfNodeSize);
                ++n2;
            }
        }

        private static void convertPositionsToPercentage(InternalNode[] entitiesToLayout, InternalRelationship[] relationships, DisplayIndependentRectangle layoutBounds, boolean includeNodeSize) {
            LayoutItem[] layoutItemArray = entitiesToLayout;
            int n = entitiesToLayout.length;
            int n2 = 0;
            while (n2 < n) {
                InternalNode node = layoutItemArray[n2];
                DisplayIndependentPoint location = node.getInternalLocation().convertToPercent(layoutBounds);
                node.setInternalLocation(location.x, location.y);
                if (includeNodeSize) {
                    double width = node.getInternalWidth() / layoutBounds.width;
                    double height = node.getInternalHeight() / layoutBounds.height;
                    node.setInternalSize(width, height);
                }
                ++n2;
            }
            layoutItemArray = relationships;
            n = relationships.length;
            n2 = 0;
            while (n2 < n) {
                LayoutItem rel = layoutItemArray[n2];
                for (Object element : ((InternalRelationship)rel).getBendPoints()) {
                    BendPoint bp = (BendPoint)element;
                    DisplayIndependentPoint toPercent = bp.convertToPercent(layoutBounds);
                    bp.setX(toPercent.x);
                    bp.setY(toPercent.y);
                }
                ++n2;
            }
        }

        private void convertPositionsToCoords(InternalNode[] entitiesToLayout, InternalRelationship[] relationships, DisplayIndependentRectangle screenBounds) {
            LayoutItem[] layoutItemArray = entitiesToLayout;
            int n = entitiesToLayout.length;
            int n2 = 0;
            while (n2 < n) {
                InternalNode node = layoutItemArray[n2];
                double width = node.getInternalWidth() * screenBounds.width;
                double height = node.getInternalHeight() * screenBounds.height;
                DisplayIndependentPoint location = node.getInternalLocation().convertFromPercent(screenBounds);
                node.setInternalLocation(location.x - width / 2.0, location.y - height / 2.0);
                if (this.resizeEntitiesAfterLayout) {
                    this.adjustNodeSizeAndPos(node, height, width);
                } else {
                    node.setInternalSize(width, height);
                }
                ++n2;
            }
            layoutItemArray = relationships;
            n = relationships.length;
            n2 = 0;
            while (n2 < n) {
                LayoutItem rel = layoutItemArray[n2];
                for (Object element : ((InternalRelationship)rel).getBendPoints()) {
                    BendPoint bp = (BendPoint)element;
                    DisplayIndependentPoint fromPercent = bp.convertFromPercent(screenBounds);
                    bp.setX(fromPercent.x);
                    bp.setY(fromPercent.y);
                }
                ++n2;
            }
        }

        private void adjustNodeSizeAndPos(InternalNode node, double height, double width) {
            double widthUsingHeight = height * this.widthToHeightRatio;
            if (this.widthToHeightRatio <= 1.0 && widthUsingHeight <= width) {
                double widthToUse = height * this.widthToHeightRatio;
                double leftOut = width - widthToUse;
                node.setInternalSize(Math.max(height * this.widthToHeightRatio, 5.0), Math.max(height, 5.0));
                node.setInternalLocation(node.getInternalX() + leftOut / 2.0, node.getInternalY());
            } else {
                double heightToUse = height / this.widthToHeightRatio;
                double leftOut = height - heightToUse;
                node.setInternalSize(Math.max(width, 5.0), Math.max(width / this.widthToHeightRatio, 5.0));
                node.setInternalLocation(node.getInternalX(), node.getInternalY() + leftOut / 2.0);
            }
        }

        private static double getNodeSize(InternalNode[] entitiesToLayout) {
            double height;
            double width;
            if (entitiesToLayout.length == 1) {
                width = 0.8;
                height = 0.8;
            } else {
                DisplayIndependentDimension minimumDistance = Zest1.getMinimumDistance(entitiesToLayout);
                width = 0.8 * minimumDistance.width;
                height = 0.8 * minimumDistance.height;
            }
            return Math.max(width, height);
        }

        @Deprecated
        protected DisplayIndependentRectangle getLayoutBounds(InternalNode[] entitiesToLayout, boolean includeNodeSize) {
            double rightSide = Double.MIN_VALUE;
            double bottomSide = Double.MIN_VALUE;
            double leftSide = Double.MAX_VALUE;
            double topSide = Double.MAX_VALUE;
            InternalNode[] internalNodeArray = entitiesToLayout;
            int n = entitiesToLayout.length;
            int n2 = 0;
            while (n2 < n) {
                InternalNode entity = internalNodeArray[n2];
                if (!entity.hasPreferredLocation()) {
                    if (includeNodeSize) {
                        leftSide = Math.min(entity.getInternalX() - entity.getInternalWidth() / 2.0, leftSide);
                        topSide = Math.min(entity.getInternalY() - entity.getInternalHeight() / 2.0, topSide);
                        rightSide = Math.max(entity.getInternalX() + entity.getInternalWidth() / 2.0, rightSide);
                        bottomSide = Math.max(entity.getInternalY() + entity.getInternalHeight() / 2.0, bottomSide);
                    } else {
                        leftSide = Math.min(entity.getInternalX(), leftSide);
                        topSide = Math.min(entity.getInternalY(), topSide);
                        rightSide = Math.max(entity.getInternalX(), rightSide);
                        bottomSide = Math.max(entity.getInternalY(), bottomSide);
                    }
                }
                ++n2;
            }
            return new DisplayIndependentRectangle(leftSide, topSide, rightSide - leftSide, bottomSide - topSide);
        }

        private static DisplayIndependentDimension getMinimumDistance(InternalNode[] entitiesToLayout) {
            DisplayIndependentDimension horAndVertdistance = new DisplayIndependentDimension(Double.MAX_VALUE, Double.MAX_VALUE);
            double minDistance = Double.MAX_VALUE;
            int i = 0;
            while (i < entitiesToLayout.length) {
                InternalNode layoutEntity1 = entitiesToLayout[i];
                double x1 = layoutEntity1.getInternalX();
                double y1 = layoutEntity1.getInternalY();
                int j = i + 1;
                while (j < entitiesToLayout.length) {
                    InternalNode layoutEntity2 = entitiesToLayout[j];
                    double x2 = layoutEntity2.getInternalX();
                    double y2 = layoutEntity2.getInternalY();
                    double distanceX = Math.abs(x1 - x2);
                    double distanceY = Math.abs(y1 - y2);
                    double distance = Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
                    if (distance < minDistance) {
                        minDistance = distance;
                        horAndVertdistance.width = distanceX;
                        horAndVertdistance.height = distanceY;
                    }
                    ++j;
                }
                ++i;
            }
            return horAndVertdistance;
        }

        @Override
        @Deprecated
        public void setEntityAspectRatio(double ratio) {
            this.widthToHeightRatio = ratio;
        }

        @Override
        @Deprecated
        public double getEntityAspectRatio() {
            return this.widthToHeightRatio;
        }

        @Override
        @Deprecated
        public void addProgressListener(ProgressListener listener) {
            if (!this.progressListeners.contains(listener)) {
                this.progressListeners.add(listener);
            }
        }

        @Override
        @Deprecated
        public void removeProgressListener(ProgressListener listener) {
            if (this.progressListeners.contains(listener)) {
                this.progressListeners.remove(listener);
            }
        }

        @Deprecated
        protected void updateLayoutLocations(InternalNode[] nodes) {
            InternalNode[] internalNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                InternalNode node = internalNodeArray[n2];
                if (!node.hasPreferredLocation()) {
                    node.setLocation(node.getInternalX(), node.getInternalY());
                    if ((this.layout_styles & 1) != 1) {
                        node.setSize(node.getInternalWidth(), node.getInternalHeight());
                    }
                }
                ++n2;
            }
        }

        @Deprecated
        protected void fireProgressStarted(int totalNumberOfSteps) {
            ProgressEvent event = new ProgressEvent(0, totalNumberOfSteps);
            List.copyOf(this.progressListeners).forEach(listener -> listener.progressStarted(event));
        }

        @Deprecated
        protected void fireProgressEnded(int totalNumberOfSteps) {
            ProgressEvent event = new ProgressEvent(totalNumberOfSteps, totalNumberOfSteps);
            List.copyOf(this.progressListeners).forEach(listener -> listener.progressEnded(event));
        }

        @Deprecated
        protected void fireProgressUpdated(int currentStep, int totalNumberOfSteps) {
            ProgressEvent event = new ProgressEvent(currentStep, totalNumberOfSteps);
            List.copyOf(this.progressListeners).forEach(listener -> listener.progressUpdated(event));
        }

        @Deprecated
        protected void fireProgressEvent(int currentStep, int totalNumberOfSteps) {
            Calendar now = Calendar.getInstance();
            now.add(14, -1);
            if (now.after(this.lastProgressEventFired) || currentStep == totalNumberOfSteps) {
                this.fireProgressUpdated(currentStep, totalNumberOfSteps);
                this.lastProgressEventFired = Calendar.getInstance();
            }
        }

        @Deprecated
        protected int getNumberOfProgressListeners() {
            return this.progressListeners.size();
        }

        private void checkThread() {
            if (this.creationThread != Thread.currentThread()) {
                throw new RuntimeException("Invalid Thread Access.");
            }
        }

        @Override
        @Deprecated
        public void setLayoutContext(LayoutContext context) {
            throw new UnsupportedOperationException("Not supported in Zest 1.x");
        }

        @Override
        @Deprecated
        public void applyLayout(boolean clean) {
            throw new UnsupportedOperationException("Not supported in Zest 1.x");
        }

        @Deprecated
        class InternalComparator
        implements Comparator<InternalNode> {
            @Deprecated
            Comparator<LayoutEntity> externalComparator = null;

            @Deprecated
            public InternalComparator(Comparator<LayoutEntity> externalComparator) {
                this.externalComparator = externalComparator;
            }

            @Override
            @Deprecated
            public int compare(InternalNode internalNode1, InternalNode internalNode2) {
                return this.externalComparator.compare(internalNode1.getLayoutEntity(), internalNode2.getLayoutEntity());
            }
        }
    }
}

