/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.model;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectFavoriteContainerModel;
import org.eclipse.debug.ui.launchview.internal.model.LaunchObjectModel;
import org.eclipse.swt.graphics.Image;

public class LaunchObjectContainerModel
extends LaunchObjectModel {
    private final Set<LaunchObjectModel> children = new TreeSet<LaunchObjectModel>((a, b) -> {
        if (a instanceof LaunchObjectFavoriteContainerModel) {
            return -1;
        }
        if (b instanceof LaunchObjectFavoriteContainerModel) {
            return 1;
        }
        return a.getLabel().getString().compareTo(b.getLabel().getString());
    });
    private final ILaunchConfigurationType type;

    LaunchObjectContainerModel() {
        this(null, null);
    }

    LaunchObjectContainerModel(ILaunchConfigurationType type) {
        super(type.getName(), type.getIdentifier(), DebugPluginImages.getImage((String)type.getIdentifier()));
        this.type = type;
    }

    protected LaunchObjectContainerModel(String id, Image image) {
        super(id, null, image);
        this.type = null;
    }

    public void addChild(LaunchObjectModel model) {
        this.children.add(model);
    }

    public Set<LaunchObjectModel> getChildren() {
        return this.children;
    }

    public LaunchObjectContainerModel getContainerFor(LaunchObjectModel m) {
        for (LaunchObjectModel child : this.children) {
            if (!(child instanceof LaunchObjectContainerModel) || !m.getObject().getType().equals(((LaunchObjectContainerModel)child).type)) continue;
            return (LaunchObjectContainerModel)child;
        }
        return null;
    }
}

