/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFileMidx;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndexLoader;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.BlockList;

public final class DfsPackFileMidxNPacks
extends DfsPackFileMidx {
    private static final int REF_POSITION = 0;
    private final DfsPackFile[] packsInIdOrder;
    private MultiPackIndex midx;
    private final DfsPackFileMidx base;
    private final VOffsetCalculatorNPacks offsetCalculator;

    DfsPackFileMidxNPacks(DfsBlockCache cache, DfsPackDescription desc, List<DfsPackFile> knownPacks, @Nullable DfsPackFileMidx base) {
        super(cache, desc);
        this.base = base;
        String[] coveredPackNames = (String[])desc.getCoveredPacks().stream().map(DfsPackDescription::getPackName).toArray(String[]::new);
        this.packsInIdOrder = this.getPacksInMidxIdOrder(knownPacks, coveredPackNames);
        this.offsetCalculator = VOffsetCalculatorNPacks.fromPacks(this.packsInIdOrder, base != null ? base.getOffsetCalculator() : null);
        this.length = this.offsetCalculator.getMaxOffset();
    }

    private MultiPackIndex midx(DfsReader ctx) throws IOException {
        AtomicReference<Object> loadedRef;
        if (this.midx != null) {
            return this.midx;
        }
        DfsStreamKey revKey = this.desc.getStreamKey(PackExt.MULTI_PACK_INDEX);
        DfsBlockCache.Ref cachedRef = this.cache.getOrLoadRef(revKey, 0L, () -> this.lambda$2(ctx, loadedRef = new AtomicReference<Object>(null), revKey));
        this.midx = cachedRef.get() != null ? (MultiPackIndex)cachedRef.get() : (MultiPackIndex)loadedRef.get();
        return this.midx;
    }

    private static RefWithSize loadMultiPackIndex(DfsReader ctx, DfsPackDescription desc) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ReadableChannel rc = ctx.db.openFile(desc, PackExt.MULTI_PACK_INDEX);){
            MultiPackIndex midx = MultiPackIndexLoader.read(Channels.newInputStream(rc));
            return new RefWithSize(midx, midx.getMemorySize());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private DfsPackFile[] getPacksInMidxIdOrder(List<DfsPackFile> knownPacks, String[] packNames) {
        Map byName = knownPacks.stream().collect(Collectors.toUnmodifiableMap(p -> p.getPackDescription().getPackName(), Function.identity()));
        DfsPackFile[] result = new DfsPackFile[this.desc.getCoveredPacks().size()];
        int i = 0;
        while (i < packNames.length) {
            DfsPackFile pack = (DfsPackFile)byName.get(packNames[i]);
            if (pack == null) {
                throw new IllegalStateException("Required pack missing");
            }
            result[i] = pack;
            ++i;
        }
        return result;
    }

    @Override
    protected VOffsetCalculatorNPacks getOffsetCalculator() {
        return this.offsetCalculator;
    }

    @Override
    public ObjectIdSet asObjectIdSet(DfsReader ctx) throws IOException {
        MultiPackIndex multiPackIndex = this.midx(ctx);
        return multiPackIndex::hasObject;
    }

    @Override
    public PackBitmapIndex getBitmapIndex(DfsReader ctx) throws IOException {
        if (this.base != null) {
            return this.base.getBitmapIndex(ctx);
        }
        if (ctx.getOptions().shouldUseMidxBitmaps() && this.getPackDescription().hasFileExt(PackExt.BITMAP_INDEX)) {
            return super.getBitmapIndex(ctx);
        }
        DfsPackFile[] dfsPackFileArray = this.packsInIdOrder;
        int n = this.packsInIdOrder.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(ctx);
            if (bitmapIndex != null) {
                return bitmapIndex;
            }
            ++n2;
        }
        return null;
    }

    @Override
    List<DfsPackFile> fullyIncludedIn(DfsReader ctx, BitmapIndex.BitmapBuilder need) throws IOException {
        ArrayList<DfsPackFile> fullyIncluded = new ArrayList<DfsPackFile>();
        DfsPackFile[] dfsPackFileArray = this.packsInIdOrder;
        int n = this.packsInIdOrder.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            List<DfsPackFile> includedPacks = pack.fullyIncludedIn(ctx, need);
            if (!includedPacks.isEmpty()) {
                fullyIncluded.addAll(includedPacks);
            }
            ++n2;
        }
        if (this.base != null) {
            fullyIncluded.addAll(this.base.fullyIncludedIn(ctx, need));
        }
        return fullyIncluded;
    }

    @Override
    public CommitGraph getCommitGraph(DfsReader ctx) throws IOException {
        DfsPackFile[] dfsPackFileArray = this.packsInIdOrder;
        int n = this.packsInIdOrder.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            CommitGraph cg = pack.getCommitGraph(ctx);
            if (cg != null) {
                return cg;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public List<ObjectToPack> getLocalObjects(DfsReader ctx) throws IOException {
        MultiPackIndex midx = this.midx(ctx);
        int localObjCount = this.midx(ctx).getObjectCount();
        ArrayList<ObjectToPack> otps = new ArrayList<ObjectToPack>(localObjCount);
        int idxPosition = 0;
        while (idxPosition < localObjCount) {
            ObjectId oid = midx.getObjectAt(idxPosition);
            MultiPackIndex.PackOffset packOffset = midx.find(oid);
            long offset = this.offsetCalculator.encode(packOffset);
            int objectType = this.getObjectType(ctx, offset);
            ObjectToPack otp = new ObjectToPack(oid, objectType);
            otp.setOffset(offset);
            otps.add(otp);
            ++idxPosition;
        }
        return otps;
    }

    @Override
    public PackReverseIndex getReverseIdx(DfsReader ctx) throws IOException {
        return new MidxReverseIndex(ctx, this, this.base == null ? 0 : this.base.getObjectCount(ctx), this.getOffsetCalculator().baseMaxOffset, this.base == null ? null : this.base.getReverseIdx(ctx));
    }

    @Override
    protected int getObjectCount(DfsReader ctx) throws IOException {
        int baseObjectCount = this.base == null ? 0 : this.base.getObjectCount(ctx);
        return this.midx(ctx).getObjectCount() + baseObjectCount;
    }

    @Override
    protected byte[] getChecksum(DfsReader ctx) throws IOException {
        return this.midx(ctx).getChecksum();
    }

    @Override
    protected MultiPackIndex.MidxIterator localIterator(DfsReader ctx) throws IOException {
        return this.midx(ctx).iterator();
    }

    @Override
    public List<DfsPackFile> getCoveredPacks() {
        return List.of(this.packsInIdOrder);
    }

    @Override
    public DfsPackFileMidx getMultipackIndexBase() {
        return this.base;
    }

    @Override
    ObjectId getObjectAt(DfsReader ctx, long nthPosition) throws IOException {
        int baseObjectCount;
        int n = baseObjectCount = this.base == null ? 0 : this.base.getObjectCount(ctx);
        if (nthPosition >= (long)baseObjectCount) {
            long localPosition = nthPosition - (long)baseObjectCount;
            return this.midx(ctx).getObjectAt((int)localPosition);
        }
        return this.base.getObjectAt(ctx, nthPosition);
    }

    @Override
    public int findIdxPosition(DfsReader ctx, AnyObjectId id) throws IOException {
        int p = this.midx(ctx).findPosition(id);
        if (p >= 0) {
            int baseObjects = this.base == null ? 0 : this.base.getObjectCount(ctx);
            return p + baseObjects;
        }
        if (this.base == null) {
            return -1;
        }
        return this.base.findIdxPosition(ctx, id);
    }

    @Override
    public boolean hasObject(DfsReader ctx, AnyObjectId id) throws IOException {
        if (this.midx(ctx).hasObject(id)) {
            return true;
        }
        if (this.base == null) {
            return false;
        }
        return this.base.hasObject(ctx, id);
    }

    @Override
    ObjectLoader get(DfsReader ctx, AnyObjectId id) throws IOException {
        MultiPackIndex.PackOffset location = this.midx(ctx).find(id);
        if (location != null) {
            return this.packsInIdOrder[location.getPackId()].get(ctx, id);
        }
        if (this.base == null) {
            return null;
        }
        return this.base.get(ctx, id);
    }

    @Override
    long findOffset(DfsReader ctx, AnyObjectId id) throws IOException {
        MultiPackIndex.PackOffset location = this.midx(ctx).find(id);
        if (location != null) {
            return this.offsetCalculator.encode(location);
        }
        if (this.base == null) {
            return -1L;
        }
        return this.base.findOffset(ctx, id);
    }

    @Override
    void resolve(DfsReader ctx, Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        this.midx(ctx).resolve(matches, id, matchLimit);
        if (matches.size() < matchLimit && this.base != null) {
            this.base.resolve(ctx, matches, id, matchLimit);
        }
    }

    @Override
    void copyPackAsIs(PackOutputStream out, DfsReader ctx) throws IOException {
        DfsPackFile[] dfsPackFileArray = this.packsInIdOrder;
        int n = this.packsInIdOrder.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            pack.copyPackAsIs(out, ctx);
            ++n2;
        }
        if (this.base != null) {
            this.base.copyPackAsIs(out, ctx);
        }
    }

    @Override
    long getObjectSize(DfsReader ctx, AnyObjectId id) throws IOException {
        MultiPackIndex.PackOffset local = this.midx(ctx).find(id);
        if (local != null) {
            return this.packsInIdOrder[local.getPackId()].getObjectSize(ctx, id);
        }
        if (this.base == null) {
            return -1L;
        }
        return this.base.getObjectSize(ctx, id);
    }

    @Override
    boolean hasObjectSizeIndex(DfsReader ctx) {
        return false;
    }

    @Override
    int getObjectSizeIndexThreshold(DfsReader ctx) {
        return Integer.MAX_VALUE;
    }

    @Override
    long getIndexedObjectSize(DfsReader ctx, int idxPosition) {
        return -1L;
    }

    @Override
    List<DfsObjectToPack> findAllFromPack(DfsReader ctx, Iterable<ObjectToPack> objects, boolean skipFound) throws IOException {
        BlockList<DfsObjectToPack> tmp = new BlockList<DfsObjectToPack>();
        BlockList<ObjectToPack> notFoundHere = new BlockList<ObjectToPack>();
        for (ObjectToPack obj : objects) {
            DfsObjectToPack otp = (DfsObjectToPack)obj;
            if (skipFound && otp.isFound()) continue;
            long p = this.offsetCalculator.encode(this.midx(ctx).find(otp));
            if (p < 0L) {
                notFoundHere.add(otp);
                continue;
            }
            otp.setOffset(p);
            tmp.add(otp);
        }
        if (this.base != null && !notFoundHere.isEmpty()) {
            List<DfsObjectToPack> inChain = this.base.findAllFromPack(ctx, notFoundHere, skipFound);
            tmp.addAll(inChain);
        }
        tmp.sort(OFFSET_SORT);
        return tmp;
    }

    private /* synthetic */ DfsBlockCache.Ref lambda$2(DfsReader dfsReader, AtomicReference atomicReference, DfsStreamKey dfsStreamKey) throws IOException {
        RefWithSize midx1 = DfsPackFileMidxNPacks.loadMultiPackIndex(dfsReader, this.desc);
        atomicReference.set(midx1.idx);
        return new DfsBlockCache.Ref<MultiPackIndex>(dfsStreamKey, 0L, midx1.size, midx1.idx);
    }

    private static final class MidxReverseIndex
    implements PackReverseIndex {
        private final PackReverseIndex parentRidx;
        private final DfsPackFileMidxNPacks localMidx;
        private final DfsReader ctx;
        private final long baseObjectCount;
        private final long baseMaxOffset;

        MidxReverseIndex(DfsReader ctx, DfsPackFileMidxNPacks localMidx, long baseObjectCount, long baseMaxOffset, PackReverseIndex parentRidx) {
            this.ctx = ctx;
            this.parentRidx = parentRidx;
            this.localMidx = localMidx;
            this.baseObjectCount = baseObjectCount;
            this.baseMaxOffset = baseMaxOffset;
        }

        @Override
        public void verifyPackChecksum(String packFilePath) throws PackMismatchException {
        }

        private MultiPackIndex loadLocalMidx() {
            try {
                return this.localMidx.midx(this.ctx);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ObjectId findObject(long offset) {
            if (offset < this.baseMaxOffset) {
                return this.parentRidx.findObject(offset);
            }
            MultiPackIndex.PackOffset localPo = this.localMidx.getOffsetCalculator().decodeLocal(offset);
            if (localPo == null) {
                return null;
            }
            int p = this.loadLocalMidx().findBitmapPosition(localPo);
            if (p == -1) {
                throw new IllegalStateException();
            }
            return this.loadLocalMidx().getObjectAtBitmapPosition(p);
        }

        @Override
        public long findNextOffset(long offset, long maxOffset) throws CorruptObjectException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int findPosition(long offset) {
            if (offset < this.baseMaxOffset) {
                return this.parentRidx.findPosition(offset);
            }
            MultiPackIndex.PackOffset localPo = this.localMidx.getOffsetCalculator().decodeLocal(offset);
            if (localPo == null) {
                return -1;
            }
            return this.loadLocalMidx().findBitmapPosition(localPo) + (int)this.baseObjectCount;
        }

        @Override
        public ObjectId findObjectByPosition(int nthPosition) {
            if ((long)nthPosition < this.baseObjectCount) {
                return this.parentRidx.findObjectByPosition(nthPosition);
            }
            return this.loadLocalMidx().getObjectAtBitmapPosition(nthPosition - (int)this.baseObjectCount);
        }
    }

    private record RefWithSize(MultiPackIndex idx, long size) {
    }

    static class VOffsetCalculatorNPacks
    implements DfsPackFileMidx.VOffsetCalculator {
        private final DfsPackFile[] packs;
        private final long[] accSizes;
        private final long baseMaxOffset;
        private final DfsPackFileMidx.VOffsetCalculator baseOffsetCalculator;
        private final DfsPackFileMidx.DfsPackOffset poBuffer = new DfsPackFileMidx.DfsPackOffset();
        private final MultiPackIndex.PackOffset localPoBuffer = new MultiPackIndex.PackOffset();

        static VOffsetCalculatorNPacks fromPacks(DfsPackFile[] packsInIdOrder, DfsPackFileMidx.VOffsetCalculator baseOffsetCalculator) {
            long[] accSizes = new long[packsInIdOrder.length + 1];
            accSizes[0] = 0L;
            int i = 0;
            while (i < packsInIdOrder.length) {
                accSizes[i + 1] = accSizes[i] + packsInIdOrder[i].getPackDescription().getFileSize(PackExt.PACK);
                ++i;
            }
            return new VOffsetCalculatorNPacks(packsInIdOrder, accSizes, baseOffsetCalculator);
        }

        VOffsetCalculatorNPacks(DfsPackFile[] packs, long[] packSizes, DfsPackFileMidx.VOffsetCalculator baseOffsetCalculator) {
            this.packs = packs;
            this.baseOffsetCalculator = baseOffsetCalculator;
            this.baseMaxOffset = baseOffsetCalculator != null ? baseOffsetCalculator.getMaxOffset() : 0L;
            this.accSizes = packSizes;
        }

        long encode(MultiPackIndex.PackOffset location) {
            if (location == null) {
                return -1L;
            }
            return location.getOffset() + this.accSizes[location.getPackId()] + this.baseMaxOffset;
        }

        MultiPackIndex.PackOffset decodeLocal(long voffset) {
            if (voffset == -1L || voffset < this.baseMaxOffset || voffset > this.getMaxOffset()) {
                return null;
            }
            long localOffset = voffset - this.baseMaxOffset;
            int i = 1;
            while (i < this.accSizes.length) {
                if (localOffset <= this.accSizes[i]) {
                    return this.localPoBuffer.setValues(i - 1, localOffset - this.accSizes[i - 1]);
                }
                ++i;
            }
            return null;
        }

        @Override
        public DfsPackFileMidx.DfsPackOffset decode(long voffset) {
            if (voffset == -1L) {
                return null;
            }
            if (voffset < this.baseMaxOffset) {
                return this.baseOffsetCalculator.decode(voffset);
            }
            long localOffset = voffset - this.baseMaxOffset;
            int i = 0;
            while (i < this.accSizes.length) {
                if (localOffset <= this.accSizes[i]) {
                    return this.poBuffer.setValues(this.packs[i - 1], this.accSizes[i - 1] + this.baseMaxOffset, voffset);
                }
                ++i;
            }
            throw new IllegalArgumentException("Asking offset beyond limits");
        }

        @Override
        public long getMaxOffset() {
            return this.accSizes[this.accSizes.length - 1] + this.baseMaxOffset;
        }
    }
}

