/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.Base64;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DBGpUtils {
    private static final String ENCODING_BASE64 = "base64";
    private static Map<String, String> encoded = Collections.synchronizedMap(new HashMap());

    public static String getEncodedStringValue(@NonNull Node node, @NonNull String encodingCharset) {
        String valueString = "";
        Node child = node.getFirstChild();
        if (child != null) {
            String valueData;
            valueString = valueData = child.getNodeValue();
            if (node.hasAttributes()) {
                NamedNodeMap attrs = node.getAttributes();
                Node attribute = attrs.getNamedItem("encoding");
                String nodeEncoding = null;
                if (attribute != null) {
                    nodeEncoding = attribute.getNodeValue();
                }
                if (nodeEncoding != null && nodeEncoding.equalsIgnoreCase(ENCODING_BASE64) && valueData != null && valueData.trim().length() != 0) {
                    byte[] valueBytes = Base64.decode(valueData.trim());
                    try {
                        valueString = new String(valueBytes, encodingCharset);
                    }
                    catch (UnsupportedEncodingException e) {
                        DBGpLogger.logException("Unexpected encoding problem", node, e);
                        valueString = new String(valueBytes);
                    }
                }
            }
        }
        return valueString;
    }

    public static String getFileURIString(String fileName) {
        if (encoded.containsKey(fileName)) {
            return encoded.get(fileName);
        }
        String fileURIStr = "";
        if (fileName == null || ((String)fileName).length() == 0) {
            return fileURIStr;
        }
        if (((String)fileName).charAt(0) != '/') {
            fileName = "/" + (String)fileName;
        }
        try {
            URI uri = new URI("file", "", (String)fileName, null, null);
            fileURIStr = DBGpUtils.adjustURIWhiteSpaces(uri.toASCIIString());
            encoded.put((String)fileName, fileURIStr);
        }
        catch (URISyntaxException e) {
            DBGpLogger.logException("URISyntaxException - 1", null, e);
        }
        return fileURIStr;
    }

    public static String getFilenameFromURIString(String fileURIStr) {
        String filePath = "";
        try {
            fileURIStr = DBGpUtils.adjustURIWhiteSpaces(fileURIStr);
            URI uri = new URI(fileURIStr);
            filePath = uri.getPath();
            if (filePath != null && filePath.length() > 2 && filePath.charAt(2) == ':') {
                filePath = filePath.substring(1);
            }
        }
        catch (URISyntaxException e) {
            DBGpLogger.logException("URISyntaxException - 2", null, e);
        }
        return filePath;
    }

    public static boolean isGoodDBGpResponse(Object caller, DBGpResponse resp) {
        if (resp == null) {
            return false;
        }
        if (resp.getType() == 2 || resp.getType() == 3) {
            if (resp.getErrorCode() == 0 || resp.getErrorCode() == 300) {
                return true;
            }
            if (resp.getErrorCode() != 206) {
                DBGpLogger.logError("DBGp Response Error: " + resp.getCommand() + ":=" + resp.getErrorCode() + " msg:" + resp.getErrorMessage(), caller, null);
            }
        } else {
            DBGpLogger.logError("Unexpected XML or parser failure: " + String.valueOf(resp.getRawXML()), caller, null);
        }
        return false;
    }

    private static String adjustURIWhiteSpaces(String fileName) {
        return fileName.replaceAll(" ", "%20");
    }
}

