/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.parser.JavadocTokenizer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import jdk.javadoc.internal.doclint.DocLint;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTConverter;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.core.dom.JavacConverter;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NameEnvironmentWithProgress;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IDependent;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.CancelableNameEnvironment;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.dom.ICompilationUnitResolver;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.SecondaryTypeDeclarationPattern;
import org.eclipse.jdt.internal.core.util.BindingKeyParser;
import org.eclipse.jdt.internal.javac.AccessRestrictionTreeScanner;
import org.eclipse.jdt.internal.javac.AvoidNPEJavacTypes;
import org.eclipse.jdt.internal.javac.CachingClassSymbolClassReader;
import org.eclipse.jdt.internal.javac.CachingJDKPlatformArguments;
import org.eclipse.jdt.internal.javac.CachingJarsJavaFileManager;
import org.eclipse.jdt.internal.javac.JavacProblem;
import org.eclipse.jdt.internal.javac.JavacProblemConverter;
import org.eclipse.jdt.internal.javac.JavacUtils;
import org.eclipse.jdt.internal.javac.ProcessorConfig;
import org.eclipse.jdt.internal.javac.UnusedProblemFactory;
import org.eclipse.jdt.internal.javac.UnusedTreeScanner;

public class JavacCompilationUnitResolver
implements ICompilationUnitResolver {
    private static final String MOCK_NAME_FOR_CLASSES = "whatever_InvalidNameWE_HOP3_n00ne_will_Ever_use_in_real_file.java";
    public static final Context.Key<Map<JavaFileObject, File>> FILE_OBJECTS_TO_JAR_KEY = new Context.Key();
    private static Names names = new Names(new Context()){

        @Override
        public void dispose() {
        }
    };
    private static ArrayList<IProject> listCompilationUnitsWithMultipleTopLevelClasses_locks = new ArrayList();

    private java.util.List<org.eclipse.jdt.internal.compiler.env.ICompilationUnit> createSourceUnitList(String[] sourceFilePaths, String[] encodings) {
        int length = sourceFilePaths.length;
        ArrayList<org.eclipse.jdt.internal.compiler.env.ICompilationUnit> sourceUnitList = new ArrayList<org.eclipse.jdt.internal.compiler.env.ICompilationUnit>(length);
        for (int i = 0; i < length; ++i) {
            String encoding = encodings == null ? null : (i >= encodings.length ? null : encodings[i]);
            org.eclipse.jdt.internal.compiler.env.ICompilationUnit obj = this.createSourceUnit(sourceFilePaths[i], encoding);
            if (obj == null) continue;
            sourceUnitList.add(obj);
        }
        return sourceUnitList;
    }

    private org.eclipse.jdt.internal.compiler.env.ICompilationUnit createSourceUnit(String sourceFilePath, String encoding) {
        char[] contents = null;
        try {
            contents = Util.getFileCharContent((File)new File(sourceFilePath), (String)encoding);
        }
        catch (IOException e) {
            return null;
        }
        if (contents == null) {
            return null;
        }
        return new org.eclipse.jdt.internal.compiler.batch.CompilationUnit(contents, sourceFilePath, encoding);
    }

    public void resolve(String[] sourceFilePaths, String[] encodings, String[] bindingKeys, FileASTRequestor requestor, int apiLevel, Map<String, String> compilerOptions, java.util.List<FileSystem.Classpath> classpaths, int flags, IProgressMonitor monitor) {
        java.util.List<org.eclipse.jdt.internal.compiler.env.ICompilationUnit> sourceUnitList = this.createSourceUnitList(sourceFilePaths, encodings);
        JavacBindingResolver bindingResolver = null;
        Map<org.eclipse.jdt.internal.compiler.env.ICompilationUnit, CompilationUnit> res = this.parse((org.eclipse.jdt.internal.compiler.env.ICompilationUnit[])sourceUnitList.toArray(org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]::new), apiLevel, compilerOptions, true, flags, null, classpaths, null, -1, monitor);
        for (Map.Entry<org.eclipse.jdt.internal.compiler.env.ICompilationUnit, CompilationUnit> entry : res.entrySet()) {
            CompilationUnit cu = entry.getValue();
            requestor.acceptAST(new String(entry.getKey().getFileName()), cu);
            if (bindingResolver != null || (JavacBindingResolver)cu.ast.getBindingResolver() == null) continue;
            bindingResolver = (JavacBindingResolver)cu.ast.getBindingResolver();
        }
        this.resolveRequestedBindingKeys(bindingResolver, bindingKeys, (a, b) -> requestor.acceptBinding(a, b), (FileSystem.Classpath[])classpaths.stream().toArray(FileSystem.Classpath[]::new), new CompilerOptions(compilerOptions), res.values(), null, new HashMap<String, IBinding>(), monitor);
    }

    private ICompilationUnit createMockUnit(IJavaProject project, IProgressMonitor monitor) {
        try {
            for (IPackageFragmentRoot root : project.getPackageFragmentRoots()) {
                if (!(root.getResource() instanceof IFolder)) continue;
                IPackageFragment pack = root.getPackageFragment(this.getClass().getName() + ".MOCK_WORKING_COPY_PACKAGE_" + System.nanoTime());
                ICompilationUnit mockUnit = pack.getCompilationUnit("A.java");
                mockUnit.becomeWorkingCopy(monitor);
                mockUnit.getBuffer().setContents("package " + pack.getElementName() + ";\nclass A{}");
                return mockUnit;
            }
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public void resolve(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, int apiLevel, Map<String, String> compilerOptions, IJavaProject project, WorkingCopyOwner workingCopyOwner, int flags, IProgressMonitor monitor) {
        ICompilationUnit mockUnit;
        ICompilationUnit iCompilationUnit = mockUnit = compilationUnits.length == 0 && bindingKeys.length > 0 ? this.createMockUnit(project, monitor) : null;
        if (mockUnit != null) {
            compilationUnits = new ICompilationUnit[]{mockUnit};
        }
        Map<ICompilationUnit, CompilationUnit> units = this.parse(compilationUnits, apiLevel, compilerOptions, true, flags, workingCopyOwner, monitor);
        if (requestor != null) {
            BindingResolver[] bindingResolver = new JavacBindingResolver[]{null};
            HashMap<String, IBinding> bindingMap = new HashMap<String, IBinding>();
            NameEnvironmentWithProgress environment = null;
            if (project instanceof JavaProject) {
                JavaProject javaProject = (JavaProject)project;
                try {
                    environment = new CancelableNameEnvironment(javaProject, workingCopyOwner, monitor);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            if (environment == null) {
                environment = new NameEnvironmentWithProgress(new FileSystem.Classpath[0], null, monitor);
            }
            LookupEnvironment lu = new LookupEnvironment(new ITypeRequestor(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
                }

                public void accept(org.eclipse.jdt.internal.compiler.env.ICompilationUnit unit, AccessRestriction accessRestriction) {
                }

                public void accept(ISourceType[] sourceType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
                }
            }, new CompilerOptions(compilerOptions), null, (INameEnvironment)environment);
            requestor.additionalBindingResolver = JavacCompilationUnitResolver.javacAdditionalBindingCreator(bindingMap, (INameEnvironment)environment, lu, bindingResolver);
            units.forEach((arg_0, arg_1) -> this.lambda$resolve$3((JavacBindingResolver[])bindingResolver, bindingMap, apiLevel, mockUnit, requestor, arg_0, arg_1));
            this.resolveRequestedBindingKeys((JavacBindingResolver)bindingResolver[0], bindingKeys, (a, b) -> {
                if (b != null || mockUnit != null) {
                    requestor.acceptBinding(a, b);
                }
            }, new FileSystem.Classpath[0], new CompilerOptions(compilerOptions), units.values(), project, bindingMap, monitor);
        } else {
            Iterator<CompilationUnit> it = units.values().iterator();
            while (it.hasNext()) {
                this.resolveBindings(it.next(), apiLevel);
            }
        }
    }

    private void resolveRequestedBindingKeys(JavacBindingResolver bindingResolver, String[] bindingKeys, GenericRequestor requestor, FileSystem.Classpath[] cp, CompilerOptions opts, Collection<CompilationUnit> units, IJavaProject project, Map<String, IBinding> bindingMap, IProgressMonitor monitor) {
        if (bindingResolver == null) {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            Context context = new Context();
            JavacTask task = (JavacTask)compiler.getTask(null, null, null, java.util.List.of(), java.util.List.of(), java.util.List.of());
            bindingResolver = new JavacBindingResolver(null, task, context, new JavacConverter(null, null, context, null, true, -1), null, null);
        }
        for (CompilationUnit cu : units) {
            cu.accept((ASTVisitor)new BindingBuilder(bindingMap));
        }
        NameEnvironmentWithProgress environment = null;
        if (project instanceof JavaProject) {
            JavaProject javaProject = (JavaProject)project;
            try {
                environment = new CancelableNameEnvironment(javaProject, null, monitor);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        if (environment == null) {
            environment = new NameEnvironmentWithProgress(cp, null, monitor);
        }
        for (String bindingKey : bindingKeys) {
            String elementKey;
            IBinding elementBinding;
            int arrayCount = Signature.getArrayCount((String)bindingKey);
            Object binding = bindingMap.get(bindingKey);
            if (binding == null && arrayCount > 0 && (elementBinding = bindingMap.get(elementKey = Signature.getElementType((String)bindingKey))) instanceof ITypeBinding) {
                binding = elementBinding;
            }
            if (binding == null) {
                CustomBindingKeyParser bkp = new CustomBindingKeyParser(bindingKey);
                bkp.parse(true);
                ITypeBinding type = bindingResolver.resolveTypeFromContext(bkp.compoundName);
                if (type != null) {
                    binding = Objects.equals(bindingKey, type.getKey()) ? type : (IBinding)Stream.of(type.getDeclaredMethods(), type.getDeclaredFields()).flatMap(Arrays::stream).filter(b -> Objects.equals(b.getKey(), bindingKey)).findAny().orElse(null);
                }
            }
            requestor.acceptBinding(bindingKey, (IBinding)binding);
        }
    }

    public void parse(ICompilationUnit[] compilationUnits, ASTRequestor requestor, int apiLevel, Map<String, String> compilerOptions, int flags, IProgressMonitor monitor) {
        WorkingCopyOwner workingCopyOwner = Arrays.stream(compilationUnits).filter(ICompilationUnit.class::isInstance).map(ICompilationUnit.class::cast).map(ICompilationUnit::getOwner).filter(Objects::nonNull).findFirst().orElse(null);
        Map<ICompilationUnit, CompilationUnit> units = this.parse(compilationUnits, apiLevel, compilerOptions, false, flags, workingCopyOwner, monitor);
        if (requestor != null) {
            units.forEach((arg_0, arg_1) -> ((ASTRequestor)requestor).acceptAST(arg_0, arg_1));
        }
    }

    private Map<ICompilationUnit, CompilationUnit> parse(ICompilationUnit[] compilationUnits, int apiLevel, Map<String, String> compilerOptions, boolean resolveBindings, int flags, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) {
        if (compilationUnits.length > 0 && Arrays.stream(compilationUnits).map(IJavaElement::getJavaProject).distinct().count() == 1L) {
            if (Arrays.stream(compilationUnits).allMatch(org.eclipse.jdt.internal.compiler.env.ICompilationUnit.class::isInstance)) {
                Map<ICompilationUnit, CompilationUnit> res = this.parse((org.eclipse.jdt.internal.compiler.env.ICompilationUnit[])Arrays.stream(compilationUnits).map(org.eclipse.jdt.internal.compiler.env.ICompilationUnit.class::cast).toArray(org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]::new), apiLevel, compilerOptions, resolveBindings, flags, compilationUnits[0].getJavaProject(), null, workingCopyOwner, -1, monitor).entrySet().stream().collect(Collectors.toMap(entry -> (ICompilationUnit)entry.getKey(), entry -> (CompilationUnit)entry.getValue()));
                for (ICompilationUnit in : compilationUnits) {
                    CompilationUnit c = res.get(in);
                    if (c == null) continue;
                    c.setTypeRoot((ITypeRoot)in);
                }
                return res;
            }
        }
        HashMap<ICompilationUnit, CompilationUnit> res = new HashMap<ICompilationUnit, CompilationUnit>(compilationUnits.length, 1.0f);
        for (ICompilationUnit in : compilationUnits) {
            if (!(in instanceof org.eclipse.jdt.internal.compiler.env.ICompilationUnit)) continue;
            org.eclipse.jdt.internal.compiler.env.ICompilationUnit compilerUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)in;
            res.put(in, this.parse(new org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]{compilerUnit}, apiLevel, compilerOptions, resolveBindings, flags, in.getJavaProject(), null, workingCopyOwner, -1, monitor).get(compilerUnit));
            ((CompilationUnit)res.get(in)).setTypeRoot((ITypeRoot)in);
        }
        return res;
    }

    public void parse(String[] sourceFilePaths, String[] encodings, FileASTRequestor requestor, int apiLevel, Map<String, String> compilerOptions, int flags, IProgressMonitor monitor) {
        for (int i = 0; i < sourceFilePaths.length; ++i) {
            org.eclipse.jdt.internal.compiler.env.ICompilationUnit ast = this.createSourceUnit(sourceFilePaths[i], encodings[i]);
            Map<org.eclipse.jdt.internal.compiler.env.ICompilationUnit, CompilationUnit> res = this.parse(new org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]{ast}, apiLevel, compilerOptions, false, flags, null, null, null, -1, monitor);
            CompilationUnit result = res.get(ast);
            requestor.acceptAST(sourceFilePaths[i], result);
        }
    }

    private void resolveBindings(CompilationUnit unit, int apiLevel) {
        this.resolveBindings(unit, new HashMap<String, IBinding>(), apiLevel);
    }

    private void resolveBindings(CompilationUnit unit, final Map<String, IBinding> bindingMap, int apiLevel) {
        try {
            IModuleBinding mb;
            IPackageBinding pb;
            if (unit.getPackage() != null && (pb = unit.getPackage().resolveBinding()) != null) {
                bindingMap.put(pb.getKey(), (IBinding)pb);
            }
            if (apiLevel >= 9 && unit.getModule() != null && (mb = unit.getModule().resolveBinding()) != null) {
                bindingMap.put(mb.getKey(), (IBinding)mb);
            }
            unit.accept(new ASTVisitor(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public void preVisit(ASTNode node) {
                    Type t;
                    ITypeBinding tb;
                    if (node instanceof Type && (tb = (t = (Type)node).resolveBinding()) != null) {
                        bindingMap.put(tb.getKey(), tb);
                    }
                }
            });
            if (!unit.types().isEmpty()) {
                java.util.List types = unit.types();
                for (int i = 0; i < types.size(); ++i) {
                    ITypeBinding tb = ((AbstractTypeDeclaration)types.get(i)).resolveBinding();
                    if (tb == null) continue;
                    bindingMap.put(tb.getKey(), (IBinding)tb);
                }
            }
        }
        catch (Exception e) {
            ILog.get().warn("Failed to resolve binding", (Throwable)e);
        }
    }

    public CompilationUnit toCompilationUnit(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean resolveBindings, IJavaProject project, java.util.List<FileSystem.Classpath> classpaths, int focalPoint, int apiLevel, Map<String, String> compilerOptions, WorkingCopyOwner workingCopyOwner, WorkingCopyOwner typeRootWorkingCopyOwner, int flags, IProgressMonitor monitor) {
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(workingCopyOwner, true);
        if (workingCopies == null) {
            workingCopies = new ICompilationUnit[]{};
        }
        HashMap<String, org.eclipse.jdt.internal.compiler.env.ICompilationUnit> pathToUnit = new HashMap<String, org.eclipse.jdt.internal.compiler.env.ICompilationUnit>();
        Arrays.stream(workingCopies).filter(inMemoryCu -> {
            try {
                return inMemoryCu.hasUnsavedChanges() && (project == null || inMemoryCu.getElementName() != null && !inMemoryCu.getElementName().contains("module-info") || inMemoryCu.getJavaProject() == project);
            }
            catch (JavaModelException e) {
                return project == null || inMemoryCu.getElementName() != null && !inMemoryCu.getElementName().contains("module-info") || inMemoryCu.getJavaProject() == project;
            }
        }).map(org.eclipse.jdt.internal.compiler.env.ICompilationUnit.class::cast).forEach(inMemoryCu -> pathToUnit.put(new String(inMemoryCu.getFileName()), (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)inMemoryCu));
        String pathOfClassUnderAnalysis = new String(sourceUnit.getFileName());
        if (!pathToUnit.keySet().contains(pathOfClassUnderAnalysis)) {
            java.util.List<String> potentialPaths = pathToUnit.keySet().stream().filter(path -> path.endsWith(pathOfClassUnderAnalysis)).toList();
            if (potentialPaths.isEmpty()) {
                pathToUnit.put(pathOfClassUnderAnalysis, sourceUnit);
            } else if (potentialPaths.size() == 1) {
                pathToUnit.put(potentialPaths.get(0), sourceUnit);
            } else {
                for (String potentialPath : potentialPaths) {
                    pathToUnit.remove(potentialPath);
                }
                pathToUnit.put(pathOfClassUnderAnalysis, sourceUnit);
            }
        } else {
            pathToUnit.put(pathOfClassUnderAnalysis, sourceUnit);
        }
        CompilationUnit res = this.parse((org.eclipse.jdt.internal.compiler.env.ICompilationUnit[])pathToUnit.values().toArray(org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]::new), apiLevel, compilerOptions, resolveBindings, flags | (resolveBindings ? Integer.MIN_VALUE : 0), project, classpaths, typeRootWorkingCopyOwner, focalPoint, monitor).get(sourceUnit);
        if (resolveBindings && focalPoint == -1) {
            this.resolveBindings(res, apiLevel);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<org.eclipse.jdt.internal.compiler.env.ICompilationUnit, CompilationUnit> parse(org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] sourceUnits, int apiLevel, final Map<String, String> compilerOptions, boolean resolveBindings, final int flags, final IJavaProject javaProject, java.util.List<FileSystem.Classpath> extraClasspath, WorkingCopyOwner workingCopyOwner, final int focalPoint, IProgressMonitor monitor) {
        Object ast;
        if (sourceUnits.length == 0) {
            return Collections.emptyMap();
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        final Context context = new Context();
        context.put(Names.namesKey, names);
        CachingJarsJavaFileManager.preRegister(context);
        CachingJDKPlatformArguments.preRegister(context);
        CachingClassSymbolClassReader.preRegister(context);
        AvoidNPEJavacTypes.preRegister(context);
        HashMap<org.eclipse.jdt.internal.compiler.env.ICompilationUnit, CompilationUnit> result = new HashMap<org.eclipse.jdt.internal.compiler.env.ICompilationUnit, CompilationUnit>(sourceUnits.length, 1.0f);
        final HashMap<JavaFileObject, CompilationUnit> filesToUnits = new HashMap<JavaFileObject, CompilationUnit>();
        HashMap<JavaFileObject, org.eclipse.jdt.internal.compiler.env.ICompilationUnit> filesToSrcUnits = new HashMap<JavaFileObject, org.eclipse.jdt.internal.compiler.env.ICompilationUnit>();
        final UnusedProblemFactory unusedProblemFactory = new UnusedProblemFactory((IProblemFactory)new DefaultProblemFactory(), compilerOptions);
        final JavacProblemConverter problemConverter = new JavacProblemConverter(compilerOptions, context);
        ForwardDiagnosticsAsDOMProblems diagnosticListener = new ForwardDiagnosticsAsDOMProblems(this, filesToUnits, problemConverter);
        context.put(DiagnosticListener.class, diagnosticListener);
        HashMap<JavaFileObject, File> fileObjectsToJars = new HashMap<JavaFileObject, File>();
        context.put(FILE_OBJECTS_TO_JAR_KEY, fileObjectsToJars);
        boolean docEnabled = "enabled".equals(compilerOptions.get("org.eclipse.jdt.core.compiler.doc.comment.support"));
        boolean ignoreModule = !Arrays.stream(sourceUnits).allMatch(u -> new String(u.getFileName()).endsWith("java"));
        JavacUtils.configureJavacContext(context, compilerOptions, javaProject, JavacUtils.isTest(javaProject, sourceUnits), ignoreModule);
        Options javacOptions = Options.instance(context);
        javacOptions.put("allowStringFolding", Boolean.FALSE.toString());
        if (focalPoint >= 0) {
            javacOptions.remove(Option.XDOCLINT.primaryName);
            javacOptions.remove(Option.XDOCLINT_CUSTOM.primaryName);
            javacOptions.put(Option.XLINT_CUSTOM, "raw");
        } else if ((flags & 1) == 0) {
            javacOptions.put(Option.XLINT_CUSTOM, "raw");
            javacOptions.put(Option.XDOCLINT_CUSTOM, "reference");
        }
        javacOptions.put(Option.PROC, ProcessorConfig.isAnnotationProcessingEnabled(javaProject) ? "only" : "none");
        Optional.ofNullable(Platform.getProduct()).map(IProduct::getApplication).or(() -> Optional.ofNullable(System.getProperty("eclipse.application"))).filter(name -> !name.contains("test") && !name.contains("junit")).ifPresent(string -> javacOptions.put("should-stop.ifError", CompileStates.CompileState.GENERATE.toString()));
        JavacFileManager fileManager = (JavacFileManager)context.get(JavaFileManager.class);
        if (javaProject == null && extraClasspath != null) {
            try {
                fileManager.setLocation(StandardLocation.CLASS_PATH, extraClasspath.stream().map(FileSystem.Classpath::getPath).map(File::new).toList());
            }
            catch (IOException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
        }
        ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>();
        for (org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit : sourceUnits) {
            char[] sourceUnitFileName = sourceUnit.getFileName();
            JavaFileObject fileObject = JavacCompilationUnitResolver.cuToFileObject(javaProject, sourceUnitFileName, sourceUnit, fileManager, fileObjectsToJars);
            fileManager.cache(fileObject, CharBuffer.wrap(sourceUnit.getContents()));
            ast = this.createAST(compilerOptions, apiLevel, context, flags);
            CompilationUnit res = ast.newCompilationUnit();
            result.put(sourceUnit, res);
            filesToUnits.put(fileObject, res);
            filesToSrcUnits.put(fileObject, sourceUnit);
            fileObjects.add(fileObject);
        }
        java.util.List<String> options = new ArrayList<String>(JavacCompilationUnitResolver.toCLIOptions(javacOptions));
        if (!this.configureAPTIfNecessary(fileManager)) {
            options.add("-proc:none");
        }
        options = this.replaceSafeSystemOption(options);
        JavacCompilationUnitResolver.addSourcesWithMultipleTopLevelClasses(sourceUnits, fileObjects, javaProject, fileManager);
        final JavacTask task = ((JavacTool)compiler).getTask(null, fileManager, null, options, java.util.List.of(), fileObjects, context);
        MultiTaskListener.instance(context).add(new TaskListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void finished(TaskEvent e) {
                JCTree.JCCompilationUnit u;
                CompilationUnitTree compilationUnitTree;
                JCTree.JCCompilationUnit u2;
                CompilationUnitTree compilationUnitTree2 = e.getCompilationUnit();
                if (compilationUnitTree2 instanceof JCTree.JCCompilationUnit) {
                    u2 = (JCTree.JCCompilationUnit)compilationUnitTree2;
                    problemConverter.registerUnit(e.getSourceFile(), u2);
                }
                if (e.getKind() == TaskEvent.Kind.PARSE && (compilationUnitTree2 = e.getCompilationUnit()) instanceof JCTree.JCCompilationUnit) {
                    u2 = (JCTree.JCCompilationUnit)compilationUnitTree2;
                    if ((flags & 8) != 0) {
                        u2.accept(new TreeScanner(this){
                            {
                                Objects.requireNonNull(this$1);
                            }

                            @Override
                            public void visitMethodDef(JCTree.JCMethodDecl method) {
                                if (method.body != null) {
                                    method.body.stats = List.nil();
                                }
                            }
                        });
                    }
                    if (focalPoint >= 0) {
                        JavacCompilationUnitResolver.trimNonFocusedContent(u2, focalPoint);
                    }
                }
                List<String> doclintOpts = Arguments.instance(context).getDocLintOpts();
                if (e.getKind() == TaskEvent.Kind.ANALYZE && focalPoint >= 0 && doclintOpts == null && (compilationUnitTree = e.getCompilationUnit()) instanceof JCTree.JCCompilationUnit && JavacCompilationUnitResolver.isInJavadoc(u = (JCTree.JCCompilationUnit)compilationUnitTree, focalPoint)) {
                    DocLint doclint = (DocLint)DocLint.newDocLint();
                    doclint.init(task, doclintOpts.toArray(new String[doclintOpts.size()]));
                    doclint.scan(TreePath.getPath(u, (Tree)u));
                }
                if (e.getKind() == TaskEvent.Kind.ANALYZE) {
                    JavaFileObject file = e.getSourceFile();
                    CompilationUnit dom = (CompilationUnit)filesToUnits.get(file);
                    if (dom == null) {
                        return;
                    }
                    if (Stream.of(dom.getProblems()).anyMatch(problem -> problem.isError())) {
                        return;
                    }
                    CompilerOptions objectCompilerOptions = new CompilerOptions(compilerOptions);
                    boolean unusedImportIgnored = objectCompilerOptions.getSeverityString(1024).equals("ignore");
                    boolean unusedPrivateMemberIgnored = objectCompilerOptions.getSeverityString(32768).equals("ignore");
                    if (!Options.instance(context).get(Option.XLINT_CUSTOM).contains("all") && unusedImportIgnored && unusedPrivateMemberIgnored) {
                        return;
                    }
                    4.handleAnalyzeEvent(compilerOptions, context, unusedProblemFactory, e, dom, javaProject);
                }
            }

            private static void handleAnalyzeEvent(Map<String, String> compilerOptions2, Context context2, UnusedProblemFactory unusedProblemFactory2, TaskEvent e, CompilationUnit dom, IJavaProject javaProject2) {
                Tree tree;
                final TypeElement currentTopLevelType = e.getTypeElement();
                UnusedTreeScanner<Void, Void> scanner = new UnusedTreeScanner<Void, Void>(){

                    @Override
                    public Void visitClass(ClassTree node, Void p) {
                        if (node instanceof JCTree.JCClassDecl) {
                            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node;
                            if (Objects.equals(currentTopLevelType, classDecl.sym) || !(classDecl.sym.owner instanceof Symbol.PackageSymbol)) {
                                return (Void)super.visitClass(node, p);
                            }
                            return null;
                        }
                        return (Void)super.visitClass(node, p);
                    }
                };
                CompilationUnitTree unit = e.getCompilationUnit();
                try {
                    scanner.scan(unit, null);
                }
                catch (Exception ex) {
                    ILog.get().error("Internal error when visiting the AST Tree. " + ex.getMessage(), (Throwable)ex);
                }
                java.util.List<CategorizedProblem> unusedProblems = scanner.getUnusedPrivateMembers(unusedProblemFactory2);
                if (!unusedProblems.isEmpty()) {
                    JavacCompilationUnitResolver.addProblemsToDOM(dom, unusedProblems);
                }
                java.util.List<CategorizedProblem> unusedImports = scanner.getUnusedImports(unusedProblemFactory2);
                java.util.List<? extends Tree> topTypes = unit.getTypeDecls();
                int typeCount = topTypes.size();
                if (typeCount <= 1) {
                    JavacCompilationUnitResolver.addProblemsToDOM(dom, unusedImports);
                } else if (typeCount > 1 && (tree = topTypes.get(typeCount - 1)) instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl lastType = (JCTree.JCClassDecl)tree;
                    if (Objects.equals(currentTopLevelType, lastType.sym)) {
                        JavacCompilationUnitResolver.addProblemsToDOM(dom, unusedImports);
                    }
                }
                if (Options.instance(context2).get(Option.XLINT_CUSTOM).contains("all")) {
                    AccessRestrictionTreeScanner accessScanner = null;
                    if (javaProject2 instanceof JavaProject) {
                        JavaProject internalJavaProject = (JavaProject)javaProject2;
                        try {
                            SearchableEnvironment environment = new SearchableEnvironment(internalJavaProject, (WorkingCopyOwner)null, false, -1);
                            accessScanner = new AccessRestrictionTreeScanner((INameEnvironment)environment, (IProblemFactory)new DefaultProblemFactory(), new CompilerOptions(compilerOptions2));
                            accessScanner.scan((Tree)unit, null);
                        }
                        catch (JavaModelException javaModelException) {
                            // empty catch block
                        }
                    }
                    JavacCompilationUnitResolver.addProblemsToDOM(dom, accessScanner.getAccessRestrictionProblems());
                }
            }
        });
        com.sun.tools.javac.main.JavaCompiler javac = com.sun.tools.javac.main.JavaCompiler.instance(context);
        javac.keepComments = true;
        javac.genEndPos = true;
        javac.lineDebugInfo = true;
        ArrayList<JCTree.JCCompilationUnit> javacCompilationUnits = new ArrayList<JCTree.JCCompilationUnit>();
        try {
            Iterator<? extends CompilationUnitTree> elements = task.parse().iterator();
            com.sun.tools.javac.main.JavaCompiler javac2 = com.sun.tools.javac.main.JavaCompiler.instance(context);
            javac2.keepComments = false;
            javac2.genEndPos = false;
            javac2.lineDebugInfo = false;
            Throwable cachedThrown = null;
            while (elements.hasNext() && (ast = elements.next()) instanceof JCTree.JCCompilationUnit) {
                CompilationUnit res;
                JCTree.JCCompilationUnit u2 = (JCTree.JCCompilationUnit)ast;
                javacCompilationUnits.add(u2);
                if (sourceUnits.length == 1 && focalPoint >= 0) {
                    JavacUtils.trimUnvisibleContent(u2, focalPoint, context);
                }
                if ((res = (CompilationUnit)filesToUnits.get(u2.getSourceFile())) == null) continue;
                try {
                    String rawText;
                    block27: {
                        rawText = null;
                        try {
                            rawText = u2.getSourceFile().getCharContent(true).toString();
                        }
                        catch (IOException ioe) {
                            char[] contents;
                            org.eclipse.jdt.internal.compiler.env.ICompilationUnit srcUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)filesToSrcUnits.get(u2.getSourceFile());
                            if (srcUnit != null && (contents = srcUnit.getContents()) != null && contents.length != 0) {
                                rawText = new String(contents);
                            }
                            if (rawText != null) break block27;
                            ILog.get().error(ioe.getMessage(), (Throwable)ioe);
                            continue;
                        }
                    }
                    AST ast2 = res.ast;
                    JavacConverter converter = new JavacConverter(ast2, u2, context, rawText, docEnabled, focalPoint);
                    converter.populateCompilationUnit(res, u2);
                    IProblem[] javadocProblems = (IProblem[])converter.javadocDiagnostics.stream().map(problemConverter::createJavacProblem).filter(Objects::nonNull).toArray(IProblem[]::new);
                    if (javadocProblems.length > 0) {
                        int initialSize = res.getProblems().length;
                        IProblem[] newProblems = Arrays.copyOf(res.getProblems(), initialSize + javadocProblems.length);
                        System.arraycopy(javadocProblems, 0, newProblems, initialSize, javadocProblems.length);
                        res.setProblems(newProblems);
                    }
                    this.markProblemNodesMalformed(res);
                    ArrayList<Comment> javadocComments = new ArrayList<Comment>();
                    this.depthFirstFixNodePositions(res, javadocComments);
                    Log log = Log.instance(context);
                    JavaFileObject previousSource = log.currentSourceFile();
                    try {
                        log.useSource(u2.sourcefile);
                        JavacCompilationUnitResolver.addCommentsToUnit(javadocComments, res);
                        JavacCompilationUnitResolver.addCommentsToUnit(converter.notAttachedComments, res);
                        this.attachMissingComments(res, context, rawText, converter, compilerOptions);
                    }
                    finally {
                        log.useSource(previousSource);
                    }
                    if ((flags & 2) == 0) {
                        this.removeRecoveredNodes(res);
                    }
                    if (resolveBindings) {
                        JavacBindingResolver resolver = new JavacBindingResolver(javaProject, task, context, converter, workingCopyOwner, javacCompilationUnits);
                        resolver.isRecoveringBindings = (flags & 4) != 0;
                        ast2.setBindingResolver((BindingResolver)resolver);
                    }
                    ast2.setOriginalModificationCount(ast2.modificationCount());
                    ast2.setDefaultNodeFlag(ast2.getDefaultNodeFlag() & 0xFFFFFFFD);
                }
                catch (Throwable thrown) {
                    if (cachedThrown == null) {
                        cachedThrown = thrown;
                    }
                    ILog.get().error("Internal failure while parsing or converting AST for unit " + String.valueOf(u2.sourcefile));
                    ILog.get().error(thrown.getMessage(), thrown);
                }
            }
            this.conditionallyAnalyzeTask(resolveBindings, flags, fileManager, task);
            if (!resolveBindings) {
                this.destroy(context);
            }
            if (cachedThrown != null) {
                throw new RuntimeException(cachedThrown);
            }
        }
        catch (IOException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private static void trimNonFocusedContent(final JCTree.JCCompilationUnit compilationUnit, final int focalPoint) {
        if (focalPoint < 0) {
            return;
        }
        compilationUnit.accept(new TreeScanner(){

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl method) {
                if (method.body != null && (focalPoint < method.getStartPosition() || method.getEndPosition(compilationUnit.endPositions) < focalPoint)) {
                    method.body.stats = List.nil();
                }
            }

            @Override
            public void scan(JCTree tree) {
                final Tokens.Comment comment = compilationUnit.docComments.getComment(tree);
                if (comment != null && (focalPoint < comment.getPos().getStartPosition() || comment.getPos().getEndPosition(compilationUnit.endPositions) < focalPoint)) {
                    compilationUnit.docComments.putComment(tree, new Tokens.Comment(){
                        {
                            Objects.requireNonNull(this$0);
                        }

                        @Override
                        public boolean isDeprecated() {
                            return comment.isDeprecated();
                        }

                        @Override
                        public Tokens.Comment.CommentStyle getStyle() {
                            return comment.getStyle();
                        }

                        @Override
                        public int getSourcePos(int index) {
                            return comment.getSourcePos(index);
                        }

                        public JCDiagnostic.DiagnosticPosition getPos() {
                            return comment.getPos();
                        }

                        public Tokens.Comment stripIndent() {
                            return comment.stripIndent();
                        }

                        @Override
                        public String getText() {
                            return "";
                        }
                    });
                }
                super.scan(tree);
            }
        });
    }

    private static boolean isInJavadoc(final JCTree.JCCompilationUnit u, final int focalPoint) {
        final boolean[] res = new boolean[]{false};
        u.accept(new TreeScanner(){

            @Override
            public void scan(JCTree tree) {
                if (res[0]) {
                    return;
                }
                Tokens.Comment comment = u.docComments.getComment(tree);
                if (comment != null && comment.getPos().getStartPosition() < focalPoint && focalPoint < comment.getPos().getEndPosition(u.endPositions) && (comment.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_BLOCK || comment.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE)) {
                    res[0] = true;
                    return;
                }
                super.scan(tree);
            }
        });
        return res[0];
    }

    private void markProblemNodesMalformed(CompilationUnit res) {
        for (IProblem p : res.getProblems()) {
            ASTNode found;
            ASTNode enclosing;
            int id = p.getID() & 0x1FFFFF;
            if (id != 231 || (enclosing = DOMASTNodeUtils.getEnclosingJavaElementNode(found = NodeFinder.perform((ASTNode)res, (int)p.getSourceStart(), (int)(p.getSourceEnd() - p.getSourceStart())))) == null) continue;
            enclosing.setFlags(enclosing.getFlags() | 1);
        }
    }

    private void depthFirstFixNodePositions(CompilationUnit res, final java.util.List<Comment> javadocComments) {
        res.accept(new ASTVisitor(this, true){
            {
                Objects.requireNonNull(this$0);
                super(arg0);
            }

            public void postVisit(ASTNode node) {
                if (node.getParent() != null) {
                    int myStart = node.getStartPosition();
                    int myEnd = myStart + node.getLength();
                    int parentStart = node.getParent().getStartPosition();
                    int parentEnd = parentStart + node.getParent().getLength();
                    int newParentStart = parentStart;
                    int newParentEnd = parentEnd;
                    if (parentStart != -1 && myStart >= 0 && myStart < parentStart) {
                        newParentStart = myStart;
                    }
                    if (parentEnd != -1 && myStart >= 0 && myEnd > parentEnd) {
                        newParentEnd = myEnd;
                    }
                    if (newParentStart != -1 && newParentEnd != -1 && parentStart != newParentStart || parentEnd != newParentEnd) {
                        node.getParent().setSourceRange(newParentStart, newParentEnd - newParentStart);
                    }
                }
            }

            public boolean visit(Javadoc javadoc) {
                javadocComments.add(javadoc);
                return true;
            }
        });
    }

    private void removeRecoveredNodes(CompilationUnit res) {
        res.accept(new ASTVisitor(this, false){
            {
                Objects.requireNonNull(this$0);
                super(arg0);
            }

            private boolean reject(ASTNode node) {
                VariableDeclarationStatement decl;
                FieldDeclaration field;
                return (node.getFlags() & 8) != 0 || node instanceof FieldDeclaration && (field = (FieldDeclaration)node).fragments().isEmpty() || node instanceof VariableDeclarationStatement && (decl = (VariableDeclarationStatement)node).fragments().isEmpty();
            }

            public boolean preVisit2(ASTNode node) {
                if (this.reject(node)) {
                    ChildPropertyDescriptor child;
                    SimplePropertyDescriptor simple;
                    StructuralPropertyDescriptor prop = node.getLocationInParent();
                    if (prop instanceof SimplePropertyDescriptor && !(simple = (SimplePropertyDescriptor)prop).isMandatory() || prop instanceof ChildPropertyDescriptor && !(child = (ChildPropertyDescriptor)prop).isMandatory() || prop instanceof ChildListPropertyDescriptor) {
                        node.delete();
                    } else if (node.getParent() != null) {
                        node.getParent().setFlags(node.getParent().getFlags() | 8);
                    }
                    return false;
                }
                return true;
            }

            public void postVisit(ASTNode node) {
                this.preVisit2(node);
            }
        });
    }

    private void conditionallyAnalyzeTask(boolean resolveBindings, int flags, JavacFileManager fileManager, JavacTask task) {
        boolean aptPathForceAnalyze;
        boolean forceProblemDetection = (flags & 1) != 0;
        boolean forceBindingRecovery = (flags & 4) != 0;
        Iterable<? extends File> aptPath = fileManager.getLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        boolean bl = aptPathForceAnalyze = aptPath != null && aptPath.iterator().hasNext();
        if (resolveBindings || forceProblemDetection || forceBindingRecovery || aptPathForceAnalyze) {
            Throwable caught = null;
            do {
                caught = null;
                try {
                    task.analyze();
                }
                catch (Throwable t) {
                    caught = t;
                    ILog.get().error("Error while analyzing", t);
                }
            } while (caught != null);
        }
    }

    private static JavaFileObject cuToFileObject(IJavaProject javaProject, char[] sourceUnitFileName, Object sourceUnit, JavacFileManager fileManager, Map<JavaFileObject, File> fileObjectsToJars) {
        File unitFile = null;
        boolean virtual = false;
        String sufn = new String(sourceUnitFileName);
        if (javaProject != null && javaProject.getResource() != null) {
            IResource asResource = javaProject.getProject().getParent().findMember(sufn);
            if (asResource != null) {
                unitFile = asResource.getLocation().toFile();
            } else if (sufn != null && new File(sufn).exists()) {
                unitFile = new File(sufn);
            } else {
                try {
                    URI.create("mem:///" + sufn);
                    virtual = true;
                }
                catch (IllegalArgumentException iae) {
                    unitFile = new File(new String(sourceUnitFileName));
                }
            }
        } else {
            unitFile = new File(new String(sourceUnitFileName));
        }
        if (unitFile != null) {
            return JavacCompilationUnitResolver.fileToJavaFileObject(unitFile, sourceUnitFileName, sourceUnit, fileManager, fileObjectsToJars);
        }
        if (virtual) {
            String contents = null;
            if (sourceUnit instanceof org.eclipse.jdt.internal.compiler.env.ICompilationUnit) {
                org.eclipse.jdt.internal.compiler.env.ICompilationUnit cu1 = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)sourceUnit;
                contents = new String(cu1.getContents());
            } else if (sourceUnit instanceof ICompilationUnit) {
                ICompilationUnit cu2 = (ICompilationUnit)sourceUnit;
                try {
                    contents = cu2.getSource();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            if (contents != null) {
                return new VirtualSourceFile(sufn, contents);
            }
        }
        return null;
    }

    private static JavaFileObject fileToJavaFileObject(File unitFile, char[] sourceUnitFileName, Object sourceUnit, JavacFileManager fileManager, Map<JavaFileObject, File> fileObjectsToJars) {
        java.nio.file.Path sourceUnitPath = null;
        boolean javaSourceUniqueExtension = false;
        boolean storeAsClassFromJar = false;
        if (!unitFile.getName().endsWith(".java") || sourceUnitFileName == null || sourceUnitFileName.length == 0) {
            String uri1 = unitFile.toURI().toString().replaceAll("%7C", "/");
            if (uri1.endsWith(".class")) {
                String[] split = uri1.split("/");
                String lastSegment = split[split.length - 1].replace(".class", ".java");
                sourceUnitPath = java.nio.file.Path.of(lastSegment, new String[0]);
            } else {
                boolean matches;
                IContentType javaContentType = Platform.getContentTypeManager().getContentType("org.eclipse.jdt.core.javaSource");
                String[] extensions = javaContentType.getFileSpecs(8);
                boolean bl = matches = Arrays.asList(extensions).stream().filter(x -> uri1.endsWith("." + x)).findFirst().orElse(null) != null;
                if (matches) {
                    javaSourceUniqueExtension = true;
                    sourceUnitPath = java.nio.file.Path.of(unitFile.toURI());
                }
            }
            if (sourceUnitPath == null) {
                storeAsClassFromJar = true;
                if (sourceUnit instanceof ICompilationUnit) {
                    ICompilationUnit modelUnit = (ICompilationUnit)sourceUnit;
                    sourceUnitPath = java.nio.file.Path.of(new File(System.identityHashCode(sourceUnit) + "/" + modelUnit.getElementName()).toURI());
                } else {
                    sourceUnitPath = java.nio.file.Path.of(new File(System.identityHashCode(sourceUnit) + "/whatever_InvalidNameWE_HOP3_n00ne_will_Ever_use_in_real_file.java").toURI());
                }
            }
        } else if (unitFile.getName().endsWith(".jar")) {
            sourceUnitPath = java.nio.file.Path.of(unitFile.toURI()).resolve(System.identityHashCode(sourceUnit) + "/whatever_InvalidNameWE_HOP3_n00ne_will_Ever_use_in_real_file.java");
            storeAsClassFromJar = true;
        } else {
            sourceUnitPath = java.nio.file.Path.of(unitFile.toURI());
        }
        storeAsClassFromJar |= unitFile.getName().endsWith(".jar");
        JavaFileObject fileObject = fileManager.getJavaFileObject(sourceUnitPath);
        if (javaSourceUniqueExtension) {
            fileObject = new JavaFileObjectWrapper(fileObject);
        }
        if (storeAsClassFromJar && fileObjectsToJars != null) {
            fileObjectsToJars.put(fileObject, unitFile);
        }
        return fileObject;
    }

    public static void addSourcesWithMultipleTopLevelClasses(org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] src, java.util.List<JavaFileObject> sourceFiles, IJavaProject javaProject, JavacFileManager fileManager) {
        if (javaProject == null) {
            return;
        }
        java.util.List<IJavaProject> javaProjects = Stream.of(src).map(x -> javaProject.getProject() == null ? null : javaProject.getProject().getParent().findMember(new String(x.getFileName()))).filter(x -> x != null).map(x -> x.getProject()).filter(x -> x != null).filter(JavaProject::hasJavaNature).map(JavaCore::create).toList();
        java.util.List<String> packages = Stream.of(src).map(x -> x.getPackageName()).filter(x -> x != null).map(x -> CharOperation.toString((char[][])x)).toList();
        HashSet<IJavaProject> javaProjectsUnique = new HashSet<IJavaProject>(javaProjects);
        for (IJavaProject jp1 : javaProjectsUnique) {
            boolean hasBuildState = jp1.hasBuildState();
            if (hasBuildState) continue;
            try {
                for (ICompilationUnit u : JavacCompilationUnitResolver.listCompilationUnitsWithMultipleTopLevelClasses(jp1, packages)) {
                    IDependent ud;
                    JavaFileObject jfo;
                    if (!(u instanceof IDependent) || (jfo = JavacCompilationUnitResolver.cuToFileObject(javaProject, (ud = (IDependent)u).getFileName(), u, fileManager, null)) == null) continue;
                    sourceFiles.add(jfo);
                }
            }
            catch (JavaModelException jme) {
                jme.printStackTrace();
            }
        }
    }

    private static synchronized void listCompilationUnitsWithMultipleTopLevelClasses_addLock(IProject p) {
        listCompilationUnitsWithMultipleTopLevelClasses_locks.add(p);
    }

    private static synchronized void listCompilationUnitsWithMultipleTopLevelClasses_removeLock(IProject p) {
        listCompilationUnitsWithMultipleTopLevelClasses_locks.remove(p);
    }

    private static synchronized boolean listCompilationUnitsWithMultipleTopLevelClasses_isLocked(IProject p) {
        return listCompilationUnitsWithMultipleTopLevelClasses_locks.contains(p);
    }

    private static Set<ICompilationUnit> listCompilationUnitsWithMultipleTopLevelClasses(IJavaProject javaProject, java.util.List<String> packages) throws JavaModelException {
        if (JavacCompilationUnitResolver.listCompilationUnitsWithMultipleTopLevelClasses_isLocked(javaProject.getProject())) {
            return Set.of();
        }
        JavacCompilationUnitResolver.listCompilationUnitsWithMultipleTopLevelClasses_addLock(javaProject.getProject());
        try {
            Set<ICompilationUnit> set = JavacCompilationUnitResolver.listCompilationUnitsWithMultipleTopLevelClasses_impl(javaProject, packages);
            return set;
        }
        finally {
            JavacCompilationUnitResolver.listCompilationUnitsWithMultipleTopLevelClasses_removeLock(javaProject.getProject());
        }
    }

    private static Set<ICompilationUnit> listCompilationUnitsWithMultipleTopLevelClasses_impl(final IJavaProject javaProject, java.util.List<String> packages) throws JavaModelException {
        final HashSet<ICompilationUnit> res = new HashSet<ICompilationUnit>();
        SecondaryTypeDeclarationPattern pattern = new SecondaryTypeDeclarationPattern();
        LinkedHashSet<IPackageFragment> packs = new LinkedHashSet<IPackageFragment>();
        for (IClasspathEntry entry : javaProject.getResolvedClasspath(false)) {
            if (entry.getEntryKind() != 3) continue;
            for (IPackageFragmentRoot iPackageFragmentRoot : javaProject.findPackageFragmentRoots(entry)) {
                for (String packName : packages) {
                    IPackageFragment pack = iPackageFragmentRoot.getPackageFragment(packName);
                    if (pack == null || !pack.exists()) continue;
                    packs.add(pack);
                }
            }
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])packs.toArray(IJavaElement[]::new)));
        IndexQueryRequestor requestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                try {
                    ICompilationUnit u;
                    Path docPath = new Path(documentPath);
                    IPackageFragment pack = javaProject.findPackageFragment(docPath.removeLastSegments(1));
                    if (pack != null && pack.exists() && (u = pack.getCompilationUnit(docPath.lastSegment())) != null && u.exists()) {
                        res.add(u);
                    }
                }
                catch (JavaModelException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
                return true;
            }
        };
        SearchParticipant defaultSearchParticipant = SearchEngine.getDefaultSearchParticipant();
        IndexLocation[] indexLocations = new IndexLocation[]{};
        if (defaultSearchParticipant instanceof JavaSearchParticipant) {
            JavaSearchParticipant javaSearchParticipant = (JavaSearchParticipant)defaultSearchParticipant;
            indexLocations = javaSearchParticipant.selectIndexURLs((SearchPattern)pattern, scope);
        }
        for (IPackageFragmentRoot iPackageFragmentRoot : indexLocations) {
            Index index = JavaModelManager.getIndexManager().getIndex((IndexLocation)iPackageFragmentRoot);
            if (index == null) continue;
            try {
                MatchLocator.findIndexMatches((SearchPattern)pattern, (Index)index, (IndexQueryRequestor)requestor, (SearchParticipant)defaultSearchParticipant, (IJavaSearchScope)scope, null);
            }
            catch (IOException e) {
                ILog.get().error(e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    private java.util.List<String> replaceSafeSystemOption(java.util.List<String> options) {
        int ind = -1;
        String[] arr = options.toArray(new String[options.size()]);
        for (int i = 0; i < options.size(); ++i) {
            if (options.get(i).equals("--system")) {
                ind = i + 1;
            }
            arr[i] = options.get(i);
        }
        if (ind == -1) {
            return options;
        }
        String existingVal = arr[ind];
        if (Paths.get(existingVal, new String[0]).toFile().isDirectory()) {
            return options;
        }
        if (ind < arr.length) {
            arr[ind] = "none";
        }
        return Arrays.asList(arr);
    }

    public static void cleanup(Context context) {
        com.sun.tools.javac.main.JavaCompiler javac;
        MultiTaskListener.instance(context).clear();
        DiagnosticListener diagnosticListener = context.get(DiagnosticListener.class);
        if (diagnosticListener instanceof ForwardDiagnosticsAsDOMProblems) {
            ForwardDiagnosticsAsDOMProblems listener = (ForwardDiagnosticsAsDOMProblems)diagnosticListener;
            listener.filesToUnits.clear();
        }
        if ((javac = com.sun.tools.javac.main.JavaCompiler.instance(context)) != null) {
            javac.close();
        }
    }

    public void destroy(Context context) {
        JavacCompilationUnitResolver.cleanup(context);
        try {
            context.get(JavaFileManager.class).close();
        }
        catch (IOException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
    }

    private static void addProblemsToDOM(CompilationUnit dom, Collection<CategorizedProblem> problems) {
        if (problems == null) {
            return;
        }
        IProblem[] previous = dom.getProblems();
        IProblem[] newProblems = Arrays.copyOf(previous, previous.length + problems.size());
        int start = previous.length;
        for (CategorizedProblem problem : problems) {
            newProblems[start] = problem;
            ++start;
        }
        dom.setProblems(newProblems);
    }

    private AST createAST(Map<String, String> options, int level, Context context, int flags) {
        AST ast = AST.newAST((int)level, (boolean)"enabled".equals(options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures")));
        ast.setFlag(flags);
        ast.setDefaultNodeFlag(2);
        String sourceModeSetting = options.get("org.eclipse.jdt.core.compiler.source");
        long sourceLevel = CompilerOptions.versionToJdkLevel((String)sourceModeSetting);
        if (sourceLevel == 0L) {
            sourceLevel = ClassFileConstants.getLatestJDKLevel();
        }
        ast.scanner.sourceLevel = sourceLevel;
        String compliance = options.get("org.eclipse.jdt.core.compiler.compliance");
        long complianceLevel = CompilerOptions.versionToJdkLevel((String)compliance);
        if (complianceLevel == 0L) {
            complianceLevel = sourceLevel;
        }
        ast.scanner.complianceLevel = complianceLevel;
        ast.scanner.previewEnabled = "enabled".equals(options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures"));
        return ast;
    }

    private void attachMissingComments(final CompilationUnit unit, Context context, String rawText, final JavacConverter converter, Map<String, String> compilerOptions) {
        ScannerFactory scannerFactory = ScannerFactory.instance(context);
        final ArrayList<Comment> missingComments = new ArrayList<Comment>();
        JavadocTokenizer commentTokenizer = new JavadocTokenizer(this, scannerFactory, rawText.toCharArray(), rawText.length()){
            {
                Objects.requireNonNull(this$0);
                super(arg0, arg1, arg2);
            }

            @Override
            protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
                if (style == Tokens.Comment.CommentStyle.JAVADOC_BLOCK && endPos - pos <= 4) {
                    style = Tokens.Comment.CommentStyle.BLOCK;
                }
                Tokens.Comment res = super.processComment(pos, endPos, style);
                if (JavacCompilationUnitResolver.noCommentAt(unit, pos)) {
                    Comment comment = converter.convert(res, pos, endPos);
                    missingComments.add(comment);
                }
                return res;
            }
        };
        com.sun.tools.javac.parser.Scanner javacScanner = new com.sun.tools.javac.parser.Scanner(this, scannerFactory, commentTokenizer){
            {
                Objects.requireNonNull(this$0);
                super(arg0, arg1);
            }
        };
        do {
            javacScanner.nextToken();
        } while (javacScanner.token() != null && javacScanner.token().kind != Tokens.TokenKind.EOF);
        Scanner ecjScanner = new ASTConverter(compilerOptions, (boolean)false, null).scanner;
        ecjScanner.recordLineSeparator = true;
        ecjScanner.skipComments = false;
        try {
            ecjScanner.setSource(rawText.toCharArray());
            do {
                ecjScanner.getNextToken();
            } while (!ecjScanner.atEnd());
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        JavacCompilationUnitResolver.addCommentsToUnit(missingComments, unit);
        unit.initCommentMapper(ecjScanner);
    }

    static void addCommentsToUnit(Collection<Comment> comments, CompilationUnit res) {
        ArrayList<Comment> before = res.getCommentList() == null ? new ArrayList<Comment>() : new ArrayList(res.getCommentList());
        comments.stream().filter(comment -> comment.getStartPosition() >= 0 && !JavacCompilationUnitResolver.generated(comment) && JavacCompilationUnitResolver.noCommentAt(res, comment.getStartPosition())).forEach(before::add);
        before.sort(Comparator.comparingInt(ASTNode::getStartPosition));
        res.setCommentTable((Comment[])before.toArray(Comment[]::new));
        final ArrayList<Javadoc> orphanedJavadoc = new ArrayList<Javadoc>();
        for (Comment c : comments) {
            Javadoc j;
            if (!(c instanceof Javadoc) || (j = (Javadoc)c).getParent() != null) continue;
            orphanedJavadoc.add(j);
        }
        final ArrayList initializers = new ArrayList();
        final HashMap possibleOwners = new HashMap();
        res.accept(new ASTVisitor(){

            public boolean preVisit2(ASTNode node) {
                boolean ret = false;
                for (Javadoc c : orphanedJavadoc) {
                    ret |= this.preVisitPerComment(node, c);
                }
                return ret;
            }

            public boolean preVisitPerComment(ASTNode node, Javadoc c) {
                int commentStart = c.getStartPosition();
                int commentEnd = commentStart + c.getLength();
                int start = node.getStartPosition();
                int end = start + node.getLength();
                if (end < commentStart) {
                    return false;
                }
                if (start > commentEnd) {
                    ASTNode closest = (ASTNode)possibleOwners.get(c);
                    if (closest == null) {
                        possibleOwners.put(c, node);
                    } else {
                        int thisDiff = commentEnd - start;
                        int closestStart = closest.getStartPosition();
                        int closestDiff = commentEnd - closestStart;
                        if (thisDiff < closestDiff) {
                            possibleOwners.put(c, node);
                        }
                    }
                    return false;
                }
                return true;
            }

            public boolean visit(Initializer node) {
                initializers.add(node);
                return true;
            }
        });
        for (Javadoc k : orphanedJavadoc) {
            ASTNode closest = (ASTNode)possibleOwners.get(k);
            if (!(closest instanceof Initializer)) continue;
            Initializer i = (Initializer)closest;
            try {
                i.setJavadoc(k);
                int iStart = i.getStartPosition();
                int kStart = k.getStartPosition();
                int iEnd = iStart + i.getLength();
                int kEnd = kStart + k.getLength();
                int min = Math.min(iStart, kStart);
                int end = Math.max(iEnd, kEnd);
                i.setSourceRange(min, end - min);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    private static boolean noCommentAt(CompilationUnit unit, int pos) {
        if (unit.getCommentList() == null) {
            return true;
        }
        return unit.getCommentList().stream().allMatch(other -> pos < other.getStartPosition() || pos >= other.getStartPosition() + other.getLength());
    }

    private static boolean generated(Comment comment) {
        ASTNode parentNode = comment.getParent();
        if (parentNode instanceof MethodDeclaration) {
            MethodDeclaration md = (MethodDeclaration)parentNode;
            for (Object modifier : md.modifiers()) {
                if (!(modifier instanceof MarkerAnnotation)) continue;
                MarkerAnnotation ma = (MarkerAnnotation)modifier;
                return "lombok.Generated".equals(ma.getTypeName().getFullyQualifiedName());
            }
        }
        return false;
    }

    private static Function<String, IBinding> javacAdditionalBindingCreator(Map<String, IBinding> bindingMap, INameEnvironment environment, LookupEnvironment lu, BindingResolver[] bindingResolverPointer) {
        return key -> {
            String elementKey;
            IBinding elementBinding;
            IBinding binding2 = (IBinding)bindingMap.get(key);
            if (binding2 != null) {
                return binding2;
            }
            int arrayCount = Signature.getArrayCount((String)key);
            if (arrayCount > 0 && (elementBinding = (IBinding)bindingMap.get(elementKey = Signature.getElementType((String)key))) instanceof ITypeBinding) {
                ITypeBinding elementTypeBinding = (ITypeBinding)elementBinding;
                return elementTypeBinding.createArrayType(arrayCount);
            }
            CustomBindingKeyParser bkp = new CustomBindingKeyParser((String)key);
            bkp.parse(true);
            ITypeBinding type = bindingResolverPointer[0].resolveWellKnownType(bkp.compoundName);
            if (type != null) {
                if (Objects.equals(key, type.getKey())) {
                    return type;
                }
                return Stream.of(type.getDeclaredMethods(), type.getDeclaredFields()).flatMap(Arrays::stream).filter(binding -> Objects.equals(binding.getKey(), key)).findAny().orElse(null);
            }
            return null;
        };
    }

    private boolean configureAPTIfNecessary(JavacFileManager fileManager) {
        Iterable<? extends File> modulePaths;
        Iterable<? extends File> apPaths = fileManager.getLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        if (apPaths != null) {
            return true;
        }
        Iterable<? extends File> apModulePaths = fileManager.getLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH);
        if (apModulePaths != null) {
            return true;
        }
        Iterable<? extends File> classPaths = fileManager.getLocation(StandardLocation.CLASS_PATH);
        if (classPaths != null) {
            for (File file : classPaths) {
                String string = file.getName();
                if (string == null || !string.startsWith("lombok") || !string.endsWith(".jar")) continue;
                try {
                    fileManager.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, java.util.List.of(file));
                    return true;
                }
                catch (IOException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if ((modulePaths = fileManager.getLocation(StandardLocation.MODULE_PATH)) != null) {
            for (File file : modulePaths) {
                String fileName = file.getName();
                if (fileName == null || !fileName.startsWith("lombok") || !fileName.endsWith(".jar")) continue;
                try {
                    fileManager.setLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, java.util.List.of(file));
                    return true;
                }
                catch (IOException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return false;
    }

    private static java.util.List<String> toCLIOptions(Options opts) {
        return opts.keySet().stream().map(Option::lookup).filter(Objects::nonNull).filter(opt -> opt.getKind() != Option.OptionKind.HIDDEN).map(opt -> switch (opt.getArgKind()) {
            default -> throw new MatchException(null, null);
            case Option.ArgKind.NONE -> Stream.of(opt.primaryName);
            case Option.ArgKind.REQUIRED -> {
                if (opt.primaryName.endsWith("=") || opt.primaryName.endsWith(":")) {
                    yield Stream.of(opt.primaryName + opts.get((Option)((Object)opt)));
                }
                yield Stream.of(opt.primaryName, opts.get((Option)((Object)opt)));
            }
            case Option.ArgKind.ADJACENT -> {
                String value = opts.get((Option)((Object)opt));
                if (value == null || value.isEmpty()) {
                    yield Arrays.stream(new String[0]);
                }
                yield Stream.of(opt.primaryName + opts.get((Option)((Object)opt)));
            }
        }).flatMap(Function.identity()).toList();
    }

    private /* synthetic */ void lambda$resolve$3(JavacBindingResolver[] bindingResolver, Map bindingMap, int apiLevel, ICompilationUnit mockUnit, ASTRequestor requestor, ICompilationUnit a, CompilationUnit b) {
        BindingResolver patt0$temp;
        if (bindingResolver[0] == null && (patt0$temp = b.ast.getBindingResolver()) instanceof JavacBindingResolver) {
            JavacBindingResolver javacBindingResolver;
            bindingResolver[0] = javacBindingResolver = (JavacBindingResolver)patt0$temp;
        }
        this.resolveBindings(b, bindingMap, apiLevel);
        if (!Objects.equals(a, mockUnit)) {
            requestor.acceptAST(a, b);
        }
    }

    private static interface GenericRequestor {
        public void acceptBinding(String var1, IBinding var2);
    }

    private static class BindingBuilder
    extends ASTVisitor {
        public Map<String, IBinding> bindingMap = new HashMap<String, IBinding>();

        public BindingBuilder(Map<String, IBinding> bindingMap) {
            this.bindingMap = bindingMap;
        }

        public boolean visit(TypeDeclaration node) {
            ITypeBinding binding = node.resolveBinding();
            if (binding != null) {
                this.bindingMap.putIfAbsent(binding.getKey(), (IBinding)binding);
            }
            return true;
        }

        public boolean visit(MethodDeclaration node) {
            IMethodBinding binding = node.resolveBinding();
            if (binding != null) {
                this.bindingMap.putIfAbsent(binding.getKey(), (IBinding)binding);
            }
            return true;
        }

        public boolean visit(EnumDeclaration node) {
            ITypeBinding binding = node.resolveBinding();
            if (binding != null) {
                this.bindingMap.putIfAbsent(binding.getKey(), (IBinding)binding);
            }
            return true;
        }

        public boolean visit(RecordDeclaration node) {
            ITypeBinding binding = node.resolveBinding();
            if (binding != null) {
                this.bindingMap.putIfAbsent(binding.getKey(), (IBinding)binding);
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration node) {
            IVariableBinding binding = node.resolveBinding();
            if (binding != null) {
                this.bindingMap.putIfAbsent(binding.getKey(), (IBinding)binding);
            }
            return true;
        }

        public boolean visit(VariableDeclarationFragment node) {
            IVariableBinding binding = node.resolveBinding();
            if (binding != null) {
                this.bindingMap.putIfAbsent(binding.getKey(), (IBinding)binding);
            }
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            ITypeBinding binding = node.resolveBinding();
            if (binding != null) {
                this.bindingMap.putIfAbsent(binding.getKey(), (IBinding)binding);
            }
            return true;
        }

        public boolean visit(MethodInvocation node) {
            IMethodBinding binding = node.resolveMethodBinding();
            if (binding != null) {
                this.bindingMap.putIfAbsent(binding.getKey(), (IBinding)binding);
            }
            return true;
        }
    }

    private static class CustomBindingKeyParser
    extends BindingKeyParser {
        private char[] secondarySimpleName;
        private String compoundName;

        public CustomBindingKeyParser(String key) {
            super(key);
        }

        public void consumeSecondaryType(char[] simpleTypeName) {
            this.secondarySimpleName = simpleTypeName;
        }

        public void consumeFullyQualifiedName(char[] fullyQualifiedName) {
            this.compoundName = new String(fullyQualifiedName).replace('/', '.');
        }
    }

    private final class ForwardDiagnosticsAsDOMProblems
    implements DiagnosticListener<JavaFileObject> {
        public final Map<JavaFileObject, CompilationUnit> filesToUnits;
        private final JavacProblemConverter problemConverter;

        private ForwardDiagnosticsAsDOMProblems(JavacCompilationUnitResolver javacCompilationUnitResolver, Map<JavaFileObject, CompilationUnit> filesToUnits, JavacProblemConverter problemConverter) {
            Objects.requireNonNull(javacCompilationUnitResolver);
            this.filesToUnits = filesToUnits;
            this.problemConverter = problemConverter;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            ForwardDiagnosticsAsDOMProblems.findTargetDOM(this.filesToUnits, diagnostic).ifPresent(dom -> {
                JavacProblem newProblem = this.problemConverter.createJavacProblem(diagnostic);
                if (newProblem != null) {
                    IProblem[] previous = dom.getProblems();
                    IProblem[] newProblems = Arrays.copyOf(previous, previous.length + 1);
                    newProblems[newProblems.length - 1] = newProblem;
                    dom.setProblems(newProblems);
                }
            });
        }

        private static Optional<CompilationUnit> findTargetDOM(Map<JavaFileObject, CompilationUnit> filesToUnits, Object obj) {
            if (obj == null) {
                return Optional.empty();
            }
            if (obj instanceof JavaFileObject) {
                JavaFileObject o = (JavaFileObject)obj;
                return Optional.ofNullable(filesToUnits.get(o));
            }
            if (obj instanceof DiagnosticSource) {
                DiagnosticSource source = (DiagnosticSource)obj;
                return ForwardDiagnosticsAsDOMProblems.findTargetDOM(filesToUnits, source.getFile());
            }
            if (obj instanceof Diagnostic) {
                Diagnostic diag = (Diagnostic)obj;
                return ForwardDiagnosticsAsDOMProblems.findTargetDOM(filesToUnits, diag.getSource());
            }
            return Optional.empty();
        }
    }

    public static final class VirtualSourceFile
    extends SimpleJavaFileObject {
        private final CharSequence source;

        public VirtualSourceFile(String pathLikeName, CharSequence source) {
            super(URI.create("mem:///" + pathLikeName), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }
    }

    public static class JavaFileObjectWrapper
    implements JavaFileObject {
        private JavaFileObject delegate;

        public JavaFileObjectWrapper(JavaFileObject delegate) {
            this.delegate = delegate;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return JavaFileObject.Kind.SOURCE;
        }

        @Override
        public URI toUri() {
            return this.delegate.toUri();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.delegate.openInputStream();
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.delegate.isNameCompatible(simpleName, kind);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.delegate.openOutputStream();
        }

        @Override
        public NestingKind getNestingKind() {
            return this.delegate.getNestingKind();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return this.delegate.openReader(ignoreEncodingErrors);
        }

        @Override
        public Modifier getAccessLevel() {
            return this.delegate.getAccessLevel();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.delegate.getCharContent(ignoreEncodingErrors);
        }

        @Override
        public Writer openWriter() throws IOException {
            return this.delegate.openWriter();
        }

        @Override
        public long getLastModified() {
            return this.delegate.getLastModified();
        }

        @Override
        public boolean delete() {
            return this.delegate.delete();
        }
    }
}

