/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.codemanipulation;

import java.util.Comparator;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.core.manipulation.MembersOrderPreferenceCacheCommon;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class DefaultJavaElementComparator
implements Comparator<BodyDeclaration> {
    private final MembersOrderPreferenceCacheCommon fMemberOrderCache;
    private final boolean fDoNotSortFields;

    public DefaultJavaElementComparator(boolean doNotSortFields) {
        this.fDoNotSortFields = doNotSortFields;
        this.fMemberOrderCache = new MembersOrderPreferenceCacheCommon();
        this.fMemberOrderCache.install();
    }

    private int category(BodyDeclaration bodyDeclaration) {
        switch (bodyDeclaration.getNodeType()) {
            case 31: {
                MethodDeclaration method = (MethodDeclaration)bodyDeclaration;
                if (method.isConstructor()) {
                    return 1;
                }
                int flags = method.getModifiers();
                if (Modifier.isStatic((int)flags)) {
                    return 7;
                }
                return 2;
            }
            case 23: {
                if (JdtFlags.isStatic((BodyDeclaration)bodyDeclaration)) {
                    return 5;
                }
                return 3;
            }
            case 28: {
                int flags = ((Initializer)bodyDeclaration).getModifiers();
                if (Modifier.isStatic((int)flags)) {
                    return 6;
                }
                return 4;
            }
            case 55: 
            case 71: 
            case 81: {
                return 0;
            }
            case 72: {
                return 8;
            }
            case 82: {
                return 2;
            }
        }
        return 0;
    }

    private int getCategoryIndex(int category) {
        return this.fMemberOrderCache.getCategoryIndex(category);
    }

    @Override
    public int compare(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2) {
        boolean preserved1 = this.fDoNotSortFields && this.isSortPreserved(bodyDeclaration1);
        boolean preserved2 = this.fDoNotSortFields && this.isSortPreserved(bodyDeclaration2);
        int cat1 = this.category(bodyDeclaration1);
        if (preserved1) {
            cat1 = DefaultJavaElementComparator.sortPreservedCategory(cat1);
        }
        int cat2 = this.category(bodyDeclaration2);
        if (preserved2) {
            cat2 = DefaultJavaElementComparator.sortPreservedCategory(cat2);
        }
        if (cat1 != cat2) {
            return this.getCategoryIndex(cat1) - this.getCategoryIndex(cat2);
        }
        if (preserved1) {
            return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
        }
        int flags1 = JdtFlags.getVisibilityCode((BodyDeclaration)bodyDeclaration1);
        int flags2 = JdtFlags.getVisibilityCode((BodyDeclaration)bodyDeclaration2);
        int vis = this.fMemberOrderCache.getVisibilityIndex(flags1) - this.fMemberOrderCache.getVisibilityIndex(flags2);
        return vis;
    }

    private static int sortPreservedCategory(int category) {
        switch (category) {
            case 5: 
            case 6: {
                return 5;
            }
            case 3: 
            case 4: {
                return 3;
            }
        }
        return category;
    }

    private boolean isSortPreserved(BodyDeclaration bodyDeclaration) {
        switch (bodyDeclaration.getNodeType()) {
            case 23: 
            case 28: 
            case 72: {
                return true;
            }
        }
        return false;
    }

    private int preserveRelativeOrder(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2) {
        int value1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
        int value2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
        return value1 - value2;
    }
}

