/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public final class MapFlattener {
    private MapFlattener() {
    }

    public static String getString(Map<String, Object> configuration, String key) {
        return MapFlattener.getString(configuration, key, null);
    }

    public static String getString(Map<String, Object> configuration, String key, String def) {
        String val;
        Object object = MapFlattener.getValue(configuration, key);
        return object instanceof String ? (val = (String)object) : def;
    }

    public static List<String> getList(Map<String, Object> configuration, String key) {
        return MapFlattener.getList(configuration, key, null);
    }

    public static List<String> getList(Map<String, Object> configuration, String key, List<String> def) {
        Object val = MapFlattener.getValue(configuration, key);
        if (val instanceof String) {
            Object str = (String)val;
            if (!((String)str).trim().startsWith("[")) {
                if (((String)str).contains(",")) {
                    str = "[" + (String)val + "]";
                } else {
                    String[] elements = ((String)str).split(" ");
                    return Arrays.stream(elements).filter(e -> e != null && !e.isEmpty()).collect(Collectors.toList());
                }
            }
            try {
                Gson gson = new Gson();
                Type type = new TypeToken<List<String>>(){}.getType();
                List list = (List)gson.fromJson((String)str, type);
                return list;
            }
            catch (JsonSyntaxException e2) {
                JavaLanguageServerPlugin.logException(e2.getMessage(), e2);
                return def;
            }
        }
        if (val instanceof List) {
            try {
                List ret = (List)val;
                return ret;
            }
            catch (Exception e3) {
                JavaLanguageServerPlugin.logException(e3.getMessage(), e3);
            }
        }
        return def;
    }

    public static boolean getBoolean(Map<String, Object> configuration, String key) {
        return MapFlattener.getBoolean(configuration, key, false);
    }

    public static boolean getBoolean(Map<String, Object> configuration, String key, boolean def) {
        Object val = MapFlattener.getValue(configuration, key);
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return b;
        }
        if (val instanceof String) {
            String s = (String)val;
            return Boolean.parseBoolean(s);
        }
        return def;
    }

    public static int getInt(Map<String, Object> configuration, String key) {
        return MapFlattener.getInt(configuration, key, 0);
    }

    public static int getInt(Map<String, Object> configuration, String key, int def) {
        Object val = MapFlattener.getValue(configuration, key);
        if (val instanceof Number) {
            Number n = (Number)val;
            return n.intValue();
        }
        if (val instanceof String) {
            String s = (String)val;
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                JavaLanguageServerPlugin.logError(key + " value (" + String.valueOf(val) + ") is not an int, falling back on " + def);
            }
        }
        return def;
    }

    public static Object getValue(Map<String, Object> configuration, String key) {
        Object value = configuration.get(key);
        if (value != null) {
            return value;
        }
        String[] keyParts = key.split("\\.");
        String currKey = null;
        Map currMap = configuration;
        int i = 0;
        while (i < keyParts.length) {
            currKey = keyParts[i];
            Object val = currMap.get(currKey);
            if (i == keyParts.length - 1) {
                return val;
            }
            if (!(val instanceof Map)) {
                return null;
            }
            currMap = (Map)val;
            ++i;
        }
        return null;
    }

    public static boolean containsKey(Map<String, Object> configuration, String key) {
        if (configuration.containsKey(key)) {
            return true;
        }
        String[] keyParts = key.split("\\.");
        String currKey = null;
        Map currMap = configuration;
        int i = 0;
        while (i < keyParts.length) {
            currKey = keyParts[i];
            if (i == keyParts.length - 1) {
                return currMap.containsKey(currKey);
            }
            Object val = currMap.get(currKey);
            if (!(val instanceof Map)) {
                return false;
            }
            currMap = (Map)val;
            ++i;
        }
        return false;
    }

    public static void setValue(Map<String, Object> configuration, String chainedKey, Object value) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        if (chainedKey == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (!chainedKey.contains(".")) {
            configuration.put(chainedKey, value);
            return;
        }
        String[] keyParts = chainedKey.split("\\.");
        HashMap<String, Object> currMap = configuration;
        int i = 0;
        while (i < keyParts.length) {
            String currKey = keyParts[i];
            if (i == keyParts.length - 1) {
                currMap.put(currKey, value);
            } else {
                Object val = currMap.get(currKey);
                if (val instanceof Map) {
                    currMap = (HashMap<String, Object>)val;
                } else {
                    HashMap<String, Object> newMap = new HashMap<String, Object>();
                    currMap.put(currKey, newMap);
                    currMap = newMap;
                }
            }
            ++i;
        }
    }
}

