/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.BufferCaster;

public class StreamByteBuffer {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x100000;
    private LinkedList<StreamByteBufferChunk> chunks = new LinkedList();
    private StreamByteBufferChunk currentWriteChunk;
    private StreamByteBufferChunk currentReadChunk;
    private int chunkSize;
    private int nextChunkSize;
    private int maxChunkSize;
    private StreamByteBufferOutputStream output;
    private StreamByteBufferInputStream input;
    private int totalBytesUnreadInList;

    public StreamByteBuffer() {
        this(4096);
    }

    public StreamByteBuffer(int chunkSize) {
        this.chunkSize = chunkSize;
        this.nextChunkSize = chunkSize;
        this.maxChunkSize = Math.max(chunkSize, 0x100000);
        this.currentWriteChunk = new StreamByteBufferChunk(this.nextChunkSize);
        this.output = new StreamByteBufferOutputStream();
        this.input = new StreamByteBufferInputStream();
    }

    public static StreamByteBuffer of(InputStream inputStream) throws IOException {
        StreamByteBuffer buffer = new StreamByteBuffer(StreamByteBuffer.chunkSizeInDefaultRange(inputStream.available()));
        buffer.readFully(inputStream);
        return buffer;
    }

    public static StreamByteBuffer of(InputStream inputStream, int len) throws IOException {
        StreamByteBuffer buffer = new StreamByteBuffer(StreamByteBuffer.chunkSizeInDefaultRange(len));
        buffer.readFrom(inputStream, len);
        return buffer;
    }

    public static StreamByteBuffer createWithChunkSizeInDefaultRange(int value) {
        return new StreamByteBuffer(StreamByteBuffer.chunkSizeInDefaultRange(value));
    }

    static int chunkSizeInDefaultRange(int value) {
        return StreamByteBuffer.valueInRange(value, 4096, 0x100000);
    }

    private static int valueInRange(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public void writeTo(OutputStream target) throws IOException {
        while (this.prepareRead() != -1) {
            this.currentReadChunk.writeTo(target);
        }
    }

    public void readFrom(InputStream inputStream, int len) throws IOException {
        int readBytes;
        for (int bytesLeft = len; bytesLeft > 0; bytesLeft -= readBytes) {
            int spaceLeft = this.allocateSpace();
            int limit = Math.min(spaceLeft, bytesLeft);
            readBytes = this.currentWriteChunk.readFrom(inputStream, limit);
            if (readBytes != -1) continue;
            throw new EOFException("Unexpected EOF");
        }
    }

    public void readFully(InputStream inputStream) throws IOException {
        int len;
        int readBytes;
        while ((readBytes = this.currentWriteChunk.readFrom(inputStream, len = this.allocateSpace())) != -1) {
        }
    }

    public byte[] readAsByteArray() {
        byte[] buf = new byte[this.totalBytesUnread()];
        this.input.readImpl(buf, 0, buf.length);
        return buf;
    }

    public List<byte[]> readAsListOfByteArrays() {
        byte[] buf;
        ArrayList<byte[]> listOfByteArrays = new ArrayList<byte[]>(this.chunks.size() + 1);
        while ((buf = this.input.readNextBuffer()) != null) {
            if (buf.length <= 0) continue;
            listOfByteArrays.add(buf);
        }
        return listOfByteArrays;
    }

    public String readAsString(String encoding) {
        Charset charset = Charset.forName(encoding);
        return this.readAsString(charset);
    }

    public String readAsString() {
        return this.readAsString(Charset.defaultCharset());
    }

    public String readAsString(Charset charset) {
        try {
            return this.doReadAsString(charset);
        }
        catch (CharacterCodingException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private String doReadAsString(Charset charset) throws CharacterCodingException {
        int unreadSize = this.totalBytesUnread();
        if (unreadSize > 0) {
            return this.readAsCharBuffer(charset).toString();
        }
        return "";
    }

    private CharBuffer readAsCharBuffer(Charset charset) throws CharacterCodingException {
        CoderResult result;
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer charbuffer = CharBuffer.allocate(this.totalBytesUnread());
        Buffer buf = null;
        boolean wasUnderflow = false;
        Buffer nextBuf = null;
        boolean needsFlush = false;
        while (this.hasRemaining((ByteBuffer)nextBuf) || this.hasRemaining((ByteBuffer)buf) || this.prepareRead() != -1) {
            if (this.hasRemaining((ByteBuffer)buf)) {
                if (!wasUnderflow) {
                    throw new IllegalStateException("Unexpected state. Buffer has remaining bytes without underflow in decoding.");
                }
                if (!this.hasRemaining((ByteBuffer)nextBuf) && this.prepareRead() != -1) {
                    nextBuf = this.currentReadChunk.readToNioBuffer();
                }
                buf = ByteBuffer.allocate(buf.remaining() + 1).put((ByteBuffer)buf);
                ((ByteBuffer)buf).put(((ByteBuffer)nextBuf).get());
                BufferCaster.cast(buf).flip();
            } else {
                if (this.hasRemaining((ByteBuffer)nextBuf)) {
                    buf = nextBuf;
                } else if (this.prepareRead() != -1 && !this.hasRemaining((ByteBuffer)(buf = this.currentReadChunk.readToNioBuffer()))) {
                    throw new IllegalStateException("Unexpected state. Buffer is empty.");
                }
                nextBuf = null;
            }
            boolean endOfInput = !this.hasRemaining((ByteBuffer)nextBuf) && this.prepareRead() == -1;
            int bufRemainingBefore = buf.remaining();
            CoderResult result2 = decoder.decode((ByteBuffer)buf, charbuffer, false);
            if (bufRemainingBefore > buf.remaining()) {
                needsFlush = true;
            }
            if (endOfInput) {
                result2 = decoder.decode(ByteBuffer.allocate(0), charbuffer, true);
                if (result2.isUnderflow()) break;
                result2.throwException();
                break;
            }
            wasUnderflow = result2.isUnderflow();
        }
        if (needsFlush && !(result = decoder.flush(charbuffer)).isUnderflow()) {
            result.throwException();
        }
        this.clear();
        while (this.hasRemaining((ByteBuffer)buf)) {
            byte b = ((ByteBuffer)buf).get();
            try {
                this.getOutputStream().write(b);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        BufferCaster.cast(charbuffer).flip();
        return charbuffer;
    }

    private boolean hasRemaining(ByteBuffer nextBuf) {
        return nextBuf != null && nextBuf.hasRemaining();
    }

    public int totalBytesUnread() {
        int total = this.totalBytesUnreadInList;
        if (this.currentReadChunk != null) {
            total += this.currentReadChunk.bytesUnread();
        }
        if (this.currentWriteChunk != this.currentReadChunk && this.currentWriteChunk != null) {
            total += this.currentWriteChunk.bytesUnread();
        }
        return total;
    }

    protected int allocateSpace() {
        int spaceLeft = this.currentWriteChunk.spaceLeft();
        if (spaceLeft == 0) {
            this.addChunk(this.currentWriteChunk);
            this.currentWriteChunk = new StreamByteBufferChunk(this.nextChunkSize);
            if (this.nextChunkSize < this.maxChunkSize) {
                this.nextChunkSize = Math.min(this.nextChunkSize * 2, this.maxChunkSize);
            }
            spaceLeft = this.currentWriteChunk.spaceLeft();
        }
        return spaceLeft;
    }

    protected int prepareRead() {
        int bytesUnread;
        int n = bytesUnread = this.currentReadChunk != null ? this.currentReadChunk.bytesUnread() : 0;
        if (bytesUnread == 0) {
            if (!this.chunks.isEmpty()) {
                this.currentReadChunk = this.chunks.removeFirst();
                bytesUnread = this.currentReadChunk.bytesUnread();
                this.totalBytesUnreadInList -= bytesUnread;
            } else if (this.currentReadChunk != this.currentWriteChunk) {
                this.currentReadChunk = this.currentWriteChunk;
                bytesUnread = this.currentReadChunk.bytesUnread();
            } else {
                bytesUnread = -1;
            }
        }
        return bytesUnread;
    }

    public static StreamByteBuffer of(List<byte[]> listOfByteArrays) {
        StreamByteBuffer buffer = new StreamByteBuffer();
        buffer.addChunks(listOfByteArrays);
        return buffer;
    }

    private void addChunks(List<byte[]> listOfByteArrays) {
        for (byte[] buf : listOfByteArrays) {
            this.addChunk(new StreamByteBufferChunk(buf));
        }
    }

    private void addChunk(StreamByteBufferChunk chunk) {
        this.chunks.add(chunk);
        this.totalBytesUnreadInList += chunk.bytesUnread();
    }

    public void clear() {
        this.chunks.clear();
        this.currentReadChunk = null;
        this.totalBytesUnreadInList = 0;
        this.currentWriteChunk.clear();
    }

    class StreamByteBufferInputStream
    extends InputStream {
        StreamByteBufferInputStream() {
        }

        @Override
        public int read() throws IOException {
            StreamByteBuffer.this.prepareRead();
            return StreamByteBuffer.this.currentReadChunk.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.readImpl(b, off, len);
        }

        int readImpl(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int bytesLeft = len;
            int currentOffset = off;
            int bytesUnread = StreamByteBuffer.this.prepareRead();
            int totalBytesRead = 0;
            while (bytesLeft > 0 && bytesUnread != -1) {
                int readBytes = Math.min(bytesUnread, bytesLeft);
                StreamByteBuffer.this.currentReadChunk.read(b, currentOffset, readBytes);
                bytesLeft -= readBytes;
                currentOffset += readBytes;
                totalBytesRead += readBytes;
                bytesUnread = StreamByteBuffer.this.prepareRead();
            }
            if (totalBytesRead > 0) {
                return totalBytesRead;
            }
            return -1;
        }

        @Override
        public int available() throws IOException {
            return StreamByteBuffer.this.totalBytesUnread();
        }

        public StreamByteBuffer getBuffer() {
            return StreamByteBuffer.this;
        }

        public byte[] readNextBuffer() {
            if (StreamByteBuffer.this.prepareRead() != -1) {
                return StreamByteBuffer.this.currentReadChunk.readBuffer();
            }
            return null;
        }
    }

    class StreamByteBufferOutputStream
    extends OutputStream {
        private boolean closed;

        StreamByteBufferOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int bytesLeft = len;
            int currentOffset = off;
            while (bytesLeft > 0) {
                int spaceLeft = StreamByteBuffer.this.allocateSpace();
                int writeBytes = Math.min(spaceLeft, bytesLeft);
                StreamByteBuffer.this.currentWriteChunk.write(b, currentOffset, writeBytes);
                bytesLeft -= writeBytes;
                currentOffset += writeBytes;
            }
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void write(int b) throws IOException {
            StreamByteBuffer.this.allocateSpace();
            StreamByteBuffer.this.currentWriteChunk.write((byte)b);
        }

        public StreamByteBuffer getBuffer() {
            return StreamByteBuffer.this;
        }
    }

    static class StreamByteBufferChunk {
        private int pointer;
        private byte[] buffer;
        private int size;
        private int used;

        public StreamByteBufferChunk(int size) {
            this.size = size;
            this.buffer = new byte[size];
        }

        public StreamByteBufferChunk(byte[] buf) {
            this.size = buf.length;
            this.buffer = buf;
            this.used = buf.length;
        }

        public ByteBuffer readToNioBuffer() {
            if (this.pointer < this.used) {
                ByteBuffer result = this.pointer > 0 || this.used < this.size ? ByteBuffer.wrap(this.buffer, this.pointer, this.used - this.pointer) : ByteBuffer.wrap(this.buffer);
                this.pointer = this.used;
                return result;
            }
            return null;
        }

        public boolean write(byte b) {
            if (this.used < this.size) {
                this.buffer[this.used++] = b;
                return true;
            }
            return false;
        }

        public void write(byte[] b, int off, int len) {
            System.arraycopy(b, off, this.buffer, this.used, len);
            this.used += len;
        }

        public void read(byte[] b, int off, int len) {
            System.arraycopy(this.buffer, this.pointer, b, off, len);
            this.pointer += len;
        }

        public void writeTo(OutputStream target) throws IOException {
            if (this.pointer < this.used) {
                target.write(this.buffer, this.pointer, this.used - this.pointer);
                this.pointer = this.used;
            }
        }

        public void reset() {
            this.pointer = 0;
        }

        public int bytesUsed() {
            return this.used;
        }

        public int bytesUnread() {
            return this.used - this.pointer;
        }

        public int read() {
            if (this.pointer < this.used) {
                return this.buffer[this.pointer++] & 0xFF;
            }
            return -1;
        }

        public int spaceLeft() {
            return this.size - this.used;
        }

        public int readFrom(InputStream inputStream, int len) throws IOException {
            int readBytes = inputStream.read(this.buffer, this.used, len);
            if (readBytes > 0) {
                this.used += readBytes;
            }
            return readBytes;
        }

        public void clear() {
            this.pointer = 0;
            this.used = 0;
        }

        public byte[] readBuffer() {
            if (this.used == this.buffer.length && this.pointer == 0) {
                this.pointer = this.used;
                return this.buffer;
            }
            if (this.pointer < this.used) {
                byte[] buf = new byte[this.used - this.pointer];
                this.read(buf, 0, this.used - this.pointer);
                return buf;
            }
            return new byte[0];
        }
    }
}

