/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.jdt.internal.core.ResolvedSourceMethod;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeVariableBinding;

public abstract class JavacMethodBinding
implements IMethodBinding {
    private static final ITypeBinding[] NO_TYPE_ARGUMENTS = new ITypeBinding[0];
    private static final ITypeBinding[] NO_TYPE_PARAMS = new ITypeBinding[0];
    public final Symbol.MethodSymbol methodSymbol;
    final Type.MethodType methodType;
    final Type parentType;
    final JavacBindingResolver resolver;
    final boolean explicitSynthetic;
    private final boolean isDeclaration;
    private IMethod javaElement;
    private String key;

    public JavacMethodBinding(Type.MethodType methodType, Symbol.MethodSymbol methodSymbol, Type parentType, JavacBindingResolver resolver) {
        this(methodType, methodSymbol, parentType, resolver, false, false);
    }

    /*
     * Unable to fully structure code
     */
    public JavacMethodBinding(Type.MethodType methodType, Symbol.MethodSymbol methodSymbol, Type parentType, JavacBindingResolver resolver, boolean explicitSynthetic, boolean isDeclaration) {
        super();
        this.methodType = methodType;
        this.methodSymbol = methodSymbol;
        if (parentType != null || methodSymbol == null || !((var8_7 = methodSymbol.owner) instanceof Symbol.ClassSymbol)) ** GOTO lbl-1000
        classSymbol = (Symbol.ClassSymbol)var8_7;
        if (JavacBindingResolver.isTypeOfType(classSymbol.type)) {
            v0 = classSymbol.type;
        } else lbl-1000:
        // 2 sources

        {
            v0 = parentType;
        }
        this.parentType = v0;
        this.isDeclaration = JavacMethodBinding.isParameterized(methodSymbol) != false && isDeclaration != false;
        this.explicitSynthetic = explicitSynthetic;
        this.resolver = resolver;
    }

    private static boolean isParameterized(Symbol symbol) {
        while (symbol != null) {
            if (symbol.type != null && (symbol.type.isParameterized() || symbol.type instanceof Type.ForAll)) {
                return true;
            }
            symbol = symbol.owner;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacMethodBinding)) return false;
        JavacMethodBinding other = (JavacMethodBinding)obj;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        if (!Objects.equals(this.methodSymbol, other.methodSymbol)) return false;
        if (!JavacMethodBinding.equals(this.methodType, other.methodType)) return false;
        if (!Objects.equals(this.explicitSynthetic, other.explicitSynthetic)) return false;
        if (!Objects.equals(this.parentType, other.parentType)) return false;
        if (!Objects.equals(this.isDeclaration, other.isDeclaration)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolver, this.methodSymbol, this.parentType, this.explicitSynthetic, this.isDeclaration}) ^ JavacMethodBinding.hashCode(this.methodType);
    }

    private static boolean equals(Type.MethodType second, Type.MethodType first) {
        return second == first || Objects.equals(first.argtypes, second.argtypes) && Objects.equals(first.restype, second.restype) && Objects.equals(first.thrown, second.thrown) && Objects.equals(first.recvtype, second.recvtype) && Objects.equals(first.tsym, second.tsym);
    }

    private static int hashCode(Type.MethodType methodType) {
        return Objects.hash(methodType.tsym, methodType.argtypes, methodType.restype, methodType.thrown, methodType.recvtype);
    }

    public IAnnotationBinding[] getAnnotations() {
        return (IAnnotationBinding[])this.methodSymbol.getAnnotationMirrors().stream().map(ann -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)ann, (IBinding)this)).toArray(IAnnotationBinding[]::new);
    }

    public int getKind() {
        return 4;
    }

    public int getModifiers() {
        ITypeBinding outerClass = this.getDeclaringClass();
        int extraModifiers = outerClass != null && outerClass.isInterface() && this.methodSymbol != null && !this.methodSymbol.isDefault() && !this.methodSymbol.isStatic() ? 1024 : 0;
        return this.methodSymbol != null ? JavacMethodBinding.toInt(this.methodSymbol.getModifiers()) | extraModifiers : extraModifiers;
    }

    static int toInt(Set<javax.lang.model.element.Modifier> javac) {
        if (javac == null) {
            return 0;
        }
        int[] res = new int[]{0};
        javac.forEach(mod -> {
            res[0] = res[0] | JavacMethodBinding.toInt(mod);
        });
        return res[0];
    }

    private static int toInt(javax.lang.model.element.Modifier javac) {
        return switch (javac) {
            default -> throw new MatchException(null, null);
            case javax.lang.model.element.Modifier.PUBLIC -> 1;
            case javax.lang.model.element.Modifier.PROTECTED -> 4;
            case javax.lang.model.element.Modifier.PRIVATE -> 2;
            case javax.lang.model.element.Modifier.ABSTRACT -> 1024;
            case javax.lang.model.element.Modifier.DEFAULT -> 65536;
            case javax.lang.model.element.Modifier.STATIC -> 8;
            case javax.lang.model.element.Modifier.SEALED -> 512;
            case javax.lang.model.element.Modifier.NON_SEALED -> 4096;
            case javax.lang.model.element.Modifier.FINAL -> 16;
            case javax.lang.model.element.Modifier.TRANSIENT -> 128;
            case javax.lang.model.element.Modifier.VOLATILE -> 64;
            case javax.lang.model.element.Modifier.SYNCHRONIZED -> 32;
            case javax.lang.model.element.Modifier.NATIVE -> 256;
            case javax.lang.model.element.Modifier.STRICTFP -> 2048;
        };
    }

    public boolean isDeprecated() {
        return this.methodSymbol.isDeprecated();
    }

    public boolean isRecovered() {
        return this.methodSymbol.kind == Kinds.Kind.ERR;
    }

    public boolean isSynthetic() {
        return (this.methodSymbol.flags() & 0x1000L) != 0L;
    }

    public IMethod getJavaElement() {
        this.javaElement = this.resolved(this.getUnresolvedJavaElement());
        return this.javaElement;
    }

    IMethod getUnresolvedJavaElement() {
        if (this.javaElement == null) {
            this.javaElement = this.computeUnresolvedJavaElement();
        }
        return this.javaElement;
    }

    private IMethod computeUnresolvedJavaElement() {
        IJavaElement iJavaElement;
        ITypeBinding typeBinding;
        if (this.methodSymbol == null) {
            return null;
        }
        IBinding iBinding = this.resolver.bindings.getBinding(this.methodSymbol.owner, this.methodType);
        if (iBinding instanceof ITypeBinding && (typeBinding = (ITypeBinding)iBinding) != null && (iJavaElement = typeBinding.getJavaElement()) instanceof IType) {
            IType currentType = (IType)iJavaElement;
            ASTNode declaringNode = this.resolver.findDeclaringNode((IBinding)this);
            if (declaringNode instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)declaringNode;
                return this.getJavaElementForMethodDeclaration(currentType, methodDeclaration);
            }
            if (declaringNode instanceof AnnotationTypeMemberDeclaration) {
                AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration = (AnnotationTypeMemberDeclaration)declaringNode;
                return this.getJavaElementForAnnotationTypeMemberDeclaration(currentType, annotationTypeMemberDeclaration);
            }
            String[] parametersResolved = (String[])this.methodSymbol.params().stream().map(varSymbol -> varSymbol.type).map(t -> {
                Object object;
                if (t instanceof Type.TypeVar) {
                    Type.TypeVar typeVar = (Type.TypeVar)t;
                    object = "T" + typeVar.tsym.name.toString() + ";";
                } else {
                    object = Signature.createTypeSignature((String)this.resolveTypeName((Type)t, true), (boolean)true);
                }
                return object;
            }).toArray(String[]::new);
            IMethod[] methods = currentType.findMethods(currentType.getMethod(this.getName(), parametersResolved));
            if (methods != null && methods.length > 0) {
                return methods[0];
            }
            String[] parametersNotResolved = (String[])this.methodSymbol.params().stream().map(varSymbol -> varSymbol.type).map(t -> {
                Object object;
                if (t instanceof Type.TypeVar) {
                    Type.TypeVar typeVar = (Type.TypeVar)t;
                    object = "T" + typeVar.tsym.name.toString() + ";";
                } else {
                    object = Signature.createTypeSignature((String)this.resolveTypeName((Type)t, false), (boolean)false);
                }
                return object;
            }).toArray(String[]::new);
            methods = currentType.findMethods(currentType.getMethod(this.getName(), parametersNotResolved));
            if (methods != null && methods.length > 0) {
                return methods[0];
            }
        }
        return null;
    }

    private IMethod getJavaElementForMethodDeclaration(IType currentType, MethodDeclaration methodDeclaration) {
        ArrayList<String> typeParamsList = new ArrayList<String>();
        ArrayList typeParams = null;
        typeParams = methodDeclaration.typeParameters();
        if (typeParams == null) {
            typeParams = new ArrayList();
        }
        for (int i = 0; i < typeParams.size(); ++i) {
            typeParamsList.add(((TypeParameter)typeParams.get(i)).getName().toString());
        }
        java.util.List p = methodDeclaration.parameters();
        String[] params = (String[])p.stream().map(param -> {
            String sig = Util.getSignature((org.eclipse.jdt.core.dom.Type)param.getType());
            if (param.isVarargs()) {
                sig = Signature.createArraySignature((String)sig, (int)1);
            }
            return sig;
        }).toArray(String[]::new);
        IMethod result = currentType.getMethod(this.getName(), params);
        if (currentType.isBinary() || result.exists()) {
            return result;
        }
        IMethod[] methods = null;
        try {
            methods = currentType.getMethods();
        }
        catch (JavaModelException e) {
            return null;
        }
        IMethod[] candidates = Member.findMethods((IMethod)result, (IMethod[])methods);
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        return candidates[0];
    }

    private IMethod resolved(IMethod from) {
        if (from == null) {
            return null;
        }
        if (from.isResolved()) {
            return from;
        }
        if (from instanceof SourceMethod && !(from instanceof ResolvedSourceMethod)) {
            return new ResolvedSourceMethod((JavaElement)from.getParent(), from.getElementName(), from.getParameterTypes(), this.computeKeyWithThrowsFromJavadoc(from), from.getOccurrenceCount());
        }
        if (from instanceof BinaryMethod && !(from instanceof ResolvedBinaryMethod)) {
            return new ResolvedBinaryMethod((JavaElement)from.getParent(), from.getElementName(), from.getParameterTypes(), this.computeKeyWithThrowsFromJavadoc(from), from.getOccurrenceCount());
        }
        return from;
    }

    private String computeKeyWithThrowsFromJavadoc(IMethod method) {
        String[] exceptions = null;
        try {
            exceptions = method.getExceptionTypes();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (exceptions == null || exceptions.length == 0) {
            exceptions = (String[])Arrays.stream(this.getExceptionTypes()).map(IBinding::getKey).toArray(String[]::new);
        }
        String exceptionsAsString = Arrays.stream(exceptions).map(t -> "|" + t.replace('.', '/')).collect(Collectors.joining());
        return this.getKey() + exceptionsAsString;
    }

    private IMethod getJavaElementForAnnotationTypeMemberDeclaration(IType currentType, AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        IMethod result = currentType.getMethod(this.getName(), new String[0]);
        if (currentType.isBinary() || result.exists()) {
            return result;
        }
        IMethod[] methods = null;
        try {
            methods = currentType.getMethods();
        }
        catch (JavaModelException e) {
            return null;
        }
        IMethod[] candidates = Member.findMethods((IMethod)result, (IMethod[])methods);
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        return candidates[0];
    }

    private String resolveTypeName(Type type, boolean binary) {
        if (binary) {
            if (type instanceof Type.ArrayType) {
                Type.ArrayType arrayType = (Type.ArrayType)type;
                return this.resolveTypeName(arrayType.elemtype, binary) + "[]";
            }
            Symbol.TypeSymbol sym = type.asElement();
            if (sym != null) {
                return sym.getQualifiedName().toString();
            }
            return type.toString();
        }
        return type.asElement().toString();
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.computeKey();
        }
        return this.key;
    }

    private String computeKey() {
        try {
            StringBuilder builder = new StringBuilder();
            JavacMethodBinding.getKey(builder, this.methodSymbol, this.methodType, this.parentType, this.resolver);
            return builder.toString();
        }
        catch (JavacBindingResolver.BindingKeyException bke) {
            return null;
        }
    }

    static void getKey(StringBuilder builder, Symbol.MethodSymbol methodSymbol, Type.MethodType methodType, Type parentType, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        JavacMethodBinding.getKey(builder, methodSymbol, methodType, parentType, false, resolver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void getKey(StringBuilder builder, Symbol.MethodSymbol methodSymbol, Type.MethodType methodType, Type parentType, boolean useSlashes, JavacBindingResolver resolver) throws JavacBindingResolver.BindingKeyException {
        boolean methodSymbolNonNullType;
        if (parentType != null) {
            JavacTypeBinding parentBinding = resolver.bindings.getTypeBinding(parentType);
            String parentKey = parentBinding.getKey(true, true);
            builder.append(parentKey);
        } else {
            Symbol ownerSymbol = methodSymbol.owner;
            while (ownerSymbol != null && !(ownerSymbol instanceof Symbol.TypeSymbol)) {
                ownerSymbol = ownerSymbol.owner;
            }
            if (!(ownerSymbol instanceof Symbol.TypeSymbol)) throw new JavacBindingResolver.BindingKeyException(new IllegalArgumentException("Method has no owning class"));
            Symbol.TypeSymbol ownerTypeSymbol = (Symbol.TypeSymbol)ownerSymbol;
            if (ownerTypeSymbol.type == Type.noType) throw new JavacBindingResolver.BindingKeyException(new IllegalArgumentException("Method has no owning class"));
            JavacTypeBinding.getKey(builder, resolver.getTypes().erasure(ownerTypeSymbol.type), false, false, useSlashes, resolver);
        }
        boolean appendMethodName = !methodSymbol.isConstructor() && ((Name)methodSymbol.getSimpleName()).toString().length() != 0;
        boolean bl = methodSymbolNonNullType = methodSymbol.type != null;
        if (appendMethodName || methodSymbolNonNullType) {
            builder.append(".");
        }
        if (appendMethodName) {
            builder.append(methodSymbol.getSimpleName());
        }
        if (!methodSymbolNonNullType) return;
        if (methodType != null && !methodType.getTypeArguments().isEmpty()) {
            builder.append('<');
            for (Type type : methodType.getTypeArguments()) {
                JavacTypeBinding.getKey(builder, type, false, true, useSlashes, resolver);
            }
            builder.append('>');
        } else if (!((List)methodSymbol.getTypeParameters()).isEmpty()) {
            builder.append('<');
            for (Symbol.TypeVariableSymbol typeVariableSymbol : methodSymbol.getTypeParameters()) {
                builder.append(JavacTypeVariableBinding.getTypeVariableKey(typeVariableSymbol, resolver));
            }
            builder.append('>');
        }
        builder.append('(');
        if (methodType != null) {
            for (Type type : methodType.getParameterTypes()) {
                JavacTypeBinding.getKey(builder, type, false, false, true, resolver);
            }
        } else {
            for (Symbol.VarSymbol varSymbol : methodSymbol.getParameters()) {
                JavacTypeBinding.getKey(builder, varSymbol.type, false, false, true, resolver);
            }
        }
        builder.append(')');
        if (methodType != null && !(methodType.getReturnType() instanceof Type.JCNoType)) {
            JavacTypeBinding.getKey(builder, methodType.getReturnType(), false, true, true, resolver);
        } else if (!(methodSymbol.getReturnType() instanceof Type.JCNoType)) {
            JavacTypeBinding.getKey(builder, methodSymbol.getReturnType(), false, true, true, resolver);
        }
        if (!methodSymbol.getThrownTypes().stream().anyMatch(a -> !a.getParameterTypes().isEmpty())) return;
        builder.append('^');
        for (Type type : methodSymbol.getThrownTypes()) {
            builder.append(type.tsym.getQualifiedName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof IMethodBinding)) return false;
        IMethodBinding other = (IMethodBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    public boolean isConstructor() {
        return this.methodSymbol != null && this.methodSymbol.isConstructor();
    }

    public boolean isCompactConstructor() {
        return (this.methodSymbol.flags() & 0x8000000000000L) != 0L;
    }

    public boolean isCanonicalConstructor() {
        return (this.methodSymbol.flags() & 0x2000000000000000L) != 0L;
    }

    public boolean isDefaultConstructor() {
        return (this.methodSymbol.flags() & 0x1000000000L) != 0L;
    }

    public String getName() {
        if (this.isConstructor()) {
            ITypeBinding tb = this.getDeclaringClass();
            if (tb instanceof JavacTypeBinding) {
                JavacTypeBinding tb2 = (JavacTypeBinding)tb;
                return tb2.getName(false);
            }
            return tb.getName();
        }
        return ((Name)this.methodSymbol.getSimpleName()).toString();
    }

    public ITypeBinding getDeclaringClass() {
        if (this.parentType != null) {
            return this.resolver.bindings.getTypeBinding(this.parentType, this.isDeclaration);
        }
        Symbol symbol = this.methodSymbol.owner;
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)symbol;
            return this.resolver.bindings.getTypeBinding(clazz.type, this.isDeclaration);
        }
        return null;
    }

    public IBinding getDeclaringMember() {
        return null;
    }

    public Object getDefaultValue() {
        return this.resolver.getValueFromAttribute(this.methodSymbol.defaultValue);
    }

    public IAnnotationBinding[] getParameterAnnotations(int paramIndex) {
        Symbol.VarSymbol parameter = this.methodSymbol.params.get(paramIndex);
        return (IAnnotationBinding[])parameter.getAnnotationMirrors().stream().map(annotation -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)annotation, null)).toArray(IAnnotationBinding[]::new);
    }

    public ITypeBinding[] getParameterTypes() {
        ITypeBinding[] res = new ITypeBinding[((List)this.methodType.getParameterTypes()).length()];
        for (int i = 0; i < res.length; ++i) {
            MethodDeclaration methodDecl;
            Object e;
            ASTNode aSTNode;
            Type paramType = (Type)((List)this.methodType.getParameterTypes()).get(i);
            JavacTypeBinding paramBinding = this.resolver.bindings.getTypeBinding(paramType);
            if (paramBinding == null && (aSTNode = this.resolver.findDeclaringNode((IBinding)this)) instanceof MethodDeclaration && (e = (methodDecl = (MethodDeclaration)aSTNode).parameters().get(i)) instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration paramDeclaration = (SingleVariableDeclaration)e;
                paramBinding = this.resolver.resolveType(paramDeclaration.getType());
            }
            res[i] = paramBinding;
        }
        return res;
    }

    public ITypeBinding getDeclaredReceiverType() {
        return this.resolver.bindings.getTypeBinding(this.methodType.getReceiverType());
    }

    public ITypeBinding getReturnType() {
        return this.resolver.bindings.getTypeBinding(this.methodType.getReturnType());
    }

    public ITypeBinding[] getExceptionTypes() {
        return (ITypeBinding[])this.methodType.getThrownTypes().stream().map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
    }

    public ITypeBinding[] getTypeParameters() {
        if (this.getTypeArguments().length != 0) {
            return NO_TYPE_PARAMS;
        }
        return (ITypeBinding[])this.methodSymbol.getTypeParameters().stream().map(symbol -> this.resolver.bindings.getTypeBinding(symbol.type)).toArray(ITypeBinding[]::new);
    }

    public boolean isAnnotationMember() {
        return this.getDeclaringClass().isAnnotation();
    }

    public boolean isGenericMethod() {
        if (this.methodHasGenerics()) {
            return true;
        }
        if (this.methodSymbol.type instanceof Type.ForAll) {
            return !this.methodMatchesParameterized();
        }
        return false;
    }

    private boolean methodHasGenerics() {
        boolean b1 = this.isConstructor() && this.getDeclaringClass().isGenericType() || !((List)this.methodSymbol.getTypeParameters()).isEmpty() && this.isDeclaration;
        return b1;
    }

    public boolean isParameterizedMethod() {
        return !this.isRawMethod() && !this.methodHasGenerics() && this.methodMatchesParameterized();
    }

    private boolean methodMatchesParameterized() {
        return this.isConstructor() && this.getDeclaringClass().isParameterizedType() || !((List)this.methodSymbol.getTypeParameters()).isEmpty() && !this.isDeclaration;
    }

    public boolean isRawMethod() {
        if (this.isConstructor()) {
            return this.getDeclaringClass().isRawType() && ((List)this.methodSymbol.getTypeParameters()).isEmpty();
        }
        return this.parentType != null && this.parentType.isRaw() || ((List)this.methodSymbol.getTypeParameters()).isEmpty() && !((List)this.methodSymbol.getTypeParameters()).isEmpty();
    }

    public ITypeBinding[] getTypeArguments() {
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        for (int i = 0; i < this.methodSymbol.type.getParameterTypes().size(); ++i) {
            ListBuffer<Type> originalTypes = new ListBuffer<Type>();
            ListBuffer<Type> substitutedTypes = new ListBuffer<Type>();
            this.resolver.getTypes().adapt(this.methodSymbol.type.getParameterTypes().get(i), (Type)((List)this.methodType.getParameterTypes()).get(i), originalTypes, substitutedTypes);
            List<Type> originalTypesList = originalTypes.toList();
            List<Type> substitutedTypesList = substitutedTypes.toList();
            for (int j = 0; j < originalTypesList.size(); ++j) {
                typeMap.putIfAbsent((Type)originalTypesList.get(j), (Type)substitutedTypesList.get(j));
            }
        }
        ListBuffer<Type> originalTypes = new ListBuffer<Type>();
        ListBuffer<Type> substitutedTypes = new ListBuffer<Type>();
        this.resolver.getTypes().adapt(this.methodSymbol.type.getReturnType(), this.methodType.getReturnType(), originalTypes, substitutedTypes);
        List<Type> originalTypesList = originalTypes.toList();
        List<Type> substitutedTypesList = substitutedTypes.toList();
        for (int j = 0; j < originalTypesList.size(); ++j) {
            typeMap.putIfAbsent((Type)originalTypesList.get(j), (Type)substitutedTypesList.get(j));
        }
        boolean allEqual = true;
        for (Map.Entry entry : typeMap.entrySet()) {
            if (!((Type)entry.getKey()).equals(entry.getValue())) {
                allEqual = false;
            }
            if (entry.getValue() != null) continue;
            return NO_TYPE_ARGUMENTS;
        }
        if (allEqual) {
            return NO_TYPE_ARGUMENTS;
        }
        return (ITypeBinding[])this.methodSymbol.getTypeParameters().stream().map(tvSym -> (Type)typeMap.get(tvSym.type)).map(this.resolver.bindings::getTypeBinding).toArray(ITypeBinding[]::new);
    }

    public IMethodBinding getMethodDeclaration() {
        return this.resolver.bindings.getMethodBinding(this.methodSymbol.type.asMethodType(), this.methodSymbol, null, true);
    }

    public boolean isSubsignature(IMethodBinding otherMethod) {
        if (otherMethod instanceof JavacMethodBinding) {
            JavacMethodBinding otherJavacMethod = (JavacMethodBinding)otherMethod;
            return this.resolver.getTypes().isSubSignature(this.methodType, otherJavacMethod.methodType);
        }
        return false;
    }

    public boolean isVarargs() {
        return this.methodSymbol.isVarArgs();
    }

    public boolean overrides(IMethodBinding method) {
        if (this == method) {
            return false;
        }
        if (method instanceof JavacMethodBinding) {
            JavacMethodBinding javacMethod = (JavacMethodBinding)method;
            return Objects.equals(this.methodSymbol.name, javacMethod.methodSymbol.name) && this.methodSymbol.overrides(((JavacMethodBinding)method).methodSymbol, javacMethod.methodSymbol.enclClass(), this.resolver.getTypes(), true);
        }
        return false;
    }

    public IVariableBinding[] getSyntheticOuterLocals() {
        if (!this.methodSymbol.isLambdaMethod()) {
            return new IVariableBinding[0];
        }
        return (IVariableBinding[])this.methodSymbol.capturedLocals.stream().map(varSymbol -> this.resolver.bindings.getVariableBinding((Symbol.VarSymbol)varSymbol)).toArray(IVariableBinding[]::new);
    }

    public boolean isSyntheticRecordMethod() {
        return this.explicitSynthetic || !this.methodSymbol.isStatic() && !this.isConstructor() && (this.methodSymbol.flags() & 0x2000000001001000L) != 0L && this.getDeclaringClass().isRecord();
    }

    public String[] getParameterNames() {
        if (this.methodSymbol.getParameters() == null) {
            return new String[0];
        }
        return (String[])this.methodSymbol.getParameters().stream().map(Symbol::getSimpleName).map(Object::toString).toArray(String[]::new);
    }

    public String toString() {
        return this.modifiersAsString() + this.getReturnType().getQualifiedName() + " " + this.getName().toString() + "(" + Arrays.stream(this.getParameterTypes()).map(ITypeBinding::getQualifiedName).collect(Collectors.joining(",")) + ") ";
    }

    protected String modifiersAsString() {
        Object res = "";
        int modifiers = this.getModifiers();
        if (Modifier.isPublic((int)modifiers)) {
            res = (String)res + "public ";
        }
        if (Modifier.isProtected((int)modifiers)) {
            res = (String)res + "protected ";
        }
        if (Modifier.isPrivate((int)modifiers)) {
            res = (String)res + "private ";
        }
        if (Modifier.isStatic((int)modifiers)) {
            res = (String)res + "static ";
        }
        if (Modifier.isAbstract((int)modifiers)) {
            res = (String)res + "abstract ";
        }
        return res;
    }
}

