/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;

public final class RegexSource {
    private static final Pattern CAPTURING_REGEX_SOURCE = Pattern.compile("\\$(\\d+)|\\$\\{(\\d+):\\/(downcase|upcase)}");

    public static String escapeRegExpCharacters(CharSequence value) {
        int valueLen = value.length();
        StringBuilder sb = new StringBuilder(valueLen);
        int i = 0;
        while (i < valueLen) {
            char ch = value.charAt(i);
            switch (ch) {
                case '#': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\');
                }
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static boolean hasCaptures(@Nullable CharSequence regexSource) {
        if (regexSource == null) {
            return false;
        }
        return CAPTURING_REGEX_SOURCE.matcher(regexSource).find();
    }

    public static String replaceCaptures(CharSequence regexSource, CharSequence captureSource, OnigCaptureIndex[] captureIndices) {
        Matcher m = CAPTURING_REGEX_SOURCE.matcher(regexSource);
        StringBuilder result = new StringBuilder();
        while (m.find()) {
            String match = m.group();
            String replacement = RegexSource.getReplacement(match, captureSource, captureIndices);
            m.appendReplacement(result, replacement);
        }
        m.appendTail(result);
        return result.toString();
    }

    private static String getReplacement(String match, CharSequence captureSource, OnigCaptureIndex[] captureIndices) {
        OnigCaptureIndex capture;
        String command;
        int index;
        int doublePointIndex = match.indexOf(58);
        if (doublePointIndex != -1) {
            index = Integer.parseInt(match.substring(2, doublePointIndex));
            command = match.substring(doublePointIndex + 2, match.length() - 1);
        } else {
            index = Integer.parseInt(match.substring(1));
            command = null;
        }
        OnigCaptureIndex onigCaptureIndex = capture = captureIndices.length > index ? captureIndices[index] : null;
        if (capture != null) {
            CharSequence result = captureSource.subSequence(capture.start, capture.end);
            while (!result.isEmpty() && result.charAt(0) == '.') {
                result = result.subSequence(1, result.length());
            }
            if ("downcase".equals(command)) {
                return result.toString().toLowerCase();
            }
            if ("upcase".equals(command)) {
                return result.toString().toUpperCase();
            }
            return result.toString();
        }
        return match;
    }

    private RegexSource() {
    }
}

