/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.module;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlOutputElement;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.module.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.module.TmfXmlLatencyViewOutput;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.module.TmfXmlViewOutput;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;

public class TmfXmlAnalysisOutputSource
implements ITmfNewAnalysisModuleListener {
    private static final String LATENCY_STRING = "Latency";
    public static final @NonNull String DATA_SEPARATOR = ";;;";

    public void moduleCreated(IAnalysisModule module) {
        if (module instanceof ITmfAnalysisModuleWithStateSystems) {
            Multimap outputs = XmlUtils.getXmlOutputElements();
            for (Collection elements : outputs.asMap().values()) {
                ViewType[] viewTypeArray = ViewType.values();
                int n = viewTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewType viewType = viewTypeArray[n2];
                    Iterable filteredElements = Iterables.filter((Iterable)elements, element -> element.getXmlElem().equals(viewType.getXmlElem()) && element.getAnalyses().contains(module.getId()));
                    String viewId = viewType.getViewId();
                    for (XmlOutputElement element2 : filteredElements) {
                        TmfXmlViewOutput output = new TmfXmlViewOutput(viewId, viewType);
                        output.setOutputProperty("xmlOutputData", element2.getId() + DATA_SEPARATOR + element2.getPath() + DATA_SEPARATOR + element2.getLabel(), false);
                        module.registerOutput((IAnalysisOutput)output);
                    }
                    ++n2;
                }
            }
        }
        if (module instanceof XmlPatternAnalysis) {
            LatencyViewType[] latencyViewTypeArray = LatencyViewType.values();
            int n = latencyViewTypeArray.length;
            int n3 = 0;
            while (n3 < n) {
                LatencyViewType viewType = latencyViewTypeArray[n3];
                String viewLabelPrefix = ((XmlPatternAnalysis)module).getViewLabelPrefix();
                String label = viewLabelPrefix.isEmpty() ? viewType.getLabel() : viewType.getLabel().replaceFirst(LATENCY_STRING, viewLabelPrefix);
                TmfXmlLatencyViewOutput output = new TmfXmlLatencyViewOutput(viewType.getViewId(), label);
                output.setOutputProperty("xmlLatencyOutputData", module.getId() + DATA_SEPARATOR + output.getName(), false);
                module.registerOutput((IAnalysisOutput)output);
                ++n3;
            }
        }
    }

    public static enum LatencyViewType {
        LATENCY_TABLE("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latencytable", Messages.TmfXmlAnalysisOutputSource_LatencyTable),
        SCATTER_GRAPH("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.scattergraph", Messages.TmfXmlAnalysisOutputSource_ScatterGraphTitle),
        DENSITY_VIEW("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.density", Messages.TmfXmlAnalysisOutputSource_DensityChartTitle),
        STATISTIC_VIEW("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.statistics", Messages.TmfXmlAnalysisOutputSource_LatencyStatisticsTitle);

        private @NonNull String fLatencyViewId;
        private String fLatencyViewLabel;

        private LatencyViewType(String viewId, String label) {
            this.fLatencyViewId = viewId;
            this.fLatencyViewLabel = label;
        }

        public String getViewId() {
            return this.fLatencyViewId;
        }

        public String getLabel() {
            return this.fLatencyViewLabel;
        }
    }

    public static enum ViewType {
        TIME_GRAPH_VIEW(XmlUtils.OutputType.TIME_GRAPH, "org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph"),
        XY_VIEW(XmlUtils.OutputType.XY, "org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.views.xyview");

        private final XmlUtils.OutputType fOutputType;
        private final String fViewId;

        private ViewType(XmlUtils.OutputType outputType, String viewId) {
            this.fOutputType = outputType;
            this.fViewId = viewId;
        }

        public @NonNull String getXmlElem() {
            return this.fOutputType.getXmlElem();
        }

        private String getViewId() {
            return this.fViewId;
        }
    }
}

