/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.core.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.eclipse.lsp4j.Position;
import org.eclipse.tracecompass.tmf.filter.parser.FilterParserLexer;

public class AutoCompletion {
    private static String[] OPERATORS = new String[]{"==", "!=", "<", ">", "matches", "contains", "present"};
    private static String[] SEPARATORS = new String[]{"&&", "||"};

    public static List<String> autoCompletion(String str, Position cursor) throws IOException {
        int i;
        String subString = str.substring(0, cursor.getCharacter());
        String endString = str.substring(cursor.getCharacter(), str.length());
        ArrayList<String> suggestions = new ArrayList<String>();
        ByteArrayInputStream input = new ByteArrayInputStream(subString.getBytes());
        ANTLRInputStream antlrStream = new ANTLRInputStream((InputStream)input);
        FilterParserLexer lexer = new FilterParserLexer((CharStream)antlrStream);
        ArrayList lexerExceptions = new ArrayList();
        lexer.setErrorListener(e -> lexerExceptions.add((RecognitionException)e));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        List commonTokens = tokenStream.getTokens();
        if (commonTokens.isEmpty()) {
            return suggestions;
        }
        CommonToken lastToken = null;
        int lastType = -1;
        if (!commonTokens.isEmpty()) {
            lastToken = (CommonToken)commonTokens.get(commonTokens.size() - 1);
            lastType = lastToken.getType();
        }
        CommonToken beforeLastToken = null;
        int beforeLastType = -1;
        if (commonTokens.size() > 1) {
            beforeLastToken = (CommonToken)commonTokens.get(commonTokens.size() - 2);
            beforeLastType = beforeLastToken.getType();
        }
        if (lastToken != null && lastType == 19) {
            i = 0;
            while (i < SEPARATORS.length) {
                suggestions.add(new String(subString + " " + SEPARATORS[i] + " " + endString));
                ++i;
            }
            if (beforeLastToken == null || beforeLastType != 6) {
                i = 0;
                while (i < OPERATORS.length) {
                    suggestions.add(new String(subString + " " + OPERATORS[i] + " " + endString));
                    ++i;
                }
            }
        }
        if (lastToken != null && lastType == 23) {
            i = 0;
            while (i < SEPARATORS.length) {
                suggestions.add(new String(subString + " " + SEPARATORS[i] + " " + endString));
                ++i;
            }
        }
        i = 0;
        while (i < suggestions.size()) {
            input = new ByteArrayInputStream(((String)suggestions.get(i)).getBytes());
            antlrStream = new ANTLRInputStream((InputStream)input);
            lexer = new FilterParserLexer((CharStream)antlrStream);
            tokenStream = new CommonTokenStream((TokenSource)lexer);
            lexer.setErrorListener(e -> lexerExceptions.add((RecognitionException)e));
            commonTokens = tokenStream.getTokens();
            StringBuilder suggestion = new StringBuilder();
            int j = 0;
            while (j < commonTokens.size()) {
                suggestion.append(((CommonToken)commonTokens.get(j)).getText() + " ");
                ++j;
            }
            suggestions.set(i, suggestion.toString());
            ++i;
        }
        return suggestions;
    }
}

