/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewer;

public class SuperTypeHierarchyViewer
extends TypeHierarchyViewer {
    public SuperTypeHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part) {
        super(parent, (IContentProvider)new SuperTypeHierarchyContentProvider(lifeCycle), lifeCycle, part);
    }

    @Override
    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.SuperTypeHierarchyViewer_filtered_title;
        }
        return TypeHierarchyMessages.SuperTypeHierarchyViewer_title;
    }

    @Override
    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            this.expandAll();
        }
        this.getTree().setRedraw(true);
    }

    public static class SuperTypeHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public SuperTypeHierarchyContentProvider(TypeHierarchyLifeCycle lifeCycle) {
            super(lifeCycle);
        }

        @Override
        protected final void getTypesInHierarchy(IType type, List res) {
            IType superClass;
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null && (superClass = hierarchy.getSuperclass(type)) != null) {
                res.add(superClass);
            }
        }

        @Override
        protected IType getParentType(IType type) {
            return null;
        }
    }
}

