/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.ScriptStorage;

public class WorkspaceScriptStorage
extends ScriptStorage {
    public WorkspaceScriptStorage(String location) {
        super(location);
    }

    @Override
    protected boolean createFile(Path path, String content) {
        Path locationPath = new Path(this.getLocation().substring(12));
        IPath fullPath = locationPath.append(path.removeLastSegments(1));
        Object container = fullPath.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFolder(fullPath) : ResourcesPlugin.getWorkspace().getRoot().getProject(fullPath.toString());
        IFile file = container.getFile((IPath)new Path(path.lastSegment()));
        if (!file.exists()) {
            try {
                file.create((InputStream)new ByteArrayInputStream(content.getBytes()), false, null);
                return true;
            }
            catch (CoreException e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Could not create file " + file), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    protected boolean createPath(IPath path) {
        Path locationPath = new Path(this.getLocation().substring(12));
        IPath fullPath = locationPath.append(path);
        IProject project = this.createProject(fullPath.segment(0));
        if (project != null) {
            if (fullPath.segmentCount() > 1) {
                return this.createFolders((IContainer)project, fullPath.removeFirstSegments(1));
            }
            return true;
        }
        return false;
    }

    private boolean createFolders(IContainer container, IPath folderPath) {
        IFolder folder = container.getFolder(folderPath);
        if (!folder.getParent().exists() && !this.createFolders(container, folderPath.removeLastSegments(1))) {
            return false;
        }
        if (!folder.exists()) {
            try {
                folder.create(false, true, null);
                return true;
            }
            catch (CoreException e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Could not create folder " + folder), (Throwable)e);
            }
        } else {
            return true;
        }
        return false;
    }

    private IProject createProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            try {
                project.create(null);
                project.open(null);
                return project;
            }
            catch (CoreException e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Could not create project " + project), (Throwable)e);
            }
        } else {
            return project;
        }
        return null;
    }
}

