/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.views.timers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.AbstractRosPresentationProvider;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class RosTimersPresentationProvider
extends AbstractRosPresentationProvider {
    @Override
    public String getStateTypeName(ITimeGraphEntry entry) {
        String entryName = entry.getName();
        if (entryName.startsWith("0x")) {
            return Messages.AbstractRosPresentationProvider_TimerCallback;
        }
        if (entryName.equals("scheduled")) {
            return null;
        }
        if (StringUtils.isNumeric((CharSequence)entryName)) {
            return Messages.AbstractRosPresentationProvider_TimerIndex;
        }
        return null;
    }

    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        String label = event.getLabel();
        String entryName = event.getEntry().getName();
        String nodeName = Messages.AbstractRosPresentationProvider_Unknown;
        if (entryName.startsWith("0x")) {
            nodeName = event.getEntry().getParent().getName();
            builder.put((Object)Messages.AbstractRosPresentationProvider_TimerPeriod, (Object)label);
        } else if (entryName.equals("scheduled")) {
            nodeName = event.getEntry().getParent().getParent().getName();
            builder.put((Object)Messages.AbstractRosPresentationProvider_TimerCount, (Object)label);
        } else if (StringUtils.isNumeric((CharSequence)entryName)) {
            nodeName = event.getEntry().getParent().getParent().getParent().getName();
            builder.put((Object)Messages.AbstractRosPresentationProvider_TimerQueueReference, (Object)label);
        }
        builder.put((Object)Messages.AbstractRosPresentationProvider_NodeName, (Object)nodeName);
        return builder.build();
    }
}

