/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.analysis;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.dpdk.core.trace.DpdkTrace;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.analysis.DpdkEthdevEventLayout;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.analysis.DpdkEthdevSpinStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAnalysisEventRequirement;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class DpdkEthdevSpinAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.spin.analysis";
    private final DpdkEthdevEventLayout fLayout = new DpdkEthdevEventLayout();
    private final TmfAbstractAnalysisRequirement REQUIREMENT = new TmfAnalysisEventRequirement((Collection)ImmutableList.of((Object)this.fLayout.eventEthdevRxBurstEmpty(), (Object)this.fLayout.eventEthdevRxBurstNonEmpty()), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        if (trace instanceof DpdkTrace) {
            return new DpdkEthdevSpinStateProvider(trace, this.fLayout, ID);
        }
        throw new IllegalStateException();
    }

    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        return Collections.singleton(this.REQUIREMENT);
    }

    public Map<String, Pair<Long, Long>> calculateThreadStateDurations(Set<Integer> threads, long start, long end) {
        HashMap<String, Pair<Long, Long>> map = new HashMap<String, Pair<Long, Long>>();
        ITmfTrace trace = this.getTrace();
        ITmfStateSystem threadSs = this.getStateSystem();
        if (trace == null || threadSs == null) {
            return map;
        }
        long startTime = Math.max(start, threadSs.getStartTime());
        long endTime = Math.min(end, threadSs.getCurrentEndTime());
        if (endTime < startTime) {
            return map;
        }
        try {
            int threadsQuark = threadSs.getQuarkAbsolute(new String[]{"Threads"});
            Iterator iterator = threadSs.getSubAttributes(threadsQuark, false).iterator();
            while (iterator.hasNext()) {
                int threadQuark = (Integer)iterator.next();
                if (!threads.contains(threadQuark)) continue;
                String threadName = threadSs.getAttributeName(threadQuark);
                long countActive = 0L;
                long countSpin = 0L;
                Iterator iterator2 = threadSs.getSubAttributes(threadQuark, false).iterator();
                while (iterator2.hasNext()) {
                    int queueQuark = (Integer)iterator2.next();
                    countActive += DpdkEthdevSpinAnalysisModule.calculateStateCount(threadSs, queueQuark, startTime, endTime, "Active");
                    countSpin += DpdkEthdevSpinAnalysisModule.calculateStateCount(threadSs, queueQuark, startTime, endTime, "Spin");
                }
                map.put(threadName, (Pair<Long, Long>)new Pair((Object)countActive, (Object)countSpin));
            }
        }
        catch (AttributeNotFoundException | TimeRangeException e) {
            Activator.getInstance().logError(e.getMessage());
        }
        return map;
    }

    private static long calculateStateCount(ITmfStateSystem stateSystem, int attributeNode, long startTime, long endTime, String targetState) {
        long count = 0L;
        long ts = startTime;
        try {
            while (ts < endTime) {
                ITmfStateInterval stateInterval = stateSystem.querySingleState(ts, attributeNode);
                Object stateValue = stateInterval.getStateValue().unboxValue();
                long stateStart = stateInterval.getStartTime();
                long stateEnd = stateInterval.getEndTime();
                if (stateValue != null && targetState.equals(stateValue)) {
                    count += DpdkEthdevSpinAnalysisModule.interpolateCount(startTime, endTime, stateStart, stateEnd);
                }
                ts = Math.min(stateEnd, endTime) + 1L;
            }
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Activator.getInstance().logError(e.getMessage());
        }
        return count;
    }

    private static long interpolateCount(long startTime, long endTime, long startInterval, long endInterval) {
        long count = endInterval - startInterval;
        if (count > 0L) {
            if (startTime > startInterval) {
                count -= startTime - startInterval;
            }
            if (endTime < endInterval) {
                count -= endInterval - endTime;
            }
        }
        return count;
    }
}

