/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.SearchBrokenNLSKeysUtil;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FindBrokenNLSKeysAction
extends SelectionDispatchAction {
    public static final String FIND_BROKEN_NLS_KEYS_ACTION_ID = "org.eclipse.wst.jsdt.ui.edit.text.java.find.broken.nls.keys";
    public static final String ACTION_HANDLER_ID = "org.eclipse.wst.jsdt.ui.actions.FindNLSProblems";
    private JavaEditor fEditor;

    public FindBrokenNLSKeysAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FindNLSProblemsAction_Name);
        this.setToolTipText(ActionMessages.FindNLSProblemsAction_ToolTip);
        this.setDescription(ActionMessages.FindNLSProblemsAction_Description);
    }

    public FindBrokenNLSKeysAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindBrokenNLSKeysAction.getCompilationUnit(editor) != null);
    }

    @Override
    public void run(ITextSelection selection) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        this.run((IStructuredSelection)new StructuredSelection((Object)selectionProvider.getSelection()));
    }

    @Override
    public void run(IStructuredSelection selection) {
        SearchPatternData[] data;
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IJavaScriptElement) {
            IJavaScriptElement javaElement = (IJavaScriptElement)firstElement;
            if (!ActionUtil.isProcessable(this.getShell(), javaElement)) {
                return;
            }
        }
        if ((data = this.getNLSFiles(selection)) == null || data.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.FindNLSProblemsAction_ErrorDialogTitle, (String)ActionMessages.FindNLSProblemsAction_NoPropertieFilesFoundErrorDescription);
            return;
        }
        String scope = "workspace";
        if (selection.size() == 1) {
            Object firstElement2 = selection.getFirstElement();
            if (firstElement2 instanceof IJavaScriptElement) {
                scope = ((IJavaScriptElement)firstElement2).getElementName();
            } else if (firstElement2 instanceof IFile) {
                scope = ((IFile)firstElement2).getName();
            } else if (firstElement2 instanceof IFolder) {
                scope = ((IFolder)firstElement2).getName();
            }
        }
        this.run(data, scope);
    }

    private void run(SearchPatternData[] data, String scope) {
        ArrayList<IType> wrappers = new ArrayList<IType>();
        ArrayList<IFile> properties = new ArrayList<IFile>();
        int i = 0;
        while (i < data.length) {
            SearchPatternData current = data[i];
            if (current.getWrapperClass() != null || current.getPropertyFile() != null) {
                wrappers.add(current.getWrapperClass());
                properties.add(current.getPropertyFile());
            }
            ++i;
        }
        IType[] accessorClasses = wrappers.toArray(new IType[wrappers.size()]);
        IFile[] propertieFiles = properties.toArray(new IFile[properties.size()]);
        SearchBrokenNLSKeysUtil.search(scope, accessorClasses, propertieFiles);
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            this.setEnabled(false);
        } else {
            this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)selectionProvider.getSelection()));
        }
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private SearchPatternData[] getNLSFiles(IStructuredSelection selection) {
        Object[] selectedElements = selection.toArray();
        ArrayList result = new ArrayList();
        this.collectNLSFiles(selectedElements, result);
        return result.toArray(new SearchPatternData[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canEnable(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block14: {
                try {
                    IFile file;
                    if (selected[i] instanceof IJavaScriptElement) {
                        IJavaScriptElement elem = (IJavaScriptElement)selected[i];
                        if (elem.exists()) {
                            switch (elem.getElementType()) {
                                case 7: {
                                    return elem.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: 
                                case 15: {
                                    return false;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                    return root.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block14;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        return true;
                    }
                    if (selected[i] instanceof IFile && "properties".equalsIgnoreCase((file = (IFile)selected[i]).getFileExtension())) {
                        return true;
                    }
                }
                catch (JavaScriptModelException e) {
                    if (e.isDoesNotExist()) break block14;
                    JavaScriptPlugin.log(e);
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectNLSFiles(Object[] objects, List result) {
        try {
            int i = 0;
            while (true) {
                SearchPatternData data;
                if (i >= objects.length) {
                    return;
                }
                if (objects[i] instanceof IJavaScriptElement) {
                    IJavaScriptElement elem = (IJavaScriptElement)objects[i];
                    if (elem.exists()) {
                        switch (elem.getElementType()) {
                            case 7: {
                                SearchPatternData data2;
                                if (elem.getParent().getElementType() != 5 || (data2 = this.tryIfPropertyCuSelected((IJavaScriptUnit)elem.getParent())) == null) break;
                                result.add(data2);
                                break;
                            }
                            case 5: {
                                SearchPatternData data2 = this.tryIfPropertyCuSelected((IJavaScriptUnit)elem);
                                if (data2 == null) break;
                                result.add(data2);
                                break;
                            }
                            case 12: 
                            case 15: {
                                break;
                            }
                            case 4: {
                                IPackageFragment fragment = (IPackageFragment)elem;
                                if (fragment.getKind() != 1) break;
                                this.collectNLSFiles(new Object[]{fragment.getCorrespondingResource()}, result);
                                break;
                            }
                            case 3: {
                                IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
                                if (root.getKind() != 1) break;
                                this.collectNLSFiles(new Object[]{root.getCorrespondingResource()}, result);
                                break;
                            }
                            case 2: {
                                IJavaScriptProject javaProject = (IJavaScriptProject)elem;
                                IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                                int j = 0;
                                while (j < allPackageFragmentRoots.length) {
                                    IPackageFragmentRoot root = allPackageFragmentRoots[j];
                                    if (root.getKind() == 1 && javaProject.equals(root.getJavaScriptProject())) {
                                        this.collectNLSFiles(new Object[]{root.getCorrespondingResource()}, result);
                                    }
                                    ++j;
                                }
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (objects[i] instanceof LogicalPackage) {
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)objects[i]);
                    this.collectNLSFiles(new Object[]{logicalPackage.getJavaProject()}, result);
                } else if (objects[i] instanceof IFolder) {
                    this.collectNLSFiles(((IFolder)objects[i]).members(), result);
                } else if (objects[i] instanceof IFile && (data = this.tryIfPropertyFileSelected((IFile)objects[i])) != null) {
                    result.add(data);
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            if (e.isDoesNotExist()) return;
            JavaScriptPlugin.log(e);
            return;
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private SearchPatternData tryIfPropertyCuSelected(IJavaScriptUnit compilationUnit) throws JavaScriptModelException {
        if (compilationUnit == null) {
            return null;
        }
        if (!ActionUtil.isOnBuildPath((IJavaScriptElement)compilationUnit)) {
            return null;
        }
        IType[] types = compilationUnit.getTypes();
        if (types.length > 1) {
            return null;
        }
        IStorage bundle = NLSHintHelper.getResourceBundle(compilationUnit);
        if (!(bundle instanceof IFile)) {
            return null;
        }
        return new SearchPatternData(types[0], (IFile)bundle);
    }

    private SearchPatternData tryIfPropertyFileSelected(IFile file) throws JavaScriptModelException {
        if (!"properties".equalsIgnoreCase(file.getFileExtension())) {
            return null;
        }
        IPath propertyFullPath = file.getFullPath();
        String[] javaExtensions = JavaScriptCore.getJavaScriptLikeExtensions();
        int i = 0;
        while (i < javaExtensions.length) {
            String name;
            String resourceName;
            String resourceBundleName;
            IJavaScriptUnit compilationUnit;
            IType type;
            IJavaScriptElement element;
            String filename;
            String extension = javaExtensions[i];
            IPath cuPath = propertyFullPath.removeFileExtension().addFileExtension(extension);
            IFile cuFile = (IFile)JavaScriptPlugin.getWorkspace().getRoot().findMember(cuPath);
            if (cuFile == null && (filename = cuPath.removeFileExtension().lastSegment()) != null && filename.length() > 0) {
                filename = String.valueOf(Character.toUpperCase(filename.charAt(0))) + filename.substring(1);
                IPath dirPath = propertyFullPath.removeLastSegments(1).addTrailingSeparator();
                cuPath = dirPath.append(filename).addFileExtension(extension);
                cuFile = (IFile)JavaScriptPlugin.getWorkspace().getRoot().findMember(cuPath);
            }
            if (cuFile != null && cuFile.exists() && (element = JavaScriptCore.create((IFile)cuFile)) != null && element.exists() && element.getElementType() == 5 && ActionUtil.isOnBuildPath(element) && (type = (compilationUnit = (IJavaScriptUnit)element).findPrimaryType()) != null && (resourceBundleName = NLSHintHelper.getResourceBundleName(compilationUnit)) != null && (resourceName = String.valueOf(resourceBundleName) + ".properties").endsWith(name = file.getName())) {
                return new SearchPatternData(type, file);
            }
            ++i;
        }
        return null;
    }

    private static IJavaScriptUnit getCompilationUnit(JavaEditor editor) {
        WorkingCopyManager manager = JavaScriptPlugin.getDefault().getWorkingCopyManager();
        IJavaScriptUnit cu = manager.getWorkingCopy(editor.getEditorInput());
        return cu;
    }

    private static class SearchPatternData {
        private final IType fAccessorType;
        private final IFile fPropertyFile;

        public SearchPatternData(IType accessorType, IFile propertyFile) {
            this.fAccessorType = accessorType;
            this.fPropertyFile = propertyFile;
        }

        public IFile getPropertyFile() {
            return this.fPropertyFile;
        }

        public IType getWrapperClass() {
            return this.fAccessorType;
        }
    }
}

