/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertLoopFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ConvertLoopCleanUp
extends AbstractCleanUp {
    public ConvertLoopCleanUp(Map options) {
        super(options);
    }

    public ConvertLoopCleanUp() {
    }

    @Override
    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        return this.isEnabled("cleanup.convert_to_enhanced_for_loop");
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean convertForLoops = this.isEnabled("cleanup.convert_to_enhanced_for_loop");
        return ConvertLoopFix.createCleanUp(compilationUnit, convertForLoops, convertForLoops, this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final"));
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    @Override
    public Map getRequiredOptions() {
        return null;
    }

    @Override
    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
            result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
            buf.append("for (var element in ids) {\n");
            buf.append("    var value= element / 2; \n");
            buf.append("    alert(value);\n");
            buf.append("}\n");
        } else {
            buf.append("for (var i = 0; i < ids.length; i++) {\n");
            buf.append("    var value= ids[i] / 2; \n");
            buf.append("    alert(value);\n");
            buf.append("}\n");
        }
        return buf.toString();
    }

    @Override
    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    @Override
    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        return -1;
    }
}

