/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SpanLifeStateProvider
extends AbstractTmfStateProvider {
    public static final String OPEN_TRACING_ATTRIBUTE = "openTracingSpans";
    public static final String UST_ATTRIBUTE = "ustSpans";
    private final Map<String, Integer> fSpanMap = new HashMap<String, Integer>();
    private final Map<String, Integer> fSpanQuarkMap;
    private final Map<String, BiConsumer<ITmfEvent, ITmfStateSystemBuilder>> fHandlers = new HashMap<String, BiConsumer<ITmfEvent, ITmfStateSystemBuilder>>();

    public SpanLifeStateProvider(ITmfTrace trace) {
        super(trace, "org.eclipse.tracecompass.incubator.opentracing.analysis.spanlife");
        this.fSpanQuarkMap = new HashMap<String, Integer>();
        this.fHandlers.put("OpenTracingSpan", this::handleSpan);
        this.fHandlers.put("jaeger_ust:start_span", this::handleStart);
        this.fHandlers.put("jaeger_ust:end_span", this::handleEnd);
    }

    public int getVersion() {
        return 3;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new SpanLifeStateProvider(this.getTrace());
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        ITmfStateSystemBuilder ss = this.getStateSystemBuilder();
        if (ss == null) {
            return;
        }
        BiConsumer<ITmfEvent, ITmfStateSystemBuilder> handler = this.fHandlers.get(event.getType().getName());
        if (handler != null) {
            handler.accept(event, ss);
        }
    }

    private void handleSpan(ITmfEvent event, ITmfStateSystemBuilder ss) {
        int spanQuark;
        long timestamp = event.getTimestamp().toNanos();
        Long duration = (Long)event.getContent().getFieldValue(Long.class, new String[]{"duration"});
        if (duration == null) {
            return;
        }
        String traceId = (String)event.getContent().getFieldValue(String.class, new String[]{"traceID"});
        int traceQuark = ss.getQuarkAbsoluteAndAdd(new String[]{traceId});
        int openTracingSpansQuark = ss.getQuarkRelativeAndAdd(traceQuark, new String[]{OPEN_TRACING_ATTRIBUTE});
        Boolean errorTag = Boolean.parseBoolean((String)event.getContent().getFieldValue(String.class, new String[]{"tags/error"}));
        String processName = (String)event.getContent().getFieldValue(String.class, new String[]{"processName"});
        String name = String.valueOf(TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)event.getTrace(), (String)"Name", (ITmfEvent)event));
        String spanId = (String)event.getContent().getFieldValue(String.class, new String[]{"spanID"});
        String refId = (String)event.getContent().getFieldValue(String.class, new String[]{"references/CHILD_OF"});
        if (refId == null) {
            spanQuark = ss.getQuarkRelativeAndAdd(openTracingSpansQuark, new String[]{name + "/" + spanId + "/" + String.valueOf(errorTag) + "/" + processName});
        } else {
            Integer parentQuark = this.fSpanMap.get(refId);
            if (parentQuark == null) {
                parentQuark = openTracingSpansQuark;
            }
            spanQuark = ss.getQuarkRelativeAndAdd(parentQuark.intValue(), new String[]{name + "/" + spanId + "/" + String.valueOf(errorTag) + "/" + processName});
        }
        ss.modifyAttribute(timestamp, (Object)name, spanQuark);
        Map logs = (Map)event.getContent().getFieldValue(Map.class, new String[]{"logs"});
        if (logs != null) {
            Integer logsQuark = ss.getQuarkRelativeAndAdd(traceQuark, new String[]{"logs"});
            for (Map.Entry log : logs.entrySet()) {
                ArrayList<CallSite> logString = new ArrayList<CallSite>();
                for (Map.Entry entry : ((Map)log.getValue()).entrySet()) {
                    logString.add((CallSite)((Object)((String)entry.getKey() + ":" + (String)entry.getValue())));
                }
                Integer logQuark = ss.getQuarkRelativeAndAdd(logsQuark.intValue(), new String[]{spanId});
                Long logTimestamp = (Long)log.getKey();
                ss.modifyAttribute(logTimestamp.longValue(), (Object)String.join((CharSequence)"~", logString), logQuark.intValue());
                ss.modifyAttribute(logTimestamp + 1L, null, logQuark.intValue());
            }
        }
        ss.modifyAttribute(timestamp + duration, null, spanQuark);
        if (spanId != null) {
            this.fSpanMap.put(spanId, spanQuark);
        }
    }

    private void handleStart(ITmfEvent event, ITmfStateSystemBuilder ss) {
        String traceId = (String)event.getContent().getFieldValue(String.class, new String[]{"trace_id_low"});
        traceId = Long.toHexString(Long.decode(traceId));
        int traceQuark = ss.getQuarkAbsoluteAndAdd(new String[]{traceId});
        int ustSpansQuark = ss.getQuarkRelativeAndAdd(traceQuark, new String[]{UST_ATTRIBUTE});
        String spanId = (String)event.getContent().getFieldValue(String.class, new String[]{"span_id"});
        spanId = Long.toHexString(Long.decode(spanId));
        int spanQuark = ss.getQuarkRelativeAndAdd(ustSpansQuark, new String[]{spanId});
        this.fSpanQuarkMap.put(spanId, spanQuark);
        long timestamp = event.getTimestamp().toNanos();
        String name = (String)event.getContent().getFieldValue(String.class, new String[]{"op_name"});
        ss.modifyAttribute(timestamp, (Object)name, spanQuark);
    }

    private void handleEnd(ITmfEvent event, ITmfStateSystemBuilder ss) {
        String traceId = (String)event.getContent().getFieldValue(String.class, new String[]{"trace_id_low"});
        String spanId = (String)event.getContent().getFieldValue(String.class, new String[]{"span_id"});
        if (spanId == null) {
            return;
        }
        Integer spanQuark = this.fSpanQuarkMap.remove(spanId = Long.toHexString(Long.decode(spanId)));
        if (spanQuark == null) {
            if (traceId == null) {
                return;
            }
            traceId = Long.toHexString(Long.decode(traceId));
            int traceQuark = ss.getQuarkAbsoluteAndAdd(new String[]{traceId});
            int ustSpansQuark = ss.getQuarkRelativeAndAdd(traceQuark, new String[]{UST_ATTRIBUTE});
            spanQuark = ss.getQuarkRelativeAndAdd(ustSpansQuark, new String[]{spanId});
        }
        long timestamp = event.getTimestamp().toNanos();
        ss.modifyAttribute(timestamp, null, spanQuark.intValue());
    }
}

