/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.net.URI;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class MetadataRepositoryElementComparator
extends ViewerComparator {
    private int key;
    private static final String ENABLED = "XX";
    private static final String BLANK = "";
    private static final int ASCENDING = 1;
    private static final int DESCENDING = -1;
    private int primaryKeyDirection = 1;

    public MetadataRepositoryElementComparator(int sortKey) {
        this.key = sortKey;
    }

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        MetadataRepositoryElement m;
        MetadataRepositoryElement repo2;
        MetadataRepositoryElement m2;
        MetadataRepositoryElement repo1 = obj1 instanceof MetadataRepositoryElement ? (m2 = (MetadataRepositoryElement)obj1) : null;
        MetadataRepositoryElement metadataRepositoryElement = repo2 = obj2 instanceof MetadataRepositoryElement ? (m = (MetadataRepositoryElement)obj2) : null;
        if (repo1 == null || repo2 == null) {
            return super.compare(viewer, obj1, obj2);
        }
        int result = this.compare(repo1, repo2, this.key, this.primaryKeyDirection);
        if (result == 0) {
            int secondaryKey = this.getSecondaryKeyFor(this.key);
            if (secondaryKey < 0) {
                return result;
            }
            result = this.compare(repo1, repo2, secondaryKey, 1);
            if (result == 0) {
                result = this.compare(repo1, repo2, this.getSecondaryKeyFor(secondaryKey), 1);
            }
        }
        return result;
    }

    int compare(MetadataRepositoryElement repo1, MetadataRepositoryElement repo2, int sortKey, int direction) {
        String key2;
        String key1;
        switch (sortKey) {
            case 0: {
                key1 = repo1.getName();
                key2 = repo2.getName();
                break;
            }
            case 1: {
                key1 = URIUtil.toUnencodedString((URI)repo1.getLocation());
                key2 = URIUtil.toUnencodedString((URI)repo2.getLocation());
                break;
            }
            default: {
                key1 = repo1.isEnabled() ? ENABLED : BLANK;
                String string = key2 = repo2.isEnabled() ? ENABLED : BLANK;
            }
        }
        if (key1.length() == 0 && key2.length() > 0) {
            return direction;
        }
        if (key1.length() > 0 && key2.length() == 0) {
            return direction * -1;
        }
        return key1.compareToIgnoreCase(key2) * direction;
    }

    private int getSecondaryKeyFor(int primaryKey) {
        if (primaryKey == 2) {
            return 1;
        }
        if (primaryKey == 0) {
            return 1;
        }
        if (primaryKey == 1) {
            return 0;
        }
        return -1;
    }

    public void sortAscending() {
        this.primaryKeyDirection = 1;
    }

    public void sortDescending() {
        this.primaryKeyDirection = -1;
    }

    public boolean isAscending() {
        return this.primaryKeyDirection == 1;
    }

    public void setSortKey(int key) {
        this.key = key;
    }

    public int getSortKey() {
        return this.key;
    }
}

