/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TmfEventTest {
    private static final TmfTestTrace STUB_TRACE = TmfTestTrace.A_TEST_10K;
    private final @NonNull ITmfTrace fTrace = STUB_TRACE.getTrace();
    private final @NonNull String fTypeId = "TestType";
    private final @NonNull String fLabel1 = "AString";
    private final @NonNull String fLabel2 = "AnInteger";
    private final String[] fLabels = new String[]{"AString", "AnInteger"};
    private final TmfEventType fType = new TmfEventType("TestType", TmfEventField.makeRoot((String[])this.fLabels));
    private final Object fValue1a = "Some string";
    private final Object fValue1b = 10;
    private final ITmfEventField fField1a = new TmfEventField("AString", this.fValue1a, null);
    private final ITmfEventField fField1b = new TmfEventField("AnInteger", this.fValue1b, null);
    private final ITmfEventField[] fFields1 = new ITmfEventField[]{this.fField1a, this.fField1b};
    private final @NonNull String fRawContent1 = this.fField1a.toString() + this.fField1b.toString();
    private final ITmfEventField fContent1 = new TmfEventField(this.fRawContent1, null, this.fFields1);
    private final ITmfTimestamp fTimestamp1 = TmfTimestamp.create((long)12345L, (int)2);
    private final @NonNull ITmfEvent fEvent1 = new TmfEvent(this.fTrace, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
    private final Object fValue2a = "Another string";
    private final Object fValue2b = -4;
    private final ITmfEventField fField2a = new TmfEventField("AString", this.fValue2a, null);
    private final ITmfEventField fField2b = new TmfEventField("AnInteger", this.fValue2b, null);
    private final ITmfEventField[] fFields2 = new ITmfEventField[]{this.fField2a, this.fField2b};
    private final @NonNull String fRawContent2 = this.fField2a.toString() + this.fField2b.toString();
    private final ITmfEventField fContent2 = new TmfEventField(this.fRawContent2, null, this.fFields2);
    private final ITmfTimestamp fTimestamp2 = TmfTimestamp.create((long)12350L, (int)2);
    private final @NonNull ITmfEvent fEvent2 = new TmfEvent(this.fTrace, 1L, this.fTimestamp2, (ITmfEventType)this.fType, this.fContent2);

    @After
    public void disposeTrace() {
        this.fTrace.dispose();
    }

    @Test
    public void testDefaultConstructor() {
        TmfEvent event = new TmfEvent(this.fTrace, -1L, null, null, null);
        Assert.assertNotNull((String)"getTrace", (Object)event.getTrace());
        Assert.assertEquals((String)"getRank", (long)-1L, (long)event.getRank());
        Assert.assertEquals((String)"getTimestamp", (Object)TmfTimestamp.ZERO, (Object)event.getTimestamp());
        Assert.assertNull((String)"getType", (Object)event.getType());
        Assert.assertNull((String)"getContent", (Object)event.getContent());
    }

    @Test
    public void testFullConstructor() {
        Assert.assertNotNull((String)"getTrace", (Object)this.fEvent1.getTrace());
        Assert.assertEquals((String)"getRank", (long)0L, (long)this.fEvent1.getRank());
        Assert.assertEquals((String)"getTimestamp", (Object)this.fTimestamp1, (Object)this.fEvent1.getTimestamp());
        Assert.assertEquals((String)"getType", (Object)this.fType, (Object)this.fEvent1.getType());
        Assert.assertEquals((String)"getContent", (Object)this.fContent1, (Object)this.fEvent1.getContent());
        Assert.assertNotNull((String)"getTrace", (Object)this.fEvent2.getTrace());
        Assert.assertEquals((String)"getRank", (long)1L, (long)this.fEvent2.getRank());
        Assert.assertEquals((String)"getTimestamp", (Object)this.fTimestamp2, (Object)this.fEvent2.getTimestamp());
        Assert.assertEquals((String)"getType", (Object)this.fType, (Object)this.fEvent2.getType());
        Assert.assertEquals((String)"getContent", (Object)this.fContent2, (Object)this.fEvent2.getContent());
    }

    @Test
    public void testNoRankConstructor() {
        TmfEvent event = new TmfEvent(this.fTrace, -1L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertNotNull((String)"getTrace", (Object)event.getTrace());
        Assert.assertEquals((String)"getRank", (long)-1L, (long)event.getRank());
        Assert.assertEquals((String)"getTimestamp", (Object)this.fTimestamp1, (Object)event.getTimestamp());
        Assert.assertEquals((String)"getType", (Object)this.fType, (Object)event.getType());
        Assert.assertEquals((String)"getContent", (Object)this.fContent1, (Object)event.getContent());
    }

    @Test
    public void testConstructorWithTrace() {
        ITmfTrace trace = this.fTrace;
        TmfEvent event = new TmfEvent(trace, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertNotNull((String)"getTrace", (Object)event.getTrace());
        Assert.assertEquals((String)"getRank", (long)0L, (long)event.getRank());
        Assert.assertEquals((String)"getTimestamp", (Object)this.fTimestamp1, (Object)event.getTimestamp());
        Assert.assertEquals((String)"getType", (Object)this.fType, (Object)event.getType());
        Assert.assertEquals((String)"getContent", (Object)this.fContent1, (Object)event.getContent());
        trace.dispose();
    }

    @Test
    public void testTmfEventCopy() {
        TmfEvent event = new TmfEvent(this.fEvent1);
        Assert.assertNotNull((String)"getTrace", (Object)event.getTrace());
        Assert.assertEquals((String)"getRank", (long)0L, (long)event.getRank());
        Assert.assertEquals((String)"getTimestamp", (Object)this.fTimestamp1, (Object)event.getTimestamp());
        Assert.assertEquals((String)"getType", (Object)this.fType, (Object)event.getType());
        Assert.assertEquals((String)"getContent", (Object)this.fContent1, (Object)event.getContent());
    }

    @Test
    public void testHashCode() {
        TmfEvent event1 = new TmfEvent(this.fTrace, -1L, null, null, null);
        TmfEvent event2 = new TmfEvent(this.fTrace, -1L, null, null, null);
        Assert.assertTrue((String)"hashCode", (event1.hashCode() == event2.hashCode() ? 1 : 0) != 0);
        ITmfTrace trace = this.fTrace;
        event1 = new TmfEvent(trace, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        event2 = new TmfEvent(trace, 1L, this.fTimestamp2, (ITmfEventType)this.fType, this.fContent2);
        TmfEvent event1b = new TmfEvent((ITmfEvent)event1);
        TmfEvent event2b = new TmfEvent((ITmfEvent)event2);
        Assert.assertTrue((String)"hashCode", (event1.hashCode() == event1b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (event2.hashCode() == event2b.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (event1.hashCode() != event2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (event2.hashCode() != event1.hashCode() ? 1 : 0) != 0);
        trace.dispose();
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fEvent1.equals(this.fEvent1));
        Assert.assertTrue((String)"equals", (boolean)this.fEvent2.equals(this.fEvent2));
        Assert.assertFalse((String)"equals", (boolean)this.fEvent1.equals(this.fEvent2));
        Assert.assertFalse((String)"equals", (boolean)this.fEvent2.equals(this.fEvent1));
    }

    @Test
    public void testEqualsSymmetry() {
        TmfEvent event1 = new TmfEvent(this.fEvent1);
        TmfEvent event2 = new TmfEvent(this.fEvent2);
        Assert.assertTrue((String)"equals", (boolean)event1.equals(this.fEvent1));
        Assert.assertTrue((String)"equals", (boolean)this.fEvent1.equals(event1));
        Assert.assertTrue((String)"equals", (boolean)event2.equals(this.fEvent2));
        Assert.assertTrue((String)"equals", (boolean)this.fEvent2.equals(event2));
    }

    @Test
    public void testEqualsTransivity() {
        TmfEvent event1 = new TmfEvent(this.fEvent1);
        TmfEvent event2 = new TmfEvent(this.fEvent1);
        TmfEvent event3 = new TmfEvent(this.fEvent1);
        Assert.assertTrue((String)"equals", (boolean)event1.equals(event2));
        Assert.assertTrue((String)"equals", (boolean)event2.equals(event3));
        Assert.assertTrue((String)"equals", (boolean)event1.equals(event3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertFalse((String)"equals", (boolean)this.fEvent1.equals(null));
        Assert.assertFalse((String)"equals", (boolean)this.fEvent2.equals(null));
    }

    @Test
    public void testNonEqualClasses() {
        Assert.assertFalse((String)"equals", (boolean)this.fEvent1.equals(this.fEvent1.getType()));
        Assert.assertFalse((String)"equals", (boolean)this.fEvent1.equals(null));
    }

    @Test
    public void testNonEqualTraces() {
        ITmfTrace trace1 = this.fTrace;
        ITmfTrace trace2 = STUB_TRACE.getTrace();
        TmfEvent event1 = new TmfEvent(trace1, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        TmfEvent event2 = new TmfEvent(trace1, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertTrue((String)"equals", (boolean)event1.equals(event2));
        Assert.assertTrue((String)"equals", (boolean)event2.equals(event1));
        event2 = new TmfEvent(trace2, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertFalse((String)"equals", (boolean)event1.equals(event2));
        Assert.assertFalse((String)"equals", (boolean)event2.equals(event1));
        trace2.dispose();
    }

    @Test
    public void testNonEqualRanks() {
        TmfEvent event1 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        TmfEvent event2 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertTrue((String)"equals", (boolean)event1.equals(event2));
        Assert.assertTrue((String)"equals", (boolean)event2.equals(event1));
        event2 = new TmfEvent(null, 1L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertFalse((String)"equals", (boolean)event1.equals(event2));
        Assert.assertFalse((String)"equals", (boolean)event2.equals(event1));
    }

    @Test
    public void testNonEqualTimestamps() {
        TmfEvent event1 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        TmfEvent event2 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertTrue((String)"equals", (boolean)event1.equals(event2));
        Assert.assertTrue((String)"equals", (boolean)event2.equals(event1));
        event2 = new TmfEvent(null, 0L, this.fTimestamp2, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertFalse((String)"equals", (boolean)event1.equals(event2));
        Assert.assertFalse((String)"equals", (boolean)event2.equals(event1));
        event2 = new TmfEvent(null, 0L, null, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertFalse((String)"equals", (boolean)event1.equals(event2));
        Assert.assertFalse((String)"equals", (boolean)event2.equals(event1));
    }

    @Test
    public void testNonEqualTypes() {
        TmfEvent event1 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        TmfEvent event2 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertTrue((String)"equals", (boolean)event1.equals(event2));
        Assert.assertTrue((String)"equals", (boolean)event2.equals(event1));
        String typeId = "OtherTestType";
        String[] labels = new String[]{"AnInteger", "AString"};
        TmfEventType newType = new TmfEventType("OtherTestType", TmfEventField.makeRoot((String[])labels));
        event2 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)newType, this.fContent1);
        Assert.assertFalse((String)"equals", (boolean)event1.equals(event2));
        Assert.assertFalse((String)"equals", (boolean)event2.equals(event1));
        event2 = new TmfEvent(null, 0L, this.fTimestamp1, null, this.fContent1);
        Assert.assertFalse((String)"equals", (boolean)event1.equals(event2));
        Assert.assertFalse((String)"equals", (boolean)event2.equals(event1));
    }

    @Test
    public void testNonEqualContents() {
        TmfEvent event1 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        TmfEvent event2 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent1);
        Assert.assertTrue((String)"equals", (boolean)event1.equals(event2));
        Assert.assertTrue((String)"equals", (boolean)event2.equals(event1));
        event2 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, this.fContent2);
        Assert.assertFalse((String)"equals", (boolean)event1.equals(event2));
        Assert.assertFalse((String)"equals", (boolean)event2.equals(event1));
        event2 = new TmfEvent(null, 0L, this.fTimestamp1, (ITmfEventType)this.fType, null);
        Assert.assertFalse((String)"equals", (boolean)event1.equals(event2));
        Assert.assertFalse((String)"equals", (boolean)event2.equals(event1));
    }

    @Test
    public void testToString() {
        String expected1 = "TmfEvent [fTimestamp=" + String.valueOf(this.fTimestamp1) + ", fTrace=" + String.valueOf(this.fTrace) + ", fRank=0, fType=" + String.valueOf(this.fType) + ", fContent=" + String.valueOf(this.fContent1) + "]";
        Assert.assertEquals((String)"toString", (Object)expected1, (Object)this.fEvent1.toString());
        String expected2 = "TmfEvent [fTimestamp=" + String.valueOf(this.fTimestamp2) + ", fTrace=" + String.valueOf(this.fTrace) + ", fRank=1, fType=" + String.valueOf(this.fType) + ", fContent=" + String.valueOf(this.fContent2) + "]";
        Assert.assertEquals((String)"toString", (Object)expected2, (Object)this.fEvent2.toString());
    }

    @Test
    public void testToStringExtended() {
        class ExtendedEvent
        extends TmfEvent {
            ExtendedEvent(ITmfEvent event) {
                super(event);
            }
        }
        ExtendedEvent event = new ExtendedEvent(this.fEvent1);
        String expected = "ExtendedEvent [fTimestamp=" + String.valueOf(this.fTimestamp1) + ", fTrace=" + String.valueOf(this.fTrace) + ", fRank=0, fType=" + String.valueOf(this.fType) + ", fContent=" + String.valueOf(this.fContent1) + "]";
        Assert.assertEquals((Object)expected, (Object)event.toString());
    }
}

