/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core.tests.htStore;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.tests.AbstractTestSegmentStore;
import org.eclipse.tracecompass.segmentstore.core.tests.historytree.HistoryTreeSegmentStoreStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class HTStoreTest
extends AbstractTestSegmentStore {
    private @Nullable Path fFilePath;

    protected HistoryTreeSegmentStoreStub<@NonNull AbstractTestSegmentStore.TestSegment> getSegmentStore() {
        try {
            Path tmpFile;
            this.fFilePath = tmpFile = Files.createTempFile("tmpSegStore", null, new FileAttribute[0]);
            Assert.assertNotNull((Object)tmpFile);
            return new HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment>(tmpFile, 1L, AbstractTestSegmentStore.TestSegment.DESERIALISER);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create the segment store: " + e.getMessage());
        }
    }

    @Override
    protected ISegmentStore<@NonNull AbstractTestSegmentStore.TestSegment> getSegmentStore(@NonNull AbstractTestSegmentStore.TestSegment @NonNull [] data) {
        try {
            Path tmpFile;
            this.fFilePath = tmpFile = Files.createTempFile("tmpSegStore", null, new FileAttribute[0]);
            Assert.assertNotNull((Object)tmpFile);
            HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment> store = new HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment>(tmpFile, 1L, AbstractTestSegmentStore.TestSegment.DESERIALISER);
            store.addAll(Arrays.asList(data));
            return store;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create the segment store: " + e.getMessage());
        }
    }

    @Override
    @After
    public void teardown() {
        this.fSegmentStore.dispose();
        if (Files.exists(this.fFilePath, new LinkOption[0])) {
            try {
                Files.delete(this.fFilePath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error deleting the file: " + e.getMessage());
            }
        }
    }

    @Override
    protected void assertSegmentsEqual(@Nullable ISegment expected, @Nullable ISegment actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((long)expected.getStart(), (long)actual.getStart());
        Assert.assertEquals((long)expected.getEnd(), (long)actual.getEnd());
        Assert.assertEquals((long)expected.getLength(), (long)actual.getLength());
    }

    @Override
    @Test
    public void testIterationOrderNonSortedInsertion() {
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testToSpecifyArraySubtype() {
        super.testToSpecifyArraySubtype();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testToObjectArray() {
        super.testToObjectArray();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testToSpecificArray() {
        super.testToSpecificArray();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testAddAllConstructor() {
        super.testAddAllConstructor();
    }

    @Test
    public void testReadingSegmentStore() throws IOException {
        Path dirPath = Files.createTempDirectory("tmpSegStoreDir", new FileAttribute[0]);
        Path filePath = Paths.get(dirPath.toString(), "tmpSegStore");
        Assert.assertNotNull((Object)filePath);
        int version = 2;
        try {
            HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment> segmentStore = new HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment>(filePath, 1L, AbstractTestSegmentStore.TestSegment.DESERIALISER, version);
            segmentStore.add(new AbstractTestSegmentStore.TestSegment(1L, 3L, "abc"));
            segmentStore.add(new AbstractTestSegmentStore.TestSegment(2L, 2L, "no duration"));
            segmentStore.finishedBuilding(4L);
            segmentStore.dispose();
            segmentStore = new HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment>(filePath, 1L, AbstractTestSegmentStore.TestSegment.DESERIALISER, version);
            Assert.assertEquals((long)2L, (long)segmentStore.size());
            segmentStore.dispose();
            segmentStore = new HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment>(filePath, 1L, AbstractTestSegmentStore.TestSegment.DESERIALISER, version);
            Assert.assertEquals((long)2L, (long)segmentStore.size());
            Iterator iterator = segmentStore.iterator();
            while (iterator.hasNext()) {
                AbstractTestSegmentStore.TestSegment segment = (AbstractTestSegmentStore.TestSegment)iterator.next();
                if (segment.getStart() == 1L) {
                    Assert.assertEquals((long)3L, (long)segment.getEnd());
                    continue;
                }
                if (segment.getStart() == 2L) {
                    Assert.assertEquals((long)2L, (long)segment.getEnd());
                    continue;
                }
                Assert.fail((String)("Unexpected segment " + String.valueOf(segment)));
            }
            segmentStore.dispose();
        }
        finally {
            Files.delete(filePath);
            Files.delete(dirPath);
        }
    }

    @Test
    public void testSegmentStoreVersion() throws IOException {
        Path dirPath = Files.createTempDirectory("tmpSegStoreDir", new FileAttribute[0]);
        Path filePath = Paths.get(dirPath.toString(), "tmpSegStore");
        Assert.assertNotNull((Object)filePath);
        int version = 1;
        try {
            HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment> segmentStore = new HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment>(filePath, 1L, AbstractTestSegmentStore.TestSegment.DESERIALISER, version);
            segmentStore.add(new AbstractTestSegmentStore.TestSegment(1L, 3L, "abc"));
            segmentStore.finishedBuilding(4L);
            segmentStore.dispose();
            segmentStore = new HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment>(filePath, 1L, AbstractTestSegmentStore.TestSegment.DESERIALISER, version);
            Assert.assertEquals((long)1L, (long)segmentStore.size());
            segmentStore.dispose();
            segmentStore = new HistoryTreeSegmentStoreStub<AbstractTestSegmentStore.TestSegment>(filePath, 1L, AbstractTestSegmentStore.TestSegment.DESERIALISER, version + 1);
            Assert.assertTrue((boolean)segmentStore.isEmpty());
            segmentStore.dispose();
        }
        finally {
            Files.deleteIfExists(filePath);
            Files.deleteIfExists(dirPath);
        }
    }
}

