/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ControlEnableState {
    private List<Control> exceptions = null;
    private final List<ItemState> states = new ArrayList<ItemState>();

    protected ControlEnableState(Control w) {
        this(w, null);
    }

    protected ControlEnableState(Control w, List<Control> exceptions) {
        this.exceptions = exceptions;
        this.readStateForAndDisable(w);
    }

    public static ControlEnableState disable(Control w) {
        return new ControlEnableState(w);
    }

    public static ControlEnableState disable(Control w, List<Control> exceptions) {
        return new ControlEnableState(w, exceptions);
    }

    private void readStateForAndDisable(Control control) {
        if (this.exceptions != null && this.exceptions.contains(control)) {
            return;
        }
        if (control instanceof Composite) {
            Control[] children;
            Composite c = (Composite)control;
            Control[] controlArray = children = c.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                this.readStateForAndDisable(element);
                ++n2;
            }
        }
        this.states.add(new ItemState(control, control.getEnabled()));
        control.setEnabled(false);
    }

    public void restore() {
        int size = this.states.size();
        int i = 0;
        while (i < size) {
            this.states.get(i).restore();
            ++i;
        }
    }

    private static class ItemState {
        protected Control item;
        protected boolean state;

        public ItemState(Control item, boolean state) {
            this.item = item;
            this.state = state;
        }

        public void restore() {
            if (this.item == null || this.item.isDisposed()) {
                return;
            }
            this.item.setEnabled(this.state);
        }
    }
}

