/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;
import org.eclipse.wst.xml.ui.internal.actions.CleanupDialogXML;

public class CleanupdocumentHandler
extends AbstractHandler
implements IHandler {
    private IStructuredCleanupProcessor fCleanupProcessor;

    public void dispose() {
        this.fCleanupProcessor = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null) {
            final ITextEditor finalTextEditor = textEditor;
            CleanupDialogXML cleanupDialog = new CleanupDialogXML(editor.getSite().getShell());
            if (cleanupDialog.open() == 0) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IStructuredCleanupProcessor cleanupProcessor = CleanupdocumentHandler.this.getCleanupProcessor();
                        if (cleanupProcessor != null) {
                            IStructuredModel model = null;
                            try {
                                model = StructuredModelManager.getModelManager().getExistingModelForEdit(finalTextEditor.getDocumentProvider().getDocument((Object)finalTextEditor.getEditorInput()));
                                if (model != null) {
                                    cleanupProcessor.cleanupModel(model);
                                }
                            }
                            finally {
                                if (model != null) {
                                    model.releaseFromEdit();
                                }
                            }
                        }
                    }
                };
                IStructuredModel model = null;
                try {
                    model = StructuredModelManager.getModelManager().getExistingModelForEdit(textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()));
                    if (model != null) {
                        ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
                        model.beginRecording((Object)this, SSEUIMessages.Cleanup_Document_UI_, SSEUIMessages.Cleanup_Document_UI_, selection.getOffset(), selection.getLength());
                        model.aboutToChangeModel();
                        BusyIndicator.showWhile((Display)textEditor.getEditorSite().getWorkbenchWindow().getShell().getDisplay(), (Runnable)runnable);
                    }
                }
                finally {
                    if (model != null) {
                        model.changedModel();
                        ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
                        model.endRecording((Object)this, selection.getOffset(), selection.getLength());
                        model.releaseFromEdit();
                    }
                }
            }
        }
        return null;
    }

    IStructuredCleanupProcessor getCleanupProcessor() {
        if (this.fCleanupProcessor == null) {
            this.fCleanupProcessor = new CleanupProcessorXML();
        }
        return this.fCleanupProcessor;
    }
}

